/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.streamToLoop.ChainContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OptionalToIfContext
extends ChainContext {
    private static final Logger LOG = Logger.getInstance(OptionalToIfContext.class);
    private final ChainExpressionModel myModel;
    private String myInitializer;
    private String myElseBranch;
    private List<String> myLambdaNames;

    OptionalToIfContext(@NotNull PsiExpression chainExpression, @NotNull ChainExpressionModel model) {
        if (chainExpression == null) {
            OptionalToIfContext.$$$reportNull$$$0(0);
        }
        if (model == null) {
            OptionalToIfContext.$$$reportNull$$$0(1);
        }
        super((PsiElement)chainExpression);
        this.myLambdaNames = new ArrayList<String>();
        this.myModel = model;
    }

    @NotNull
    String addInitializer(@NotNull String code) {
        if (code == null) {
            OptionalToIfContext.$$$reportNull$$$0(2);
        }
        code = this.drainBeforeSteps() + code + this.drainAfterSteps();
        if (this.myInitializer == null) {
            String string = code;
            if (string == null) {
                OptionalToIfContext.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.myModel.addInitializer(this.myModel.createInitializer(this.myInitializer), code);
        if (string == null) {
            OptionalToIfContext.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    String createResult(@NotNull String expression2) {
        if (expression2 == null) {
            OptionalToIfContext.$$$reportNull$$$0(5);
        }
        String string = this.myInitializer == null ? this.myModel.createInitializer(expression2) : this.myModel.createResult(expression2);
        if (string == null) {
            OptionalToIfContext.$$$reportNull$$$0(6);
        }
        return string;
    }

    void setInitializer(@NotNull String initializer) {
        if (initializer == null) {
            OptionalToIfContext.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(this.myInitializer == null);
        if (this.myModel.needsAdditionalVariable()) {
            String additionalVarName = this.registerVarName(Arrays.asList("result", "nonFinalResult", "nonFinal"));
            this.myModel.setVarName(additionalVarName);
        }
        this.myInitializer = initializer;
    }

    void setElseBranch(String elseBranch) {
        this.myElseBranch = elseBranch;
    }

    String getElseBranch() {
        return this.myElseBranch;
    }

    @NotNull
    String generateNotNullCondition(@NotNull String arg, @NotNull String code) {
        if (arg == null) {
            OptionalToIfContext.$$$reportNull$$$0(8);
        }
        if (code == null) {
            OptionalToIfContext.$$$reportNull$$$0(9);
        }
        if (this.myElseBranch == null) {
            String string = "if(" + arg + "!=null){\n" + code + "\n}";
            if (string == null) {
                OptionalToIfContext.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = "if(" + arg + "==null)" + this.myElseBranch + code;
        if (string == null) {
            OptionalToIfContext.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    String generateCondition(@NotNull PsiExpression conditional, @NotNull String code) {
        if (conditional == null) {
            OptionalToIfContext.$$$reportNull$$$0(12);
        }
        if (code == null) {
            OptionalToIfContext.$$$reportNull$$$0(13);
        }
        if (this.myElseBranch == null) {
            return "if(" + conditional.getText() + "){\n" + code + "\n}";
        }
        String negated = BoolUtils.getNegatedExpressionText(conditional, new CommentTracker());
        return "if(" + negated + ")" + this.myElseBranch + code;
    }

    boolean isUsedLambdaVarName(String name2) {
        return this.myLambdaNames.contains(name2);
    }

    void addLambdaVarName(@NotNull String name2) {
        if (name2 == null) {
            OptionalToIfContext.$$$reportNull$$$0(14);
        }
        this.myLambdaNames.add(name2);
    }

    @Nullable
    static OptionalToIfContext create(@NotNull PsiExpression chainExpression) {
        PsiStatement chainStatement;
        if (chainExpression == null) {
            OptionalToIfContext.$$$reportNull$$$0(15);
        }
        if ((chainStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)chainExpression, PsiStatement.class)) == null) {
            return null;
        }
        ChainExpressionModel model = ChainExpressionModel.create(chainStatement, chainExpression);
        if (model == null) {
            return null;
        }
        return new OptionalToIfContext(chainExpression, model);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chainExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/optionalToIf/OptionalToIfContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditional";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/optionalToIf/OptionalToIfContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addInitializer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createResult";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNotNullCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addInitializer";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createResult";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setInitializer";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateNotNullCondition";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateCondition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addLambdaVarName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChainDeclaration
    extends ChainExpressionModel {
        private final PsiLocalVariable myVariable;
        private String myName;

        ChainDeclaration(@Nullable String name2, @NotNull PsiLocalVariable variable) {
            if (variable == null) {
                ChainDeclaration.$$$reportNull$$$0(0);
            }
            this.myName = name2;
            this.myVariable = variable;
        }

        @Override
        boolean needsAdditionalVariable() {
            return !this.myVariable.getName().equals(this.myName);
        }

        @Override
        public void setVarName(@NotNull String name2) {
            if (name2 == null) {
                ChainDeclaration.$$$reportNull$$$0(1);
            }
            this.myName = name2;
        }

        @Override
        @NotNull
        String createResult(@NotNull String expression2) {
            if (expression2 == null) {
                ChainDeclaration.$$$reportNull$$$0(2);
            }
            LOG.assertTrue(this.myName != null);
            String string = this.myName + "=" + expression2 + ";";
            if (string == null) {
                ChainDeclaration.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        String createInitializer(@NotNull String expression2) {
            if (expression2 == null) {
                ChainDeclaration.$$$reportNull$$$0(4);
            }
            if (this.myName == null || !this.needsAdditionalVariable()) {
                String string = this.declareVariable(expression2);
                if (string == null) {
                    ChainDeclaration.$$$reportNull$$$0(5);
                }
                return string;
            }
            String typeText = this.myVariable.getType().getCanonicalText();
            String string = typeText + " " + this.myName + "=" + expression2 + ";";
            if (string == null) {
                ChainDeclaration.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @NotNull
        String addInitializer(@NotNull String initializer, @NotNull String code) {
            if (initializer == null) {
                ChainDeclaration.$$$reportNull$$$0(7);
            }
            if (code == null) {
                ChainDeclaration.$$$reportNull$$$0(8);
            }
            String string = this.needsAdditionalVariable() ? initializer + code + this.declareVariable(this.myName) : initializer + code;
            if (string == null) {
                ChainDeclaration.$$$reportNull$$$0(9);
            }
            return string;
        }

        private String declareVariable(@NotNull String expression2) {
            PsiModifierList modifierList;
            if (expression2 == null) {
                ChainDeclaration.$$$reportNull$$$0(10);
            }
            PsiLocalVariable copy = (PsiLocalVariable)this.myVariable.copy();
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)this.myVariable.getProject());
            copy.setInitializer(factory.createExpressionFromText(expression2, (PsiElement)this.myVariable));
            if (!this.needsAdditionalVariable() && (modifierList = copy.getModifierList()) != null) {
                modifierList.setModifierProperty("final", false);
            }
            return copy.getText();
        }

        @Nullable
        static ChainDeclaration create(@NotNull PsiDeclarationStatement declaration2, @NotNull PsiExpression chainExpression) {
            PsiElement[] elements;
            if (declaration2 == null) {
                ChainDeclaration.$$$reportNull$$$0(11);
            }
            if (chainExpression == null) {
                ChainDeclaration.$$$reportNull$$$0(12);
            }
            if ((elements = declaration2.getDeclaredElements()).length != 1) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class);
            if (variable == null || PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()) != chainExpression) {
                return null;
            }
            boolean needsAdditionalVariable = !VariableAccessUtils.canUseAsNonFinal(variable);
            String name2 = needsAdditionalVariable ? null : variable.getName();
            return new ChainDeclaration(name2, variable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 4: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/optionalToIf/OptionalToIfContext$ChainDeclaration";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chainExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/optionalToIf/OptionalToIfContext$ChainDeclaration";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createResult";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInitializer";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addInitializer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setVarName";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createResult";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 9: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createInitializer";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addInitializer";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "declareVariable";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ChainAssignment
    extends ChainExpressionModel {
        private final String myName;

        private ChainAssignment(@NotNull String name2) {
            if (name2 == null) {
                ChainAssignment.$$$reportNull$$$0(0);
            }
            this.myName = name2;
        }

        @Override
        @NotNull
        String createResult(@NotNull String expression2) {
            if (expression2 == null) {
                ChainAssignment.$$$reportNull$$$0(1);
            }
            String string = this.myName + "=" + expression2 + ";";
            if (string == null) {
                ChainAssignment.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        String createInitializer(@NotNull String expression2) {
            if (expression2 == null) {
                ChainAssignment.$$$reportNull$$$0(3);
            }
            String string = this.createResult(expression2);
            if (string == null) {
                ChainAssignment.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        String addInitializer(@NotNull String initializer, @NotNull String code) {
            if (initializer == null) {
                ChainAssignment.$$$reportNull$$$0(5);
            }
            if (code == null) {
                ChainAssignment.$$$reportNull$$$0(6);
            }
            String string = initializer + code;
            if (string == null) {
                ChainAssignment.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Nullable
        static ChainExpressionModel create(@NotNull PsiAssignmentExpression assignment, @NotNull PsiExpression chainExpression) {
            if (assignment == null) {
                ChainAssignment.$$$reportNull$$$0(8);
            }
            if (chainExpression == null) {
                ChainAssignment.$$$reportNull$$$0(9);
            }
            if (PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()) != chainExpression) {
                return null;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
            if (ref == null) {
                return null;
            }
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
            if (variable == null || variable.hasModifierProperty("final")) {
                return null;
            }
            String name2 = variable.getName();
            return name2 == null ? null : new ChainAssignment(name2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/optionalToIf/OptionalToIfContext$ChainAssignment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chainExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/optionalToIf/OptionalToIfContext$ChainAssignment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createResult";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInitializer";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addInitializer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createResult";
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createInitializer";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addInitializer";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ChainReturn
    extends ChainExpressionModel {
        private final PsiReturnStatement myChainReturnCopy;
        private PsiExpression myChainExpressionCopy;

        private ChainReturn(@NotNull PsiReturnStatement chainReturnCopy, @NotNull PsiExpression chainExpressionCopy) {
            if (chainReturnCopy == null) {
                ChainReturn.$$$reportNull$$$0(0);
            }
            if (chainExpressionCopy == null) {
                ChainReturn.$$$reportNull$$$0(1);
            }
            this.myChainReturnCopy = chainReturnCopy;
            this.myChainExpressionCopy = chainExpressionCopy;
        }

        @Override
        @NotNull
        String createResult(@NotNull String expression2) {
            if (expression2 == null) {
                ChainReturn.$$$reportNull$$$0(2);
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myChainExpressionCopy.getProject()).getElementFactory();
            PsiExpression newExpression = factory.createExpressionFromText(expression2, (PsiElement)this.myChainExpressionCopy);
            this.myChainExpressionCopy = (PsiExpression)this.myChainExpressionCopy.replace((PsiElement)newExpression);
            String string = this.myChainReturnCopy.getText();
            if (string == null) {
                ChainReturn.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        String createInitializer(@NotNull String expression2) {
            if (expression2 == null) {
                ChainReturn.$$$reportNull$$$0(4);
            }
            String string = this.createResult(expression2);
            if (string == null) {
                ChainReturn.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        String addInitializer(@NotNull String initializer, @NotNull String code) {
            if (initializer == null) {
                ChainReturn.$$$reportNull$$$0(6);
            }
            if (code == null) {
                ChainReturn.$$$reportNull$$$0(7);
            }
            String string = code + initializer;
            if (string == null) {
                ChainReturn.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Nullable
        private static ChainReturn create(@NotNull PsiReturnStatement chainReturn, @NotNull PsiExpression chainExpression) {
            if (chainReturn == null) {
                ChainReturn.$$$reportNull$$$0(9);
            }
            if (chainExpression == null) {
                ChainReturn.$$$reportNull$$$0(10);
            }
            if (PsiUtil.skipParenthesizedExprDown((PsiExpression)chainReturn.getReturnValue()) != chainExpression) {
                return null;
            }
            Object mark = new Object();
            PsiTreeUtil.mark((PsiElement)chainExpression, (Object)mark);
            PsiReturnStatement chainReturnCopy = (PsiReturnStatement)ObjectUtils.tryCast((Object)chainReturn.copy(), PsiReturnStatement.class);
            if (chainReturnCopy == null) {
                return null;
            }
            PsiExpression chainExpressionCopy = (PsiExpression)ObjectUtils.tryCast((Object)PsiTreeUtil.releaseMark((PsiElement)chainReturnCopy, (Object)mark), PsiExpression.class);
            if (chainExpressionCopy == null) {
                return null;
            }
            return new ChainReturn(chainReturnCopy, chainExpressionCopy);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chainReturnCopy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chainExpressionCopy";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/optionalToIf/OptionalToIfContext$ChainReturn";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chainReturn";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chainExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/optionalToIf/OptionalToIfContext$ChainReturn";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createResult";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInitializer";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addInitializer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createResult";
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createInitializer";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addInitializer";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ChainStatement
    extends ChainExpressionModel {
        private ChainStatement() {
        }

        @Override
        @NotNull
        String createResult(@NotNull String expression2) {
            if (expression2 == null) {
                ChainStatement.$$$reportNull$$$0(0);
            }
            return "";
        }

        @Override
        @NotNull
        String createInitializer(@NotNull String expression2) {
            if (expression2 == null) {
                ChainStatement.$$$reportNull$$$0(1);
            }
            return "";
        }

        @Override
        @NotNull
        String addInitializer(@NotNull String initializer, @NotNull String code) {
            if (initializer == null) {
                ChainStatement.$$$reportNull$$$0(2);
            }
            if (code == null) {
                ChainStatement.$$$reportNull$$$0(3);
            }
            String string = code;
            if (string == null) {
                ChainStatement.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/optionalToIf/OptionalToIfContext$ChainStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/optionalToIf/OptionalToIfContext$ChainStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addInitializer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createInitializer";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addInitializer";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class ChainExpressionModel {
        private ChainExpressionModel() {
        }

        @NotNull
        abstract String createResult(@NotNull String var1);

        @NotNull
        abstract String createInitializer(@NotNull String var1);

        @NotNull
        abstract String addInitializer(@NotNull String var1, @NotNull String var2);

        boolean needsAdditionalVariable() {
            return false;
        }

        public void setVarName(@NotNull String name2) {
            if (name2 == null) {
                ChainExpressionModel.$$$reportNull$$$0(0);
            }
        }

        @Nullable
        static ChainExpressionModel create(@NotNull PsiStatement chainStatement, @NotNull PsiExpression chainExpression) {
            PsiReturnStatement returnStatement;
            if (chainStatement == null) {
                ChainExpressionModel.$$$reportNull$$$0(1);
            }
            if (chainExpression == null) {
                ChainExpressionModel.$$$reportNull$$$0(2);
            }
            if ((returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)chainStatement, PsiReturnStatement.class)) != null) {
                return ChainReturn.create(returnStatement, chainExpression);
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)chainStatement);
            if (assignment != null) {
                return ChainAssignment.create(assignment, chainExpression);
            }
            PsiDeclarationStatement declaration2 = (PsiDeclarationStatement)ObjectUtils.tryCast((Object)chainStatement, PsiDeclarationStatement.class);
            if (declaration2 != null) {
                return ChainDeclaration.create(declaration2, chainExpression);
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)chainStatement, PsiExpressionStatement.class);
            if (expressionStatement != null && PsiUtil.skipParenthesizedExprDown((PsiExpression)expressionStatement.getExpression()) == chainExpression) {
                return new ChainStatement();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chainStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chainExpression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/OptionalToIfContext$ChainExpressionModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setVarName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

