/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.optionalToIf;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.optionalToIf.Instruction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface Simplifier {
    public static final Simplifier[] SIMPLIFIERS = new Simplifier[]{new RemoveChecks(), new MergeChecks(), new RemoveAfterReturnOrThrow(), new MergeImmediateReturn(), new MergeImmediateAssignment()};

    public List<Instruction> run(@NotNull List<Instruction> var1);

    @NotNull
    public static String simplify(@NotNull List<Instruction> instructions) {
        if (instructions == null) {
            Simplifier.$$$reportNull$$$0(0);
        }
        String string = ((List)StreamEx.of((Object[])SIMPLIFIERS).foldLeft(instructions, (acc, s) -> s.run((List<Instruction>)acc))).stream().map(Instruction::generate).collect(Collectors.joining());
        if (string == null) {
            Simplifier.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/optionalToIf/Simplifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/optionalToIf/Simplifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "simplify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "simplify";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MergeImmediateAssignment
    implements Simplifier {
        @Override
        public List<Instruction> run(@NotNull List<Instruction> instructions) {
            if (instructions == null) {
                MergeImmediateAssignment.$$$reportNull$$$0(0);
            }
            ArrayList<Instruction> simplified = new ArrayList<Instruction>();
            Instruction prev = null;
            for (Instruction instruction : instructions) {
                Instruction.Assignment assignment = (Instruction.Assignment)ObjectUtils.tryCast((Object)instruction, Instruction.Assignment.class);
                if (assignment != null) {
                    Instruction.Declaration declaration2 = (Instruction.Declaration)ObjectUtils.tryCast(prev, Instruction.Declaration.class);
                    if (declaration2 != null && declaration2.myLhs == assignment.myLhs) {
                        Instruction.Declaration merged = new Instruction.Declaration(declaration2.myLhs, assignment.myRhs);
                        simplified.set(simplified.size() - 1, merged);
                        prev = merged;
                        continue;
                    }
                } else {
                    Instruction.Check check = (Instruction.Check)ObjectUtils.tryCast((Object)instruction, Instruction.Check.class);
                    if (check != null && !check.hasElseBranch()) {
                        check.myInstructions = this.run(check.myInstructions);
                    }
                }
                simplified.add(instruction);
                prev = instruction;
            }
            return simplified;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructions", "com/intellij/codeInspection/optionalToIf/Simplifier$MergeImmediateAssignment", "run"));
        }
    }

    public static class MergeImmediateReturn
    implements Simplifier {
        @Override
        public List<Instruction> run(@NotNull List<Instruction> instructions) {
            if (instructions == null) {
                MergeImmediateReturn.$$$reportNull$$$0(0);
            }
            ArrayList<Instruction> simplified = new ArrayList<Instruction>();
            Instruction prev = null;
            for (Instruction instruction : instructions) {
                Instruction.Return ret = (Instruction.Return)ObjectUtils.tryCast((Object)instruction, Instruction.Return.class);
                if (ret != null) {
                    Instruction.Return merged = this.mergeReturn(ret, prev);
                    if (merged != null) {
                        simplified.set(simplified.size() - 1, merged);
                        prev = merged;
                        continue;
                    }
                } else {
                    Instruction.Check check = (Instruction.Check)ObjectUtils.tryCast((Object)instruction, Instruction.Check.class);
                    if (check != null && !check.hasElseBranch()) {
                        check.myInstructions = this.run(check.myInstructions);
                    }
                }
                simplified.add(instruction);
                prev = instruction;
            }
            return simplified;
        }

        @Nullable
        private Instruction.Return mergeReturn(@NotNull Instruction.Return ret, @Nullable Instruction prev) {
            PsiVariable retVariable;
            if (ret == null) {
                MergeImmediateReturn.$$$reportNull$$$0(1);
            }
            if ((retVariable = this.getReturnVariable(ret)) == null) {
                return null;
            }
            Instruction.Declaration declaration2 = (Instruction.Declaration)ObjectUtils.tryCast((Object)prev, Instruction.Declaration.class);
            if (declaration2 != null) {
                return MergeImmediateReturn.mergeReturn(retVariable, declaration2.myLhs, declaration2.myRhs);
            }
            Instruction.Assignment assignment = (Instruction.Assignment)ObjectUtils.tryCast((Object)prev, Instruction.Assignment.class);
            if (assignment != null) {
                return MergeImmediateReturn.mergeReturn(retVariable, assignment.myLhs, assignment.myRhs);
            }
            return null;
        }

        @Nullable
        PsiVariable getReturnVariable(@NotNull Instruction.Return ret) {
            PsiReference reference;
            if (ret == null) {
                MergeImmediateReturn.$$$reportNull$$$0(2);
            }
            if ((reference = (PsiReference)ObjectUtils.tryCast((Object)ret.myExpression, PsiReference.class)) == null) {
                return null;
            }
            return (PsiVariable)ObjectUtils.tryCast((Object)reference.resolve(), PsiVariable.class);
        }

        @Nullable
        @Contract(pure=true)
        private static Instruction.Return mergeReturn(@NotNull PsiVariable retVariable, @NotNull PsiVariable lhs, @NotNull PsiExpression rhs) {
            if (retVariable == null) {
                MergeImmediateReturn.$$$reportNull$$$0(3);
            }
            if (lhs == null) {
                MergeImmediateReturn.$$$reportNull$$$0(4);
            }
            if (rhs == null) {
                MergeImmediateReturn.$$$reportNull$$$0(5);
            }
            return retVariable != lhs ? null : new Instruction.Return(rhs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instructions";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ret";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "retVariable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lhs";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rhs";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/optionalToIf/Simplifier$MergeImmediateReturn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeReturn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getReturnVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class RemoveAfterReturnOrThrow
    implements Simplifier {
        @Override
        public List<Instruction> run(@NotNull List<Instruction> instructions) {
            if (instructions == null) {
                RemoveAfterReturnOrThrow.$$$reportNull$$$0(0);
            }
            ArrayList<Instruction> simplified = new ArrayList<Instruction>();
            for (Instruction instruction : instructions) {
                Instruction.Check check = (Instruction.Check)ObjectUtils.tryCast((Object)instruction, Instruction.Check.class);
                if (check != null && !check.hasElseBranch()) {
                    check.myInstructions = this.run(check.myInstructions);
                }
                simplified.add(instruction);
                if (!(instruction instanceof Instruction.Return) && !(instruction instanceof Instruction.Throw)) continue;
                return simplified;
            }
            return simplified;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructions", "com/intellij/codeInspection/optionalToIf/Simplifier$RemoveAfterReturnOrThrow", "run"));
        }
    }

    public static class MergeChecks
    implements Simplifier {
        @Override
        @NotNull
        public List<Instruction> run(@NotNull List<Instruction> instructions) {
            if (instructions == null) {
                MergeChecks.$$$reportNull$$$0(0);
            }
            ArrayList<Instruction> simplified = new ArrayList<Instruction>();
            Instruction prev = null;
            for (Instruction instruction : instructions) {
                Instruction.Check check = (Instruction.Check)ObjectUtils.tryCast((Object)instruction, Instruction.Check.class);
                if (check != null && !check.hasElseBranch()) {
                    Instruction.Check merged;
                    check.myInstructions = this.run(check.myInstructions);
                    check = MergeChecks.mergeWithInner(check);
                    instruction = check;
                    Instruction.Check prevCheck = (Instruction.Check)ObjectUtils.tryCast((Object)prev, Instruction.Check.class);
                    if (prevCheck != null && !prevCheck.hasElseBranch() && (merged = MergeChecks.mergeChecks(prevCheck, check)) != null) {
                        prev = merged;
                        simplified.set(simplified.size() - 1, prev);
                        continue;
                    }
                }
                prev = instruction;
                simplified.add(instruction);
            }
            ArrayList<Instruction> arrayList = simplified;
            if (arrayList == null) {
                MergeChecks.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        @NotNull
        private static Instruction.Check mergeWithInner(@NotNull Instruction.Check check) {
            Instruction.Check innerCheck;
            if (check == null) {
                MergeChecks.$$$reportNull$$$0(2);
            }
            if ((innerCheck = (Instruction.Check)ObjectUtils.tryCast((Object)MergeChecks.getSingleInstruction(check), Instruction.Check.class)) == null) {
                Instruction.Check check2 = check;
                if (check2 == null) {
                    MergeChecks.$$$reportNull$$$0(3);
                }
                return check2;
            }
            List<Instruction> checkInstructions = innerCheck.myInstructions;
            PsiExpression conjunction = MergeChecks.mergeConditions(check, innerCheck, "&&");
            return new Instruction.Check(conjunction, checkInstructions, null);
        }

        @NotNull
        private static PsiExpression mergeConditions(@NotNull Instruction.Check c1, @NotNull Instruction.Check c2, @NotNull String operator2) {
            if (c1 == null) {
                MergeChecks.$$$reportNull$$$0(4);
            }
            if (c2 == null) {
                MergeChecks.$$$reportNull$$$0(5);
            }
            if (operator2 == null) {
                MergeChecks.$$$reportNull$$$0(6);
            }
            PsiExpression cond1 = c1.myCondition;
            PsiExpression cond2 = c2.myCondition;
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)cond1.getProject());
            PsiExpression psiExpression = factory.createExpressionFromText(ParenthesesUtils.getText(cond1, 14) + operator2 + ParenthesesUtils.getText(cond2, 14), (PsiElement)cond1);
            if (psiExpression == null) {
                MergeChecks.$$$reportNull$$$0(7);
            }
            return psiExpression;
        }

        @Nullable
        private static Instruction.Check mergeChecks(@NotNull Instruction prev, @NotNull Instruction.Check check) {
            Instruction.Check prevCheck;
            if (prev == null) {
                MergeChecks.$$$reportNull$$$0(8);
            }
            if (check == null) {
                MergeChecks.$$$reportNull$$$0(9);
            }
            if ((prevCheck = (Instruction.Check)ObjectUtils.tryCast((Object)prev, Instruction.Check.class)) == null) {
                return null;
            }
            Instruction.Throw prevThrow = (Instruction.Throw)ObjectUtils.tryCast((Object)MergeChecks.getSingleInstruction(prevCheck), Instruction.Throw.class);
            if (prevThrow == null) {
                return null;
            }
            Instruction.Throw curThrow = (Instruction.Throw)ObjectUtils.tryCast((Object)MergeChecks.getSingleInstruction(check), Instruction.Throw.class);
            if (curThrow == null) {
                return null;
            }
            boolean isSameException = EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(prevThrow.myException, curThrow.myException);
            if (!isSameException) {
                return null;
            }
            PsiExpression disjunction = MergeChecks.mergeConditions(prevCheck, check, "||");
            return new Instruction.Check(disjunction, check.myInstructions, null);
        }

        private static Instruction getSingleInstruction(@NotNull Instruction.Check check) {
            if (check == null) {
                MergeChecks.$$$reportNull$$$0(10);
            }
            return (Instruction)ContainerUtil.getOnlyItem(check.myInstructions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instructions";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/optionalToIf/Simplifier$MergeChecks";
                    break;
                }
                case 2: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "check";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c2";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operator";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prev";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/optionalToIf/Simplifier$MergeChecks";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mergeWithInner";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "mergeConditions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeWithInner";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeConditions";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "mergeChecks";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getSingleInstruction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RemoveChecks
    implements Simplifier {
        @Override
        public List<Instruction> run(@NotNull List<Instruction> instructions) {
            if (instructions == null) {
                RemoveChecks.$$$reportNull$$$0(0);
            }
            ArrayList<Instruction> simplified = new ArrayList<Instruction>();
            for (Instruction instruction : instructions) {
                Instruction.Check check = (Instruction.Check)ObjectUtils.tryCast((Object)instruction, Instruction.Check.class);
                if (check != null && !check.hasElseBranch()) {
                    Boolean res;
                    Boolean bl = res = check.myInstructions.isEmpty() ? Boolean.FALSE : DfaUtil.evaluateCondition(check.myCondition);
                    if (Boolean.FALSE.equals(res)) continue;
                    check.myInstructions = this.run(check.myInstructions);
                    if (check.myInstructions.isEmpty() || Boolean.TRUE.equals(res)) {
                        simplified.addAll(check.myInstructions);
                        continue;
                    }
                }
                simplified.add(instruction);
            }
            return simplified;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instructions", "com/intellij/codeInspection/optionalToIf/Simplifier$RemoveChecks", "run"));
        }
    }
}

