/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.util.TripleFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessagesContainer {
    private static final Logger LOG = Logger.getInstance(MessagesContainer.class);
    private static final int JAVAC_TAB_SIZE = 8;
    private final Project myProject;
    private final Map<CompilerMessageCategory, Collection<CompilerMessage>> myMessages;
    private final int myTabSize;

    public MessagesContainer(@NotNull Project project) {
        if (project == null) {
            MessagesContainer.$$$reportNull$$$0(0);
        }
        this.myMessages = new EnumMap<CompilerMessageCategory, Collection<CompilerMessage>>(CompilerMessageCategory.class);
        this.myProject = project;
        this.myTabSize = MessagesContainer.getTabSize(project);
    }

    private static int getTabSize(@NotNull Project project) {
        if (project == null) {
            MessagesContainer.$$$reportNull$$$0(1);
        }
        try {
            return CodeStyle.getSettings((Project)project).getTabSize((FileType)JavaFileType.INSTANCE);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Cannot compute tab size", (Throwable)e);
            return 4;
        }
    }

    @NotNull
    public Collection<CompilerMessage> getMessages(@NotNull CompilerMessageCategory category) {
        Collection<CompilerMessage> collection;
        if (category == null) {
            MessagesContainer.$$$reportNull$$$0(2);
        }
        if ((collection = this.myMessages.get(category)) == null) {
            List<CompilerMessage> list = Collections.emptyList();
            if (list == null) {
                MessagesContainer.$$$reportNull$$$0(3);
            }
            return list;
        }
        Collection<CompilerMessage> collection2 = Collections.unmodifiableCollection(collection);
        if (collection2 == null) {
            MessagesContainer.$$$reportNull$$$0(4);
        }
        return collection2;
    }

    @Nullable
    public CompilerMessage addMessage(CompilerMessageCategory category, String message2, String url, int lineNum, int columnNum, Navigatable navigatable) {
        CompilerMessageImpl msg = new CompilerMessageImpl(this.myProject, category, message2, MessagesContainer.findFileByUrl(url), lineNum, columnNum, navigatable);
        if (this.addMessage(msg)) {
            msg.setColumnAdjuster((TripleFunction<? super CompilerMessage, ? super Integer, ? super Integer, Integer>)((TripleFunction)(m, line, col) -> this.adjustColumn((CompilerMessage)m, (int)line, (int)col)));
            return msg;
        }
        return null;
    }

    private int adjustColumn(CompilerMessage m, int line, int col) {
        int tabCount;
        VirtualFile file;
        if (this.myTabSize != 8 && line >= 1 && (file = m.getVirtualFile()) != null && file.isValid() && (tabCount = ((Integer)ApplicationManager.getApplication().runReadAction(() -> {
            Document doc = FileDocumentManager.getInstance().getDocument(file);
            if (doc == null) {
                return 0;
            }
            int tcount = 0;
            CharSequence seq = doc.getCharsSequence();
            int start = doc.getLineStartOffset(line);
            int end = doc.getLineEndOffset(line);
            int charsExpanded = 0;
            for (int i = start; i < end; ++i) {
                if (seq.charAt(i) == '\t') {
                    charsExpanded += 8;
                    ++tcount;
                } else {
                    ++charsExpanded;
                }
                if (charsExpanded >= col) break;
            }
            return tcount;
        })).intValue()) > 0) {
            return Math.max(0, col + tabCount * (this.myTabSize - 8));
        }
        return col;
    }

    public boolean addMessage(CompilerMessage msg) {
        Collection messages = this.myMessages.computeIfAbsent(msg.getCategory(), k -> new LinkedHashSet());
        return messages.add(msg);
    }

    @Nullable
    private static VirtualFile findFileByUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            return VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
        }
        return file;
    }

    public int getMessageCount(@Nullable CompilerMessageCategory category) {
        if (category != null) {
            Collection<CompilerMessage> collection = this.myMessages.get(category);
            return collection != null ? collection.size() : 0;
        }
        return this.myMessages.values().stream().filter(Objects::nonNull).mapToInt(Collection::size).sum();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/MessagesContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/MessagesContainer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTabSize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMessages";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

