/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.DynamicBundle;
import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfigurable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ValidationConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private JCheckBox myValidateBox;
    private ElementsChooser<Validator> myValidators;
    private JPanel myExcludedEntriesPanel;
    private JPanel myValidatorsPanel;
    private final Project myProject;
    private final ValidationConfiguration myConfiguration;
    private final ExcludedEntriesConfigurable myExcludedConfigurable;

    public ValidationConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myConfiguration = ValidationConfiguration.getInstance(this.myProject);
        this.myExcludedConfigurable = ValidationConfigurable.createExcludedConfigurable(project);
        this.myValidatorsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JavaCompilerBundle.message((String)"settings.validators", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myValidators.getEmptyText().setText(JavaCompilerBundle.message((String)"no.validators", (Object[])new Object[0]));
        this.myExcludedEntriesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JavaCompilerBundle.message((String)"settings.exclude.from.validation", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
    }

    private static ExcludedEntriesConfigurable createExcludedConfigurable(@NotNull Project project) {
        if (project == null) {
            ValidationConfigurable.$$$reportNull$$$0(0);
        }
        final ProjectFileIndex index = project.isDefault() ? null : ProjectRootManager.getInstance((Project)project).getFileIndex();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (index == null || !index.isExcluded(file));
            }
        };
        ArrayList allContentRoots = new ArrayList();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            VirtualFile[] moduleContentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            Collections.addAll(allContentRoots, moduleContentRoots);
        }
        descriptor.setRoots(allContentRoots);
        return new ExcludedEntriesConfigurable(project, descriptor, ValidationConfiguration.getExcludedEntriesConfiguration(project));
    }

    @NotNull
    public String getId() {
        return "project.validation";
    }

    public String getDisplayName() {
        return JavaCompilerBundle.message((String)"validation.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.validation";
    }

    public JComponent createComponent() {
        GridConstraints constraints = new GridConstraints();
        constraints.setFill(3);
        this.myExcludedEntriesPanel.add((Component)this.myExcludedConfigurable.createComponent(), constraints);
        return this.myPanel;
    }

    public boolean isModified() {
        List selectedElements = this.myValidators.getMarkedElements();
        List<Validator> markedValidators = this.getMarkedValidators(ContainerUtil.concat((List)selectedElements, (List)this.myValidators.getElements(false)));
        if (markedValidators.size() != selectedElements.size()) {
            return true;
        }
        THashSet set = new THashSet((Collection)selectedElements, (TObjectHashingStrategy)new TObjectHashingStrategy<Validator>(){

            public int computeHashCode(Validator object) {
                return object.getId().hashCode();
            }

            public boolean equals(Validator o1, Validator o2) {
                return o1.getId().equals(o2.getId());
            }
        });
        return this.myConfiguration.isValidateOnBuild() != this.myValidateBox.isSelected() || set.retainAll(markedValidators) || this.myExcludedConfigurable.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.setValidateOnBuild(this.myValidateBox.isSelected());
        for (int i = 0; i < this.myValidators.getElementCount(); ++i) {
            Validator validator2 = (Validator)this.myValidators.getElementAt(i);
            this.myConfiguration.setSelected(validator2, this.myValidators.isElementMarked((Object)validator2));
        }
        this.myExcludedConfigurable.apply();
    }

    public void reset() {
        this.myValidateBox.setSelected(this.myConfiguration.isValidateOnBuild());
        List<Validator> allValidators = this.getValidators();
        allValidators.sort(Comparator.comparing(Compiler::getDescription));
        this.myValidators.setElements(allValidators, false);
        this.myValidators.markElements(this.getMarkedValidators(allValidators));
        this.myExcludedConfigurable.reset();
    }

    private List<Validator> getMarkedValidators(@NotNull List<Validator> validators) {
        if (validators == null) {
            ValidationConfigurable.$$$reportNull$$$0(1);
        }
        return ContainerUtil.mapNotNull(validators, (Function)((NullableFunction)validator2 -> this.myConfiguration.isSelected((Validator)validator2) ? validator2 : null));
    }

    private List<Validator> getValidators() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        return new SmartList((Object[])((Validator[])compilerManager.getCompilers(Validator.class)));
    }

    public void disposeUIResources() {
        this.myExcludedConfigurable.disposeUIResources();
    }

    private void createUIComponents() {
        this.myValidators = new ElementsChooser<Validator>(true){

            protected String getItemText(@NotNull Validator validator2) {
                if (validator2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return validator2.getDescription();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "com/intellij/compiler/options/ValidationConfigurable$3", "getItemText"));
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myValidateBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/JavaCompilerBundle", ValidationConfigurable.class).getString("settings.validate.on.build"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myValidatorsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ElementsChooser<Validator> elementsChooser = this.myValidators;
        jPanel2.add((Component)elementsChooser, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
        this.myExcludedEntriesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Splitter splitter = new Splitter();
        splitter.setOrientation(true);
        jPanel4.add((Component)splitter, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        splitter.setFirstComponent((JComponent)jPanel2);
        splitter.setSecondComponent((JComponent)jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validators";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/options/ValidationConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createExcludedConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMarkedValidators";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

