/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.RemappedSourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PositionManagerImpl
implements PositionManager,
MultiRequestPositionManager {
    private static final Logger LOG = Logger.getInstance(PositionManagerImpl.class);
    private final DebugProcessImpl myDebugProcess;

    public PositionManagerImpl(DebugProcessImpl debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type2, @NotNull SourcePosition position) throws NoDataException {
        List<Location> list;
        if (type2 == null) {
            PositionManagerImpl.$$$reportNull$$$0(0);
        }
        if (position == null) {
            PositionManagerImpl.$$$reportNull$$$0(1);
        }
        try {
            int line = position.getLine() + 1;
            list = type2.locationsOfLine("Java", null, line);
        }
        catch (AbsentInformationException absentInformationException) {
            List<Location> list2 = Collections.emptyList();
            if (list2 == null) {
                PositionManagerImpl.$$$reportNull$$$0(3);
            }
            return list2;
        }
        if (list == null) {
            PositionManagerImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            PositionManagerImpl.$$$reportNull$$$0(4);
        }
        if (position == null) {
            PositionManagerImpl.$$$reportNull$$$0(5);
        }
        throw new IllegalStateException("This class implements MultiRequestPositionManager, corresponding createPrepareRequests version should be used");
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            PositionManagerImpl.$$$reportNull$$$0(6);
        }
        if (position == null) {
            PositionManagerImpl.$$$reportNull$$$0(7);
        }
        List list = (List)ReadAction.compute(() -> {
            ArrayList<ClassPrepareRequest> res = new ArrayList<ClassPrepareRequest>();
            for (PsiClass psiClass : PositionManagerImpl.getLineClasses(position.getFile(), position.getLine())) {
                ClassPrepareRequest request;
                ClassPrepareRequestor prepareRequestor = requestor;
                String classPattern = JVMNameUtil.getNonAnonymousClassName(psiClass);
                if (classPattern == null) {
                    String parentQName;
                    PsiClass parent = JVMNameUtil.getTopLevelParentClass(psiClass);
                    if (parent == null || (parentQName = JVMNameUtil.getNonAnonymousClassName(parent)) == null) continue;
                    classPattern = parentQName + "*";
                    prepareRequestor = new ClassPrepareRequestor(){

                        public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                            if (((DebugProcessImpl)debuggerProcess).getPositionManager().getAllClasses(position).contains(referenceType)) {
                                requestor.processClassPrepare(debuggerProcess, referenceType);
                            }
                        }
                    };
                }
                if ((request = this.myDebugProcess.getRequestsManager().createClassPrepareRequest(prepareRequestor, classPattern)) == null) continue;
                res.add(request);
            }
            return res;
        });
        if (list == null) {
            PositionManagerImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        PsiFile altPsiFile;
        VirtualFile altFile;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (location == null) {
            return null;
        }
        Project project = this.getDebugProcess().getProject();
        PsiFile psiFile = this.getPsiFileByLocation(project, location);
        if (psiFile == null) {
            return null;
        }
        LOG.assertTrue(this.myDebugProcess != null);
        int lineNumber = DebuggerUtilsEx.getLineNumber(location, true);
        String qName = location.declaringType().name();
        String altFileUrl = DebuggerUtilsEx.getAlternativeSourceUrl(qName, project);
        if (altFileUrl != null && (altFile = VirtualFileManager.getInstance().findFileByUrl(altFileUrl)) != null && (altPsiFile = psiFile.getManager().findFile(altFile)) != null) {
            psiFile = altPsiFile;
        }
        SourcePosition sourcePosition = null;
        if (lineNumber > -1) {
            sourcePosition = PositionManagerImpl.calcLineMappedSourcePosition(psiFile, lineNumber);
        }
        Method method = DebuggerUtilsEx.getMethod(location);
        if (sourcePosition == null && (psiFile instanceof PsiCompiledElement || lineNumber < 0)) {
            if (method != null && method.name() != null && method.signature() != null) {
                PsiClass psiClass = this.findPsiClassByName(qName, null);
                PsiMethod compiledMethod = this.findMethod((PsiElement)(psiClass != null ? psiClass : psiFile), qName, method.name(), method.signature());
                if (compiledMethod != null) {
                    sourcePosition = SourcePosition.createFromElement((PsiElement)compiledMethod);
                    if (lineNumber >= 0) {
                        sourcePosition = new ClsSourcePosition(sourcePosition, lineNumber);
                    }
                }
            } else {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
        }
        if (sourcePosition == null) {
            sourcePosition = SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
        }
        int lambdaOrdinal = -1;
        if (DebuggerUtilsEx.isLambda(method)) {
            int line = sourcePosition.getLine() + 1;
            Set lambdas = ((StreamEx)((StreamEx)StreamEx.of(location.declaringType().methods()).filter(DebuggerUtilsEx::isLambda)).filter(m -> !DebuggerUtilsEx.locationsOfLine(m, line).isEmpty())).toSet();
            if (lambdas.size() > 1) {
                ArrayList<Method> lambdasList = new ArrayList<Method>(lambdas);
                lambdasList.sort(DebuggerUtilsEx.LAMBDA_ORDINAL_COMPARATOR);
                lambdaOrdinal = lambdasList.indexOf(method);
            }
        }
        return new JavaSourcePosition(sourcePosition, location.declaringType(), method, lambdaOrdinal);
    }

    private static Set<PsiClass> getLineClasses(PsiFile file, int lineNumber) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        HashSet<PsiClass> res = new HashSet<PsiClass>();
        if (document != null) {
            XDebuggerUtil.getInstance().iterateLine(file.getProject(), document, lineNumber, element -> {
                PsiClass aClass = PositionManagerImpl.getEnclosingClass(element);
                if (aClass != null) {
                    res.add(aClass);
                }
                return true;
            });
        }
        return res;
    }

    @Nullable
    protected PsiFile getPsiFileByLocation(Project project, Location location) {
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        String originalQName = refType.name();
        Ref altSource = new Ref();
        PsiClass psiClass = this.findPsiClassByName(originalQName, c -> altSource.set((Object)this.findAlternativeJreSourceFile((ClsClassImpl)c)));
        if (!altSource.isNull()) {
            return (PsiFile)altSource.get();
        }
        if (psiClass != null) {
            PsiElement fileElement;
            PsiElement element = psiClass.getNavigationElement();
            if (element instanceof PsiCompiledElement && !((fileElement = psiClass.getContainingFile().getNavigationElement()) instanceof PsiCompiledElement)) {
                element = fileElement;
            }
            return element.getContainingFile();
        }
        try {
            PsiFile[] files;
            for (PsiFile file : files = FilenameIndex.getFilesByName((Project)project, (String)refType.sourceName(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project))) {
                if (!(file instanceof PsiJavaFile)) continue;
                for (PsiClass cls : PsiTreeUtil.findChildrenOfAnyType((PsiElement)file, (Class[])new Class[]{PsiClass.class})) {
                    if (!StringUtil.equals((CharSequence)originalQName, (CharSequence)JVMNameUtil.getClassVMName(cls))) continue;
                    return file;
                }
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    private PsiClass findPsiClassByName(String originalQName, @Nullable Consumer<? super ClsClassImpl> altClsProcessor) {
        PsiClass psiClass = null;
        Sdk alternativeJre = this.myDebugProcess.getSession().getAlternativeJre();
        if (alternativeJre != null) {
            GlobalSearchScope scope = AlternativeJreClassFinder.getSearchScope(alternativeJre);
            psiClass = PositionManagerImpl.findClass(this.myDebugProcess.getProject(), originalQName, scope, false);
            if (psiClass instanceof ClsClassImpl && altClsProcessor != null) {
                altClsProcessor.accept((ClsClassImpl)psiClass);
            }
        }
        if (psiClass == null) {
            psiClass = PositionManagerImpl.findClass(this.myDebugProcess.getProject(), originalQName, this.myDebugProcess.getSearchScope(), true);
        }
        return psiClass;
    }

    @Nullable
    public static PsiClass findClass(Project project, String originalQName, GlobalSearchScope searchScope, boolean fallbackToAllScope) {
        int dollar;
        PsiClass psiClass = DebuggerUtils.findClass((String)originalQName, (Project)project, (GlobalSearchScope)searchScope, (boolean)fallbackToAllScope);
        if (psiClass == null && (dollar = originalQName.indexOf(36)) > 0) {
            psiClass = DebuggerUtils.findClass((String)originalQName.substring(0, dollar), (Project)project, (GlobalSearchScope)searchScope, (boolean)fallbackToAllScope);
        }
        return psiClass;
    }

    @Nullable
    private PsiFile findAlternativeJreSourceFile(ClsClassImpl psiClass) {
        String sourceFileName = psiClass.getSourceFileName();
        String packageName = ((PsiClassOwner)psiClass.getContainingFile()).getPackageName();
        String relativePath = packageName.isEmpty() ? sourceFileName : packageName.replace('.', '/') + '/' + sourceFileName;
        Sdk alternativeJre = this.myDebugProcess.getSession().getAlternativeJre();
        if (alternativeJre != null) {
            for (VirtualFile file : AlternativeJreClassFinder.getSourceRoots(alternativeJre)) {
                PsiFile psiSource;
                VirtualFile source = file.findFileByRelativePath(relativePath);
                if (source == null || !source.isValid() || !((psiSource = psiClass.getManager().findFile(source)) instanceof PsiClassOwner)) continue;
                return psiSource;
            }
        }
        return null;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            PositionManagerImpl.$$$reportNull$$$0(9);
        }
        List list = (List)ReadAction.compute(() -> StreamEx.of(PositionManagerImpl.getLineClasses(position.getFile(), position.getLine())).flatMap(aClass -> this.getClassReferences((PsiClass)aClass, position)).toList());
        if (list == null) {
            PositionManagerImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    private StreamEx<ReferenceType> getClassReferences(@NotNull PsiClass psiClass, SourcePosition position) {
        if (psiClass == null) {
            PositionManagerImpl.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean isLocalOrAnonymous = false;
        int requiredDepth = 0;
        String className2 = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (className2 == null) {
            isLocalOrAnonymous = true;
            Pair<PsiClass, Integer> enclosing = PositionManagerImpl.getTopOrStaticEnclosingClass(psiClass);
            PsiClass topLevelClass = (PsiClass)enclosing.first;
            if (topLevelClass != null) {
                String parentClassName = JVMNameUtil.getNonAnonymousClassName(topLevelClass);
                if (parentClassName != null) {
                    requiredDepth = (Integer)enclosing.second;
                    className2 = parentClassName;
                }
            } else {
                StringBuilder sb = new StringBuilder();
                PsiTreeUtil.treeWalkUp((PsiElement)psiClass, null, (element, element2) -> {
                    sb.append('\n').append(element);
                    return true;
                });
                LOG.info("Local or anonymous class " + psiClass + " has no non-local parent, parents:" + sb);
            }
        }
        if (className2 == null) {
            return StreamEx.empty();
        }
        if (!isLocalOrAnonymous) {
            return StreamEx.of(this.myDebugProcess.getVirtualMachineProxy().classesByName(className2));
        }
        int depth = requiredDepth;
        return StreamEx.of(this.myDebugProcess.getVirtualMachineProxy().classesByName(className2)).map(outer -> this.findNested((ReferenceType)outer, 0, psiClass, depth, position)).nonNull();
    }

    private static Pair<PsiClass, Integer> getTopOrStaticEnclosingClass(PsiClass aClass) {
        int depth = 0;
        PsiClass enclosing = PositionManagerImpl.getEnclosingClass((PsiElement)aClass);
        while (enclosing != null) {
            PsiClass next;
            ++depth;
            if (enclosing.hasModifierProperty("static") || (next = PositionManagerImpl.getEnclosingClass((PsiElement)enclosing)) == null) break;
            enclosing = next;
        }
        return Pair.create((Object)enclosing, (Object)depth);
    }

    @Nullable
    private static PsiClass getEnclosingClass(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement previous = null;
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (element instanceof PsiClass && !(previous instanceof PsiExpressionList)) {
                return (PsiClass)element;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            previous = element;
        }
        return null;
    }

    @Nullable
    private ReferenceType findNested(ReferenceType fromClass, int currentDepth, PsiClass classToFind, int requiredDepth, SourcePosition position) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualMachineProxyImpl vmProxy = this.myDebugProcess.getVirtualMachineProxy();
        if (fromClass.isPrepared()) {
            int positionLine;
            if (currentDepth < requiredDepth) {
                List<ReferenceType> nestedTypes = vmProxy.nestedTypes(fromClass);
                for (ReferenceType nested : nestedTypes) {
                    ReferenceType found = this.findNested(nested, currentDepth + 1, classToFind, requiredDepth, position);
                    if (found == null) continue;
                    return found;
                }
                return null;
            }
            int rangeBegin = Integer.MAX_VALUE;
            int rangeEnd = Integer.MIN_VALUE;
            List<Location> locations = DebuggerUtilsEx.allLineLocations(fromClass);
            if (locations != null) {
                for (Location location : locations) {
                    Method method;
                    int lnumber = DebuggerUtilsEx.getLineNumber(location, false);
                    if (lnumber <= 1 || (method = DebuggerUtilsEx.getMethod(location)) == null || DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                    int locationLine = lnumber - 1;
                    PsiFile psiFile = position.getFile().getOriginalFile();
                    if (psiFile instanceof PsiCompiledFile && (locationLine = DebuggerUtilsEx.bytecodeToSourceLine(psiFile, locationLine)) < 0) continue;
                    rangeBegin = Math.min(rangeBegin, locationLine);
                    rangeEnd = Math.max(rangeEnd, locationLine);
                }
            }
            if ((positionLine = position.getLine()) >= rangeBegin && positionLine <= rangeEnd) {
                if (!classToFind.isValid()) {
                    return null;
                }
                Set<PsiClass> lineClasses = PositionManagerImpl.getLineClasses(position.getFile(), rangeEnd);
                if (lineClasses.size() > 1) {
                    for (PsiClass aClass : lineClasses) {
                        if (!classToFind.equals(aClass)) continue;
                        return fromClass;
                    }
                } else if (!lineClasses.isEmpty()) {
                    return classToFind.equals(lineClasses.iterator().next()) ? fromClass : null;
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    public PsiMethod findMethod(PsiElement container, String className2, String methodName, String methodSignature) {
        MethodFinder finder = new MethodFinder(className2, methodName, methodSignature);
        container.accept((PsiElementVisitor)finder);
        return finder.getCompiledMethod();
    }

    @Nullable
    private static SourcePosition calcLineMappedSourcePosition(PsiFile psiFile, int originalLine) {
        int line = DebuggerUtilsEx.bytecodeToSourceLine(psiFile, originalLine);
        if (line > -1) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)line);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/PositionManagerImpl";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/PositionManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrepareRequests";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequest";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequests";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ClsSourcePosition
    extends RemappedSourcePosition {
        private final int myOriginalLine;

        public ClsSourcePosition(SourcePosition delegate, int originalLine) {
            super(delegate);
            this.myOriginalLine = originalLine;
        }

        @Override
        public SourcePosition mapDelegate(SourcePosition original) {
            PsiFile file = this.getFile();
            if (this.myOriginalLine < 0 || !file.isValid()) {
                return original;
            }
            PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            SourcePosition position = PositionManagerImpl.calcLineMappedSourcePosition(file, this.myOriginalLine);
            return position != null ? position : original;
        }
    }

    private class MethodFinder
    extends JavaRecursiveElementVisitor {
        private final String myClassName;
        private PsiClass myCompiledClass;
        private final String myMethodName;
        private final String myMethodSignature;
        private PsiMethod myCompiledMethod;

        MethodFinder(String className2, String methodName, String methodSignature) {
            this.myClassName = className2;
            this.myMethodName = methodName;
            this.myMethodSignature = methodSignature;
        }

        public void visitClass(PsiClass aClass) {
            if (this.myCompiledMethod == null) {
                if (PositionManagerImpl.this.getClassReferences(aClass, SourcePosition.createFromElement((PsiElement)aClass)).anyMatch(referenceType -> referenceType.name().equals(this.myClassName))) {
                    this.myCompiledClass = aClass;
                }
                aClass.acceptChildren((PsiElementVisitor)this);
            }
        }

        public void visitMethod(PsiMethod method) {
            if (this.myCompiledMethod == null) {
                try {
                    String methodName = JVMNameUtil.getJVMMethodName(method);
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass != null && containingClass.equals(this.myCompiledClass) && methodName.equals(this.myMethodName) && JVMNameUtil.getJVMSignature(method).getName(PositionManagerImpl.this.myDebugProcess).equals(this.myMethodSignature)) {
                        this.myCompiledMethod = method;
                    }
                }
                catch (EvaluateException e) {
                    LOG.debug((Throwable)e);
                }
            }
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                MethodFinder.$$$reportNull$$$0(0);
            }
            if (this.myCompiledMethod == null) {
                super.visitElement(element);
            }
        }

        @Nullable
        public PsiMethod getCompiledMethod() {
            return this.myCompiledMethod;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/debugger/engine/PositionManagerImpl$MethodFinder", "visitElement"));
        }
    }

    public static class JavaSourcePosition
    extends RemappedSourcePosition {
        private final String myExpectedClassName;
        private final String myExpectedMethodName;
        private final int myLambdaOrdinal;

        public JavaSourcePosition(@NotNull SourcePosition delegate, ReferenceType declaringType, Method method, int lambdaOrdinal) {
            if (delegate == null) {
                JavaSourcePosition.$$$reportNull$$$0(0);
            }
            super(delegate);
            this.myExpectedClassName = declaringType != null ? declaringType.name() : null;
            this.myExpectedMethodName = method != null ? method.name() : null;
            this.myLambdaOrdinal = lambdaOrdinal;
        }

        public JavaSourcePosition(@NotNull SourcePosition delegate, int lambdaOrdinal) {
            if (delegate == null) {
                JavaSourcePosition.$$$reportNull$$$0(1);
            }
            super(delegate);
            assert (lambdaOrdinal > -1);
            this.myExpectedClassName = null;
            this.myExpectedMethodName = "lambda$";
            this.myLambdaOrdinal = lambdaOrdinal;
        }

        private PsiElement remapElement(PsiElement element) {
            String name2 = JVMNameUtil.getClassVMName(PositionManagerImpl.getEnclosingClass(element));
            if (name2 != null && !name2.equals(this.myExpectedClassName)) {
                return null;
            }
            PsiElement method = DebuggerUtilsEx.getContainingMethod(element);
            if (!StringUtil.isEmpty((String)this.myExpectedMethodName)) {
                if (method == null) {
                    return null;
                }
                if ((method instanceof PsiMethod && this.myExpectedMethodName.equals(((PsiMethod)method).getName()) || method instanceof PsiLambdaExpression && DebuggerUtilsEx.isLambdaName(this.myExpectedMethodName)) && JavaSourcePosition.insideBody(element, DebuggerUtilsEx.getBody(method))) {
                    return element;
                }
            }
            return null;
        }

        private static boolean insideBody(@NotNull PsiElement element, @Nullable PsiElement body2) {
            if (element == null) {
                JavaSourcePosition.$$$reportNull$$$0(2);
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)element, (boolean)false)) {
                return false;
            }
            if (body2 instanceof PsiCodeBlock) {
                return !element.equals(((PsiCodeBlock)body2).getRBrace()) && !element.equals(((PsiCodeBlock)body2).getLBrace());
            }
            return true;
        }

        @Override
        public SourcePosition mapDelegate(SourcePosition original) {
            return (SourcePosition)ReadAction.compute(() -> {
                PsiFile file = original.getFile();
                int line = original.getLine();
                Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                if (document == null || line >= document.getLineCount()) {
                    return original;
                }
                if (DebuggerUtilsEx.isLambdaName(this.myExpectedMethodName) && this.myLambdaOrdinal > -1) {
                    PsiElement firstElem;
                    List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(original, true);
                    if (this.myLambdaOrdinal < lambdas.size() && (firstElem = DebuggerUtilsEx.getFirstElementOnTheLine(lambdas.get(this.myLambdaOrdinal), document, line)) != null) {
                        return SourcePosition.createFromElement((PsiElement)firstElem);
                    }
                } else {
                    Ref res = Ref.create();
                    XDebuggerUtil.getInstance().iterateLine(file.getProject(), document, line, elem -> {
                        PsiElement remappedElement = this.remapElement((PsiElement)elem);
                        if (remappedElement != null) {
                            if (remappedElement.getTextOffset() > original.getOffset()) {
                                res.set((Object)SourcePosition.createFromElement((PsiElement)remappedElement));
                            }
                            return false;
                        }
                        return true;
                    });
                    if (!res.isNull()) {
                        return (SourcePosition)res.get();
                    }
                }
                return original;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/PositionManagerImpl$JavaSourcePosition";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insideBody";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

