/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.DebuggerView;
import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class UpdatableDebuggerView
extends JPanel
implements DebuggerView {
    private final Project myProject;
    private final DebuggerStateManager myStateManager;
    private volatile boolean myRefreshNeeded = true;
    private final CompositeDisposable myDisposables = new CompositeDisposable();
    private volatile boolean myUpdateEnabled;

    protected UpdatableDebuggerView(Project project, DebuggerStateManager stateManager) {
        this.setLayout(new BorderLayout());
        this.myProject = project;
        this.myStateManager = stateManager;
        final DebuggerContextListener contextListener = this::changeEvent;
        this.myStateManager.addListener(contextListener);
        this.registerDisposable(new Disposable(){

            public void dispose() {
                UpdatableDebuggerView.this.myStateManager.removeListener(contextListener);
            }
        });
    }

    protected void changeEvent(DebuggerContextImpl newContext, DebuggerSession.Event event) {
        if (newContext.getDebuggerSession() != null) {
            this.rebuildIfVisible(event);
        }
    }

    protected final boolean isUpdateEnabled() {
        return this.myUpdateEnabled || this.isShowing();
    }

    @Override
    public final void setUpdateEnabled(boolean enabled) {
        this.myUpdateEnabled = enabled;
    }

    @Override
    public final boolean isRefreshNeeded() {
        return this.myRefreshNeeded;
    }

    @Override
    public final void rebuildIfVisible(DebuggerSession.Event event) {
        if (this.isUpdateEnabled()) {
            this.myRefreshNeeded = false;
            this.rebuild(event);
        } else {
            this.myRefreshNeeded = true;
        }
    }

    protected abstract void rebuild(DebuggerSession.Event var1);

    protected final void registerDisposable(Disposable disposable) {
        this.myDisposables.add(disposable);
    }

    @NotNull
    public DebuggerContextImpl getContext() {
        DebuggerContextImpl debuggerContextImpl = this.myStateManager.getContext();
        if (debuggerContextImpl == null) {
            UpdatableDebuggerView.$$$reportNull$$$0(0);
        }
        return debuggerContextImpl;
    }

    protected final Project getProject() {
        return this.myProject;
    }

    public DebuggerStateManager getContextManager() {
        return this.myStateManager;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposables);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/impl/UpdatableDebuggerView", "getContext"));
    }
}

