/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundRendererProvider;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.sql.Timestamp;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class TimestampRenderer
extends CompoundRendererProvider {
    @Override
    protected String getName() {
        return "Timestamp";
    }

    @Override
    protected ValueLabelRenderer getValueLabelRenderer() {
        return new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) {
                Value value2 = descriptor.getValue();
                if (value2 == null) {
                    return "null";
                }
                if (value2 instanceof LongValue) {
                    return new Timestamp(((LongValue)value2).longValue()).toString();
                }
                return null;
            }
        };
    }

    @Override
    protected Function<Type, CompletableFuture<Boolean>> getIsApplicableChecker() {
        return type2 -> CompletableFuture.completedFuture(type2 instanceof LongType);
    }
}

