/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.concurrent.CompletableFuture;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ToStringRenderer
extends NodeRendererImpl
implements OnDemandRenderer {
    @NonNls
    public static final String UNIQUE_ID = "ToStringRenderer";
    private boolean USE_CLASS_FILTERS = false;
    private boolean ON_DEMAND;
    private ClassFilter[] myClassFilters = ClassFilter.EMPTY_ARRAY;

    public ToStringRenderer() {
        super("unnamed", true);
        this.setIsApplicableChecker(type2 -> {
            if (!(type2 instanceof ReferenceType) || "java.lang.String".equals(type2.name())) {
                return CompletableFuture.completedFuture(false);
            }
            return ToStringRenderer.overridesToStringAsync(type2);
        });
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public String getName() {
        return "toString";
    }

    @Override
    public void setName(String name2) {
    }

    @Override
    public ToStringRenderer clone() {
        ToStringRenderer cloned = (ToStringRenderer)super.clone();
        ClassFilter[] classFilters = this.myClassFilters.length > 0 ? new ClassFilter[this.myClassFilters.length] : ClassFilter.EMPTY_ARRAY;
        for (int idx = 0; idx < classFilters.length; ++idx) {
            classFilters[idx] = this.myClassFilters[idx].clone();
        }
        cloned.myClassFilters = classFilters;
        return cloned;
    }

    @Override
    public String calcLabel(final ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, final DescriptorLabelListener labelListener) throws EvaluateException {
        if (!this.isShowValue(valueDescriptor, evaluationContext)) {
            return "";
        }
        final Value value2 = valueDescriptor.getValue();
        if (value2 instanceof ObjectReference) {
            DebuggerUtils.ensureNotInsideObjectConstructor((ObjectReference)((ObjectReference)value2), (EvaluationContext)evaluationContext);
        }
        BatchEvaluator.getBatchEvaluator(evaluationContext.getDebugProcess()).invoke(new ToStringCommand(evaluationContext, value2){

            @Override
            public void evaluationResult(String message2) {
                valueDescriptor.setValueLabel(StringUtil.notNullize((String)message2));
                labelListener.labelChanged();
            }

            @Override
            public void evaluationError(String message2) {
                String msg = value2 != null ? message2 + " " + JavaDebuggerBundle.message((String)"evaluation.error.cannot.evaluate.tostring", (Object[])new Object[]{value2.type().name()}) : message2;
                valueDescriptor.setValueLabelFailed(new EvaluateException(msg, null));
                labelListener.labelChanged();
            }
        });
        return XDebuggerUIConstants.getCollectingDataMessage();
    }

    @Override
    @NotNull
    public String getLinkText() {
        String string = JavaDebuggerBundle.message((String)"message.node.toString", (Object[])new Object[0]);
        if (string == null) {
            ToStringRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isUseClassFilters() {
        return this.USE_CLASS_FILTERS;
    }

    public void setUseClassFilters(boolean value2) {
        this.USE_CLASS_FILTERS = value2;
    }

    @Override
    public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
        if (this.ON_DEMAND || this.USE_CLASS_FILTERS && !this.isFiltered(valueDescriptor.getType())) {
            return true;
        }
        return OnDemandRenderer.super.isOnDemand(evaluationContext, valueDescriptor);
    }

    private static boolean overridesToString(Type type2) {
        if (type2 instanceof ClassType) {
            Method toStringMethod = DebuggerUtils.findMethod((ReferenceType)((ReferenceType)type2), (String)"toString", (String)"()Ljava/lang/String;");
            return toStringMethod != null && !"java.lang.Object".equals(toStringMethod.declaringType().name());
        }
        return false;
    }

    private static CompletableFuture<Boolean> overridesToStringAsync(Type type2) {
        if (!Registry.is((String)"debugger.async.jdi")) {
            return CompletableFuture.completedFuture(ToStringRenderer.overridesToString(type2));
        }
        if (type2 instanceof ClassType) {
            return DebuggerUtilsAsync.findAnyBaseType(type2, t -> {
                if (t instanceof ReferenceType) {
                    return DebuggerUtilsAsync.methods((ReferenceType)t).thenApply(methods -> methods.stream().anyMatch(m -> !m.isAbstract() && DebuggerUtilsEx.methodMatches(m, "toString", "()Ljava/lang/String;") && !"java.lang.Object".equals(m.declaringType().name())));
                }
                return CompletableFuture.completedFuture(false);
            }).thenApply(t -> t != null);
        }
        return CompletableFuture.completedFuture(false);
    }

    @Override
    public void buildChildren(Value value2, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        DebugProcessImpl.getDefaultRenderer(value2).buildChildren(value2, builder, evaluationContext);
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return DebugProcessImpl.getDefaultRenderer(((ValueDescriptor)node.getParent().getDescriptor()).getType()).getChildValueExpression(node, context);
    }

    @Override
    public CompletableFuture<Boolean> isExpandableAsync(Value value2, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return DebugProcessImpl.getDefaultRenderer(value2).isExpandableAsync(value2, evaluationContext, parentDescriptor);
    }

    @Override
    public void readExternal(Element element) {
        super.readExternal(element);
        this.ON_DEMAND = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"ON_DEMAND"));
        this.USE_CLASS_FILTERS = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_CLASS_FILTERS"));
        this.myClassFilters = DebuggerUtilsEx.readFilters(element.getChildren("filter"));
    }

    @Override
    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ToStringRenderer.$$$reportNull$$$0(1);
        }
        super.writeExternal(element);
        if (this.ON_DEMAND) {
            JDOMExternalizerUtil.writeField((Element)element, (String)"ON_DEMAND", (String)"true");
        }
        if (this.USE_CLASS_FILTERS) {
            JDOMExternalizerUtil.writeField((Element)element, (String)"USE_CLASS_FILTERS", (String)"true");
        }
        DebuggerUtilsEx.writeFilters(element, "filter", this.myClassFilters);
    }

    public ClassFilter[] getClassFilters() {
        return this.myClassFilters;
    }

    public void setClassFilters(ClassFilter[] classFilters) {
        this.myClassFilters = classFilters != null ? classFilters : ClassFilter.EMPTY_ARRAY;
    }

    private boolean isFiltered(Type t) {
        if (t instanceof ReferenceType) {
            for (ClassFilter classFilter : this.myClassFilters) {
                if (!classFilter.isEnabled() || !DebuggerUtils.instanceOf((Type)t, (String)classFilter.getPattern())) continue;
                return true;
            }
        }
        return DebuggerUtilsEx.isFiltered(t.name(), this.myClassFilters);
    }

    public boolean isOnDemand() {
        return this.ON_DEMAND;
    }

    public void setOnDemand(boolean value2) {
        this.ON_DEMAND = value2;
    }

    @Override
    public boolean hasOverhead() {
        return true;
    }

    @Override
    @Deprecated
    public boolean isApplicable(Type type2) {
        if (!(type2 instanceof ReferenceType)) {
            return false;
        }
        if ("java.lang.String".equals(type2.name())) {
            return false;
        }
        return ToStringRenderer.overridesToString(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/tree/render/ToStringRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/tree/render/ToStringRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

