/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.selection;

import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.selection.ResizePoint;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.designSurface.tools.ResizeTracker;
import com.intellij.designer.model.RadComponent;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.Nullable;

public class DirectionResizePoint
extends ResizePoint {
    protected int myDirection;
    private final Object myType;
    protected double myXSeparator;
    protected double myYSeparator;
    private final String myDescription;

    public DirectionResizePoint(int direction, Object type2, @Nullable String description) {
        this.setDirection(direction);
        this.myType = type2;
        this.myDescription = description;
    }

    public DirectionResizePoint(Color color, Color border, int direction, Object type2, @Nullable String description) {
        super(color, border);
        this.setDirection(direction);
        this.myType = type2;
        this.myDescription = description;
    }

    private void setDirection(int direction) {
        this.myDirection = direction;
        int yDirection = this.myDirection & 0xC;
        this.myXSeparator = yDirection == 4 ? 0.0 : (yDirection == 8 ? 1.0 : 0.5);
        int xDirection = this.myDirection & 3;
        this.myYSeparator = xDirection == 1 ? 0.0 : (xDirection == 2 ? 1.0 : 0.5);
    }

    public DirectionResizePoint move(double xSeparator, double ySeparator) {
        this.myXSeparator = xSeparator;
        this.myYSeparator = ySeparator;
        return this;
    }

    public int getDirection() {
        return this.myDirection;
    }

    @Override
    public Object getType() {
        return this.myType;
    }

    @Override
    protected InputTool createTool(RadComponent component) {
        return new ResizeTracker(this.myDirection, this.myType, this.myDescription);
    }

    @Override
    protected Point getLocation(DecorationLayer layer, RadComponent component) {
        Rectangle bounds = this.getBounds(layer, component);
        int size = (this.getSize() + 1) / 2;
        int x = bounds.x + (int)((double)bounds.width * this.myXSeparator) - size;
        int y = bounds.y + (int)((double)bounds.height * this.myYSeparator) - size;
        return new Point(x, y);
    }

    protected Rectangle getBounds(DecorationLayer layer, RadComponent component) {
        return component.getBounds(layer);
    }
}

