/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.structureView.impl.StructureNodeRenderer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodListDlg
extends DialogWrapper {
    private static final Comparator<PsiMethod> METHOD_NAME_COMPARATOR = Comparator.comparing(PsiMethod::getName, String::compareToIgnoreCase);
    private final SortedListModel<PsiMethod> myListModel;
    private final JList<PsiMethod> myList;
    private final JPanel myWholePanel;

    public MethodListDlg(final @NotNull PsiClass psiClass, @NotNull Condition<? super PsiMethod> filter, @NotNull JComponent parent) {
        if (psiClass == null) {
            MethodListDlg.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            MethodListDlg.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            MethodListDlg.$$$reportNull$$$0(2);
        }
        super((Component)parent, false);
        this.myListModel = new SortedListModel(METHOD_NAME_COMPARATOR);
        this.myList = new JBList(this.myListModel);
        this.myWholePanel = new JPanel(new BorderLayout());
        this.createList(psiClass.getAllMethods(), filter);
        this.myWholePanel.add(ScrollPaneFactory.createScrollPane(this.myList));
        this.myList.setCellRenderer((ListCellRenderer<PsiMethod>)new ColoredListCellRenderer<PsiMethod>(){

            protected void customizeCellRenderer(@NotNull JList<? extends PsiMethod> list, @NotNull PsiMethod psiMethod, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (psiMethod == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.append(PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)1, (int)0), StructureNodeRenderer.applyDeprecation(psiMethod, SimpleTextAttributes.REGULAR_ATTRIBUTES));
                PsiClass containingClass = psiMethod.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                if (!psiClass.equals(containingClass)) {
                    this.append(" (" + containingClass.getQualifiedName() + ")", StructureNodeRenderer.applyDeprecation(containingClass, SimpleTextAttributes.GRAY_ATTRIBUTES));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "list";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "psiMethod";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/MethodListDlg$1";
                objectArray[2] = "customizeCellRenderer";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myList.setSelectionMode(0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                MethodListDlg.this.close(0);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/MethodListDlg$2", "onDoubleClick"));
            }
        }.installOn(this.myList);
        ScrollingUtil.ensureSelectionExists(this.myList);
        TreeUIHelper.getInstance().installListSpeedSearch(this.myList);
        this.setTitle(ExecutionBundle.message((String)"choose.test.method.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    private void createList(PsiMethod[] allMethods, Condition<? super PsiMethod> filter) {
        for (PsiMethod method : allMethods) {
            if (!filter.value((Object)method)) continue;
            this.myListModel.add((Object)method);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myWholePanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    public PsiMethod getSelected() {
        return this.myList.getSelectedValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "filter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/MethodListDlg";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

