/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodLocation
extends Location<PsiMethod> {
    private static final Logger LOG = Logger.getInstance(MethodLocation.class);
    private final Project myProject;
    @NotNull
    private final PsiMethod myMethod;
    private final Location<? extends PsiClass> myClassLocation;

    public MethodLocation(@NotNull Project project, @NotNull PsiMethod method, @NotNull Location<? extends PsiClass> classLocation) {
        if (project == null) {
            MethodLocation.$$$reportNull$$$0(0);
        }
        if (method == null) {
            MethodLocation.$$$reportNull$$$0(1);
        }
        if (classLocation == null) {
            MethodLocation.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myMethod = method;
        this.myClassLocation = classLocation;
    }

    public static MethodLocation elementInClass(PsiMethod psiElement, PsiClass psiClass) {
        Location classLocation = PsiLocation.fromPsiElement((PsiElement)psiClass);
        return new MethodLocation(classLocation.getProject(), psiElement, (Location<? extends PsiClass>)classLocation);
    }

    @NotNull
    public PsiMethod getPsiElement() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            MethodLocation.$$$reportNull$$$0(3);
        }
        return psiMethod;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            MethodLocation.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Nullable
    public Module getModule() {
        return this.myClassLocation.getModule();
    }

    public PsiClass getContainingClass() {
        return (PsiClass)this.myClassLocation.getPsiElement();
    }

    @NotNull
    public <T extends PsiElement> Iterator<Location<T>> getAncestors(final Class<T> ancestorClass, boolean strict) {
        final Iterator fromClass = this.myClassLocation.getAncestors(ancestorClass, false);
        if (strict) {
            Iterator iterator = fromClass;
            if (iterator == null) {
                MethodLocation.$$$reportNull$$$0(5);
            }
            return iterator;
        }
        return new Iterator<Location<T>>(){
            private boolean myFirstStep;
            {
                this.myFirstStep = ancestorClass.isInstance(MethodLocation.this.myMethod);
            }

            @Override
            public boolean hasNext() {
                return this.myFirstStep || fromClass.hasNext();
            }

            @Override
            public Location<T> next() {
                MethodLocation location = this.myFirstStep ? MethodLocation.this : (Location)fromClass.next();
                this.myFirstStep = false;
                return location;
            }

            @Override
            public void remove() {
                LOG.assertTrue(false);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLocation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit2/info/MethodLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit2/info/MethodLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

