/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.actions;

import com.intellij.codeInsight.actions.VcsFacadeImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaTestConfigurationWithDiscoverySupport;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.testDiscovery.TestDiscoveryConfigurationProducer;
import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.execution.testDiscovery.actions.DiscoveredTestsTree;
import com.intellij.execution.testDiscovery.actions.DiscoveredTestsTreeModel;
import com.intellij.execution.testDiscovery.actions.TestMethodUsage;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindUtil;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.uast.UastMetaLanguage;
import com.intellij.ui.ActiveComponent;
import com.intellij.usages.UsageView;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.vcsUtil.VcsFileUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public class ShowAffectedTestsAction
extends AnAction {
    private static final String RUN_ALL_ACTION_TEXT = "Run All Affected Tests";

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(ShowAffectedTestsAction.isEnabled(e.getProject()) && (ShowAffectedTestsAction.findMethodAtCaret(e) != null || ShowAffectedTestsAction.findClassAtCaret(e) != null || !ShowAffectedTestsAction.findFilesInContext(e).isEmpty() || e.getData(VcsDataKeys.CHANGES) != null));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        assert (project != null);
        PsiMethod method = ShowAffectedTestsAction.findMethodAtCaret(e);
        if (method != null) {
            ShowAffectedTestsAction.showDiscoveredTestsByPsiMethod(project, method, e);
            return;
        }
        PsiClass psiClass = ShowAffectedTestsAction.findClassAtCaret(e);
        if (psiClass != null) {
            ShowAffectedTestsAction.showDiscoveredTestsByPsiClass(project, psiClass, e);
            return;
        }
        if (e.getData(VcsDataKeys.CHANGES) != null) {
            ShowAffectedTestsAction.showDiscoveredTestsByChanges(e);
            return;
        }
        List<VirtualFile> virtualFiles = ShowAffectedTestsAction.findFilesInContext(e);
        if (!virtualFiles.isEmpty()) {
            ShowAffectedTestsAction.showDiscoveredTestsByFile(project, virtualFiles, e);
        }
    }

    private static void showDiscoveredTestsByFile(@NotNull Project project, @NotNull List<? extends VirtualFile> files, @NotNull AnActionEvent e) {
        VirtualFile projectBasePath;
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(2);
        }
        if (files == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(4);
        }
        if ((projectBasePath = ShowAffectedTestsAction.getBasePathAsVirtualFile(project)) == null) {
            return;
        }
        DiscoveredTestsTree tree = ShowAffectedTestsAction.showTree(project, e.getDataContext(), ShowAffectedTestsAction.createTitle(files));
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery");
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            JBIterable paths = JBIterable.from((Iterable)files).flatMap(f -> VfsUtil.collectChildrenRecursively((VirtualFile)f)).map(f -> VcsFileUtil.getRelativeFilePath((VirtualFile)f, (VirtualFile)projectBasePath)).filter(Objects::nonNull).map(p -> "/" + p);
            if (paths.isNotEmpty()) {
                ShowAffectedTestsAction.processMethodsAsync(project, PsiMethod.EMPTY_ARRAY, paths.toList(), ShowAffectedTestsAction.createTreeProcessor(tree), () -> tree.setPaintBusy(false));
            }
        });
    }

    @NotNull
    private static String createTitle(@NotNull List<? extends VirtualFile> files) {
        if (files == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(5);
        }
        if (files.isEmpty()) {
            return "Empty Selection";
        }
        String firstName = files.get(0).getName();
        if (files.size() == 1) {
            String string = firstName;
            if (string == null) {
                ShowAffectedTestsAction.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (files.size() == 2) {
            String string = firstName + " and " + files.get(1).getName();
            if (string == null) {
                ShowAffectedTestsAction.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = firstName + " et al.";
        if (string == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void showDiscoveredTestsByPsiClass(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull AnActionEvent e) {
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(9);
        }
        if (psiClass == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(10);
        }
        if (e == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(11);
        }
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Editor)e.getRequiredData(CommonDataKeys.EDITOR)).getContentComponent());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery");
        String presentableName = PsiFormatUtil.formatClass((PsiClass)psiClass, (int)1);
        DiscoveredTestsTree tree = ShowAffectedTestsAction.showTree(project, dataContext, presentableName);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (DumbService.isDumb((Project)project)) {
                return;
            }
            String className2 = (String)ReadAction.compute(() -> DiscoveredTestsTreeModel.getClassName(psiClass));
            if (className2 == null) {
                return;
            }
            SmartList classesAndMethods = new SmartList((Object)Couple.of((Object)className2, null));
            ShowAffectedTestsAction.processTestDiscovery(project, ShowAffectedTestsAction.createTreeProcessor(tree), (List<Couple<String>>)classesAndMethods, Collections.emptyList());
            EdtInvocationManager.getInstance().invokeLater(() -> tree.setPaintBusy(false));
        });
    }

    private static void showDiscoveredTestsByPsiMethod(@NotNull Project project, @NotNull PsiMethod method, @NotNull AnActionEvent e) {
        Couple<String> key2;
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(12);
        }
        if (method == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(13);
        }
        if (e == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(14);
        }
        if ((key2 = ShowAffectedTestsAction.getMethodKey(method)) == null) {
            return;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Editor)e.getRequiredData(CommonDataKeys.EDITOR)).getContentComponent());
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery");
        String presentableName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
        DiscoveredTestsTree tree = ShowAffectedTestsAction.showTree(project, dataContext, presentableName);
        ShowAffectedTestsAction.processMethodsAsync(project, new PsiMethod[]{method}, Collections.emptyList(), ShowAffectedTestsAction.createTreeProcessor(tree), () -> tree.setPaintBusy(false));
    }

    @NotNull
    private static TestDiscoveryProducer.PsiTestProcessor createTreeProcessor(@NotNull DiscoveredTestsTree tree) {
        if (tree == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(15);
        }
        TestDiscoveryProducer.PsiTestProcessor psiTestProcessor = (clazz, method, parameter2) -> {
            tree.addTest(clazz, method, parameter2);
            return true;
        };
        if (psiTestProcessor == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(16);
        }
        return psiTestProcessor;
    }

    private static void showDiscoveredTestsByChanges(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(17);
        }
        Change[] changes2 = (Change[])e.getRequiredData(VcsDataKeys.CHANGES);
        Project project = e.getProject();
        assert (project != null);
        ShowAffectedTestsAction.showDiscoveredTestsByChanges(project, changes2, "Selected Changes", e.getDataContext());
    }

    public static void showDiscoveredTestsByChanges(@NotNull Project project, Change @NotNull [] changes2, @NotNull String title, @NotNull DataContext dataContext) {
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(18);
        }
        if (title == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(19);
        }
        if (dataContext == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(20);
        }
        if (changes2 == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(21);
        }
        DiscoveredTestsTree tree = ShowAffectedTestsAction.showTree(project, dataContext, title);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("test.discovery.selected.changes");
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            PsiMethod[] methods = ShowAffectedTestsAction.findMethods(project, changes2);
            List<String> filePaths = ShowAffectedTestsAction.getRelativeAffectedPaths(project, Arrays.asList(changes2));
            ShowAffectedTestsAction.processMethodsAsync(project, methods, filePaths, ShowAffectedTestsAction.createTreeProcessor(tree), () -> tree.setPaintBusy(false));
        });
    }

    public static PsiMethod @NotNull [] findMethods(@NotNull Project project, Change ... changes2) {
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(22);
        }
        if (changes2 == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(23);
        }
        UastMetaLanguage jvmLanguage = (UastMetaLanguage)Language.findInstance(UastMetaLanguage.class);
        PsiMethod[] psiMethodArray = (PsiMethod[])PsiDocumentManager.getInstance((Project)project).commitAndRunReadAction(() -> (PsiMethod[])VcsFacadeImpl.getVcsInstance().getChangedElements(project, changes2, file -> {
            if (DumbService.isDumb((Project)project) || project.isDisposed() || !file.isValid()) {
                return null;
            }
            ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
            if (!index.isInSource(file)) {
                return null;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null || !jvmLanguage.matchesLanguage(psiFile.getLanguage())) {
                return null;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) {
                return null;
            }
            SmartList physicalMethods = new SmartList();
            psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((List)physicalMethods){
                final /* synthetic */ List val$physicalMethods;
                {
                    this.val$physicalMethods = list;
                }

                public void visitElement(@NotNull PsiElement element) {
                    UMethod method;
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((method = (UMethod)UastContextKt.toUElement((PsiElement)element, UMethod.class)) != null) {
                        ContainerUtil.addAllNotNull((Collection)this.val$physicalMethods, (Object[])new PsiElement[]{method.getSourcePsi()});
                    }
                    super.visitElement(element);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction$1", "visitElement"));
                }
            });
            return physicalMethods;
        }).stream().map(m -> UastContextKt.toUElement((PsiElement)m)).filter(Objects::nonNull).map(m -> (PsiMethod)ObjectUtils.tryCast((Object)m.getJavaPsi(), PsiMethod.class)).filter(Objects::nonNull).toArray(arg_0 -> ((ArrayFactory)PsiMethod.ARRAY_FACTORY).create(arg_0)));
        if (psiMethodArray == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(24);
        }
        return psiMethodArray;
    }

    public static boolean isEnabled(@Nullable Project project) {
        return project != null && (Registry.is((String)"testDiscovery.enabled") || ApplicationManager.getApplication().isInternal());
    }

    @NotNull
    private static List<VirtualFile> findFilesInContext(@NotNull AnActionEvent event) {
        PsiFile file;
        VirtualFile[] virtualFiles;
        if (event == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(25);
        }
        if (((virtualFiles = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null || virtualFiles.length == 0) && (file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE)) != null) {
            virtualFiles = new VirtualFile[]{file.getVirtualFile()};
        }
        List<Object> list = virtualFiles == null ? Collections.emptyList() : Arrays.stream(virtualFiles).filter(v -> v.isInLocalFileSystem()).collect(Collectors.toList());
        if (list == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(26);
        }
        return list;
    }

    @Nullable
    private static PsiMethod findMethodAtCaret(@NotNull AnActionEvent e) {
        UMethod uMethod;
        if (e == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(27);
        }
        return (uMethod = (UMethod)UastUtils.findContaining((PsiElement)ShowAffectedTestsAction.findElementAtCaret(e), UMethod.class)) == null ? null : (PsiMethod)ObjectUtils.tryCast((Object)uMethod.getJavaPsi(), PsiMethod.class);
    }

    @Nullable
    private static PsiClass findClassAtCaret(@NotNull AnActionEvent e) {
        UClass uClass;
        if (e == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(28);
        }
        return (uClass = (UClass)UastUtils.findContaining((PsiElement)ShowAffectedTestsAction.findElementAtCaret(e), UClass.class)) == null ? null : (PsiClass)ObjectUtils.tryCast((Object)uClass.getJavaPsi(), PsiClass.class);
    }

    @Nullable
    private static PsiElement findElementAtCaret(@NotNull AnActionEvent e) {
        PsiElement prev;
        if (e == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(29);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (editor == null || file == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement at = file.findElementAt(offset);
        if (at instanceof PsiWhiteSpace && offset > 0 && !((prev = file.findElementAt(offset - 1)) instanceof PsiWhiteSpace)) {
            return prev;
        }
        return at;
    }

    @NotNull
    private static DiscoveredTestsTree showTree(final @NotNull Project project, @NotNull DataContext dataContext, final @NotNull String title) {
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(30);
        }
        if (dataContext == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(31);
        }
        if (title == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(32);
        }
        final DiscoveredTestsTree tree = new DiscoveredTestsTree(title);
        final String initTitle = "Tests for " + title;
        final Ref ref = new Ref();
        final ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)dataContext);
        ActiveComponent runButton = ShowAffectedTestsAction.createButton(RUN_ALL_ACTION_TEXT, AllIcons.Actions.Execute, () -> ShowAffectedTestsAction.runAllDiscoveredTests(project, tree, (Ref<? extends JBPopup>)ref, context, initTitle), tree);
        Runnable pinActionListener = () -> {
            JBPopup popup;
            UsageView view = FindUtil.showInUsageView(null, (Object[])tree.getTestMethods(), param -> param, (String)initTitle, p -> {
                p.setCodeUsages(false);
                p.setUsagesWord("test");
                p.setMergeDupLinesAvailable(false);
                p.setUsageTypeFilteringAvailable(false);
                p.setExcludeAvailable(false);
            }, (Project)project);
            if (view != null) {
                view.addButtonToLowerPane((Action)new AbstractAction(RUN_ALL_ACTION_TEXT, AllIcons.Actions.Execute){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ShowAffectedTestsAction.runAllDiscoveredTests(project, tree, (Ref<? extends JBPopup>)ref, context, initTitle);
                    }
                });
            }
            if ((popup = (JBPopup)ref.get()) != null) {
                popup.cancel();
            }
        };
        KeyStroke findUsageKeyStroke = ShowAffectedTestsAction.findUsagesKeyStroke();
        String pinTooltip = IdeBundle.message((String)"show.in.find.window.button.name", (Object[])new Object[0]) + (findUsageKeyStroke == null ? "" : " " + KeymapUtil.getKeystrokeText((KeyStroke)findUsageKeyStroke));
        ActiveComponent pinButton = ShowAffectedTestsAction.createButton(pinTooltip, AllIcons.General.Pin_tab, pinActionListener, tree);
        PopupChooserBuilder builder = new PopupChooserBuilder((JTree)((Object)tree)).setTitle(initTitle).setMovable(true).setResizable(true).setCommandButton((ActiveComponent)new CompositeActiveComponent(new ActiveComponent[]{pinButton})).setSettingButton((Component)new CompositeActiveComponent(new ActiveComponent[]{runButton}).getComponent()).setItemChoosenCallback(() -> PsiNavigateUtil.navigate((PsiElement)tree.getSelectedElement())).registerKeyboardAction(findUsageKeyStroke, __ -> pinActionListener.run()).setMinSize((Dimension)new JBDimension(500, 300)).setDimensionServiceKey(ShowAffectedTestsAction.class.getSimpleName());
        final JBPopup popup = builder.createPopup();
        ref.set((Object)popup);
        TreeModel model = tree.getModel();
        Disposer.register((Disposable)popup, (Disposable)tree);
        model.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type2) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (type2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                int testsCount = tree.getTestCount();
                int classesCount = tree.getTestClassesCount();
                popup.setCaption("Found " + testsCount + " " + StringUtil.pluralize((String)"Test", (int)testsCount) + " in " + classesCount + " " + StringUtil.pluralize((String)"Class", (int)classesCount) + " for " + title);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction$3";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        popup.showInBestPositionFor(dataContext);
        DiscoveredTestsTree discoveredTestsTree = tree;
        if (discoveredTestsTree == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(33);
        }
        return discoveredTestsTree;
    }

    public static void processMethodsAsync(@NotNull Project project, PsiMethod @NotNull [] methods, @NotNull List<String> filePaths, @NotNull TestDiscoveryProducer.PsiTestProcessor processor2, @Nullable Runnable doWhenDone) {
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(34);
        }
        if (filePaths == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(35);
        }
        if (processor2 == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(36);
        }
        if (methods == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(37);
        }
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            ShowAffectedTestsAction.processMethods(project, methods, filePaths, processor2);
            if (doWhenDone != null) {
                EdtInvocationManager.getInstance().invokeLater(doWhenDone);
            }
        });
    }

    public static void processMethods(@NotNull Project project, PsiMethod @NotNull [] methods, @NotNull List<String> filePaths, @NotNull TestDiscoveryProducer.PsiTestProcessor processor2) {
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(38);
        }
        if (filePaths == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(39);
        }
        if (processor2 == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(40);
        }
        if (methods == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(41);
        }
        List classesAndMethods = (List)ReadAction.compute(() -> Arrays.stream(methods).map(method -> ShowAffectedTestsAction.getMethodKey(method)).filter(Objects::nonNull).collect(Collectors.toList()));
        ShowAffectedTestsAction.processTestDiscovery(project, processor2, classesAndMethods, filePaths);
    }

    private static void processTestDiscovery(@NotNull Project project, @NotNull TestDiscoveryProducer.PsiTestProcessor processor2, @NotNull List<Couple<String>> classesAndMethods, @NotNull List<String> filePaths) {
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(42);
        }
        if (processor2 == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(43);
        }
        if (classesAndMethods == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(44);
        }
        if (filePaths == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(45);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        for (TestDiscoveryConfigurationProducer producer : ShowAffectedTestsAction.getRunConfigurationProducers(project)) {
            byte frameworkId = ((JavaTestConfigurationWithDiscoverySupport)producer.getConfigurationFactory().createTemplateConfiguration(project)).getTestFrameworkId();
            TestDiscoveryProducer.consumeDiscoveredTests(project, classesAndMethods, frameworkId, filePaths, (testClass, testMethod, parameter2) -> {
                PsiClass[] testClassPsi = new PsiClass[]{null};
                PsiMethod[] testMethodPsi = new PsiMethod[]{null};
                ReadAction.run(() -> DumbService.getInstance((Project)project).runWithAlternativeResolveEnabled(() -> {
                    boolean checkBases;
                    testClassPsi[0] = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project), (String)testClass, null, (boolean)true, (GlobalSearchScope)scope);
                    boolean bl = checkBases = parameter2 != null;
                    if (testClassPsi[0] != null) {
                        testMethodPsi[0] = (PsiMethod)ArrayUtil.getFirstElement((Object[])testClassPsi[0].findMethodsByName(testMethod, checkBases));
                    }
                }));
                return testClassPsi[0] == null || processor2.process(testClassPsi[0], testMethodPsi[0], parameter2);
            });
        }
    }

    @NotNull
    private static ActiveComponent createButton(final @NotNull String text2, final @NotNull Icon icon, final @NotNull Runnable listener, final @NotNull DiscoveredTestsTree tree) {
        if (text2 == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(46);
        }
        if (icon == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(47);
        }
        if (listener == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(48);
        }
        if (tree == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(49);
        }
        return new ActiveComponent.Adapter(){

            @NotNull
            public JComponent getComponent() {
                final Presentation presentation = new Presentation();
                presentation.setText(text2);
                presentation.setDescription(text2);
                presentation.setIcon(icon);
                presentation.setEnabled(false);
                tree.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                    protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type2) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (type2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (!presentation.isEnabled() && tree.getTestCount() != 0) {
                            presentation.setEnabled(true);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "type";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction$4$1";
                        objectArray[2] = "process";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                return new ActionButton(new AnAction(){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        listener.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction$4$2", "actionPerformed"));
                    }
                }, presentation, "ShowDiscoveredTestsToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            }
        };
    }

    private static void runAllDiscoveredTests(@NotNull Project project, @NotNull DiscoveredTestsTree tree, @NotNull Ref<? extends JBPopup> ref, @NotNull ConfigurationContext context, @NotNull String title) {
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(50);
        }
        if (tree == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(51);
        }
        if (ref == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(52);
        }
        if (context == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(53);
        }
        if (title == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(54);
        }
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        Module targetModule = TestDiscoveryConfigurationProducer.detectTargetModule(tree.getContainingModules(), project);
        List testMethods = Arrays.stream(tree.getTestMethods()).map(TestMethodUsage::calculateLocation).filter(Objects::nonNull).collect(Collectors.toList());
        ShowAffectedTestsAction.getRunConfigurationProducers(project).stream().map(producer -> Pair.pair((Object)producer, (Object)ContainerUtil.filter((Collection)testMethods, producer::isApplicable))).max(Comparator.comparingInt(p -> ((List)p.second).size())).map(p -> {
            Location[] locations = ((List)p.second).toArray(new Location[0]);
            return ((TestDiscoveryConfigurationProducer)((Object)((Object)p.first))).createProfile(locations, targetModule, context, title);
        }).ifPresent(profile -> {
            try {
                ExecutionEnvironmentBuilder.create((Project)project, (Executor)executor, (RunProfile)profile).buildAndExecute();
            }
            catch (ExecutionException e) {
                ExecutionUtil.handleExecutionError((Project)project, (String)executor.getToolWindowId(), (String)title, (Throwable)e);
            }
            JBPopup popup = (JBPopup)ref.get();
            if (popup != null) {
                popup.cancel();
            }
        });
    }

    @Nullable
    public static Couple<String> getMethodKey(@NotNull PsiMethod method) {
        if (method == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(55);
        }
        if (DumbService.isDumb((Project)method.getProject())) {
            return null;
        }
        PsiClass c = method.isValid() ? method.getContainingClass() : null;
        String fqn = c != null ? DiscoveredTestsTreeModel.getClassName(c) : null;
        return fqn == null ? null : Couple.of((Object)fqn, (Object)ShowAffectedTestsAction.methodSignature(method));
    }

    @NotNull
    private static String methodSignature(@NotNull PsiMethod method) {
        if (method == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(56);
        }
        String tail = "/" + ClassUtil.getAsmMethodSignature((PsiMethod)method);
        String string = (method.isConstructor() ? "<init>" : method.getName()) + tail;
        if (string == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(57);
        }
        return string;
    }

    @Nullable
    private static KeyStroke findUsagesKeyStroke() {
        AnAction action = ActionManager.getInstance().getAction("FindUsages");
        ShortcutSet shortcutSet = action == null ? null : action.getShortcutSet();
        return shortcutSet == null ? null : KeymapUtil.getKeyStroke((ShortcutSet)shortcutSet);
    }

    @NotNull
    private static List<TestDiscoveryConfigurationProducer> getRunConfigurationProducers(@NotNull Project project) {
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(58);
        }
        List<TestDiscoveryConfigurationProducer> list = RunConfigurationProducer.getProducers((Project)project).stream().filter(producer -> producer instanceof TestDiscoveryConfigurationProducer).map(producer -> (TestDiscoveryConfigurationProducer)((Object)producer)).collect(Collectors.toList());
        if (list == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(59);
        }
        return list;
    }

    @NotNull
    public static List<String> getRelativeAffectedPaths(@NotNull Project project, @NotNull Collection<? extends Change> changes2) {
        VirtualFile baseDir;
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(60);
        }
        if (changes2 == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(61);
        }
        List<String> list = (baseDir = ShowAffectedTestsAction.getBasePathAsVirtualFile(project)) == null ? Collections.emptyList() : changes2.stream().map(change -> ShowAffectedTestsAction.relativePath(baseDir, change)).filter(Objects::nonNull).map(s -> "/" + s).collect(Collectors.toList());
        if (list == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(62);
        }
        return list;
    }

    @Nullable
    static VirtualFile getBasePathAsVirtualFile(@NotNull Project project) {
        String basePath;
        if (project == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(63);
        }
        return (basePath = project.getBasePath()) == null ? null : LocalFileSystem.getInstance().findFileByPath(basePath);
    }

    @Nullable
    private static String relativePath(@NotNull VirtualFile baseDir, @NotNull Change change) {
        ContentRevision before;
        VirtualFile file;
        if (baseDir == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(64);
        }
        if (change == null) {
            ShowAffectedTestsAction.$$$reportNull$$$0(65);
        }
        if ((file = change.getVirtualFile()) == null && (before = change.getBeforeRevision()) != null) {
            return VcsFileUtil.relativePath((VirtualFile)baseDir, (FilePath)before.getFile());
        }
        return file == null ? null : VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)baseDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 24: 
            case 26: 
            case 33: 
            case 57: 
            case 59: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 24: 
            case 26: 
            case 33: 
            case 57: 
            case 59: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 18: 
            case 22: 
            case 30: 
            case 34: 
            case 38: 
            case 42: 
            case 50: 
            case 58: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 24: 
            case 26: 
            case 33: 
            case 57: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 13: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 15: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 19: 
            case 32: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 21: 
            case 23: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 35: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 36: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesAndMethods";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/actions/ShowAffectedTestsAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitle";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTreeProcessor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethods";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesInContext";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "showTree";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "methodSignature";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurationProducers";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeAffectedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showDiscoveredTestsByFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTitle";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 24: 
            case 26: 
            case 33: 
            case 57: 
            case 59: 
            case 62: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showDiscoveredTestsByPsiClass";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showDiscoveredTestsByPsiMethod";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTreeProcessor";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showDiscoveredTestsByChanges";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findMethods";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findFilesInContext";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findMethodAtCaret";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findClassAtCaret";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findElementAtCaret";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "showTree";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsAsync";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processMethods";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processTestDiscovery";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createButton";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "runAllDiscoveredTests";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getMethodKey";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "methodSignature";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationProducers";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeAffectedPaths";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getBasePathAsVirtualFile";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "relativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 24: 
            case 26: 
            case 33: 
            case 57: 
            case 59: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

