/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.TreeViewUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.util.FontUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaProjectViewDirectoryHelper
extends ProjectViewDirectoryHelper {
    public JavaProjectViewDirectoryHelper(Project project) {
        super(project);
    }

    @Nullable
    public String getLocationString(@NotNull PsiDirectory directory, boolean includeUrl, boolean includeRootType) {
        if (directory == null) {
            JavaProjectViewDirectoryHelper.$$$reportNull$$$0(0);
        }
        String result = null;
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (ProjectRootsUtil.isSourceRoot((PsiDirectory)directory) && aPackage != null) {
            result = StringUtil.nullize((String)aPackage.getQualifiedName(), (boolean)true);
        }
        String baseString = super.getLocationString(directory, includeUrl, includeRootType);
        if (result == null) {
            return baseString;
        }
        if (baseString == null) {
            return result;
        }
        return result + "," + FontUtil.spaceAndThinSpace() + baseString;
    }

    public boolean isShowFQName(ViewSettings settings, Object parentValue, PsiDirectory value2) {
        PsiPackage aPackage;
        return value2 != null && !(parentValue instanceof Project) && settings.isFlattenPackages() && (aPackage = JavaDirectoryService.getInstance().getPackage(value2)) != null && !aPackage.getQualifiedName().isEmpty();
    }

    public boolean shouldHideProjectConfigurationFilesDirectory() {
        return false;
    }

    @NotNull
    public String getNodeName(ViewSettings settings, Object parentValue, PsiDirectory directory) {
        PsiPackage parentPackage;
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (!ProjectRootsUtil.isSourceRoot((PsiDirectory)directory) && aPackage != null && !aPackage.getQualifiedName().isEmpty() && parentValue instanceof PsiDirectory) {
            parentPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)parentValue);
        } else if (ProjectRootsUtil.isSourceRoot((PsiDirectory)directory) && aPackage != null) {
            aPackage = null;
            parentPackage = null;
        } else {
            parentPackage = null;
        }
        String string = PackageUtil.getNodeName(settings, aPackage, parentPackage, directory.getName(), this.isShowFQName(settings, parentValue, directory));
        if (string == null) {
            JavaProjectViewDirectoryHelper.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean skipDirectory(PsiDirectory directory) {
        return JavaDirectoryService.getInstance().getPackage(directory) == null;
    }

    public boolean isEmptyMiddleDirectory(PsiDirectory directory, boolean strictlyEmpty, @Nullable PsiFileSystemItemFilter filter) {
        return JavaDirectoryService.getInstance().getPackage(directory) != null && TreeViewUtil.isEmptyMiddlePackage(directory, strictlyEmpty, filter);
    }

    public boolean supportsFlattenPackages() {
        return true;
    }

    public boolean supportsHideEmptyMiddlePackages() {
        return true;
    }

    public boolean canRepresent(Object element, PsiDirectory directory) {
        if (super.canRepresent(element, directory)) {
            return true;
        }
        if (element instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)element;
            return Arrays.asList(packageElement.getPackage().getDirectories()).contains(directory);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/JavaProjectViewDirectoryHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/JavaProjectViewDirectoryHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocationString";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

