/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.LoadResult;
import com.intellij.jarRepository.RepositoryLibrarySynchronizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableImplUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a,\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "loadDependenciesSync", "", "project", "Lcom/intellij/openapi/project/Project;", "submitLoadJobs", "", "toSync", "", "Lcom/intellij/openapi/roots/libraries/Library;", "queue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/intellij/jarRepository/LoadResult;", "intellij.java.ui"})
public final class SyncLoadingKt {
    private static final Logger LOG;

    public static final void loadDependenciesSync(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Set<Library> set = RepositoryLibrarySynchronizer.collectLibrariesToSync(project);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"RepositoryLibrarySynchro\u2026tLibrariesToSync(project)");
        Set<Library> toSync = set;
        if (toSync.size() == 0) {
            return;
        }
        ArrayBlockingQueue queue = new ArrayBlockingQueue(toSync.size());
        int submitted = SyncLoadingKt.submitLoadJobs(project, (Collection<? extends Library>)toSync, queue);
        LOG.info("Submitted " + submitted + " jobs for downloading maven dependencies");
        int timeout = Registry.intValue((String)"load.maven.dependencies.timeout", (int)120);
        boolean bl = false;
        int n = 0;
        int n2 = submitted;
        for (n = 0; n < n2; ++n) {
            int it = n;
            boolean bl2 = false;
            LoadResult result = (LoadResult)queue.poll(timeout, TimeUnit.MINUTES);
            if (Intrinsics.areEqual((Object)result, (Object)LoadResult.Companion.getPOISON())) {
                return;
            }
            if (result == null) {
                LOG.error("Cant resolve maven dependencies within " + timeout + " minutes");
                return;
            }
            Collection<Artifact> artifacts = result.getArtifacts();
            if (artifacts == null || artifacts.isEmpty()) continue;
            Library library = result.getLibrary();
            LOG.info("Creating roots started for - " + (library != null ? library.getName() : null));
            JarRepositoryManager.copyAndRefreshFiles(artifacts, RepositoryUtils.getStorageRoot(result.getLibrary(), project));
            Library library2 = result.getLibrary();
            LOG.info("Create roots finished for - " + (library2 != null ? library2.getName() : null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int submitLoadJobs(@NotNull Project project, @NotNull Collection<? extends Library> toSync, @NotNull BlockingQueue<LoadResult> queue) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(toSync, (String)"toSync");
        Intrinsics.checkParameterIsNotNull(queue, (String)"queue");
        int submitted = 0;
        Iterable $this$filter$iv = toSync;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Library p1 = (Library)element$iv$iv;
            boolean bl = false;
            if (!LibraryTableImplUtil.isValidLibrary((Library)p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((List)destination$iv$iv).iterator();
        while (iterator.hasNext()) {
            Promise<Collection<Artifact>> promise;
            JpsMavenRepositoryLibraryDescriptor descriptor;
            Library library;
            Library library2 = library = (Library)iterator.next();
            if (library2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.libraries.LibraryEx");
            }
            LibraryProperties properties = ((LibraryEx)library2).getProperties();
            if (!(properties instanceof RepositoryLibraryProperties)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)((RepositoryLibraryProperties)properties).getRepositoryLibraryDescriptor(), (String)"properties.repositoryLibraryDescriptor");
            Intrinsics.checkExpressionValueIsNotNull(JarRepositoryManager.loadArtifactForDependenciesAsync(project, descriptor, (Set<ArtifactKind>)EnumSet.of((Enum)ArtifactKind.ARTIFACT), null), (String)"loadArtifactForDependenc\u2026factKind.ARTIFACT), null)");
            promise.onProcessed((Consumer)new Consumer<Collection<Artifact>>(queue, library){
                final /* synthetic */ BlockingQueue $queue;
                final /* synthetic */ Library $library;

                public final void accept(@Nullable Collection<? extends Artifact> artifacts) {
                    try {
                        this.$queue.put(new LoadResult(artifacts, this.$library));
                    }
                    catch (InterruptedException e) {
                        this.$queue.clear();
                        this.$queue.offer(LoadResult.Companion.getPOISON());
                        SyncLoadingKt.access$getLOG$p().error((Throwable)e);
                    }
                }
                {
                    this.$queue = blockingQueue;
                    this.$library = library;
                }
            });
            ++submitted;
        }
        return submitted;
    }

    static {
        Logger logger = Logger.getInstance(RepositoryLibrarySynchronizer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Repos\u2026Synchronizer::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

