/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.ChooseElementsDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class AddFacetOfTypeAction
extends DumbAwareAction {
    private final FacetType myFacetType;
    private final StructureConfigurableContext myContext;

    AddFacetOfTypeAction(FacetType type2, StructureConfigurableContext context) {
        super(type2.getPresentableName(), null, type2.getIcon());
        this.myFacetType = type2;
        this.myContext = context;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        FacetType type2;
        if (e == null) {
            AddFacetOfTypeAction.$$$reportNull$$$0(0);
        }
        if ((type2 = this.myFacetType) == null) {
            return;
        }
        FacetTypeId underlyingFacetType = type2.getUnderlyingFacetType();
        if (underlyingFacetType == null) {
            this.addFacetToModule(type2);
        } else {
            this.addSubFacet(type2, underlyingFacetType);
        }
    }

    private void addSubFacet(FacetType type2, FacetTypeId<?> underlyingType) {
        ProjectFacetsConfigurator facetsConfigurator = this.myContext.getModulesConfigurator().getFacetsConfigurator();
        ArrayList suitableParents = new ArrayList();
        for (Module module : this.myContext.getModules()) {
            if (!type2.isSuitableModuleType(ModuleType.get((Module)module))) continue;
            suitableParents.addAll(facetsConfigurator.getFacetsByType(module, underlyingType));
        }
        Iterator iterator = suitableParents.iterator();
        while (iterator.hasNext()) {
            Facet parent = (Facet)iterator.next();
            if (!type2.isOnlyOneFacetAllowed() || !facetsConfigurator.hasFacetOfType(parent.getModule(), parent, type2.getId())) continue;
            iterator.remove();
        }
        Project project = this.myContext.getProject();
        if (suitableParents.isEmpty()) {
            String parentType = FacetTypeRegistry.getInstance().findFacetType(underlyingType).getPresentableName();
            Messages.showErrorDialog((Project)project, (String)JavaUiBundle.message("dialog.message.no.suitable.parent.0.facets.found", parentType), (String)JavaUiBundle.message("dialog.title.cannot.create.0.facet", type2.getPresentableName()));
            return;
        }
        ChooseParentFacetDialog dialog = new ChooseParentFacetDialog(project, suitableParents);
        dialog.show();
        List chosen = dialog.getChosenElements();
        if (!dialog.isOK() || chosen.size() != 1) {
            return;
        }
        Facet parent = (Facet)chosen.get(0);
        Facet facet = ModuleStructureConfigurable.getInstance(project).getFacetEditorFacade().createAndAddFacet(type2, parent.getModule(), parent);
        ProjectStructureConfigurable.getInstance(project).select(facet, true);
    }

    private void addFacetToModule(@NotNull FacetType type2) {
        if (type2 == null) {
            AddFacetOfTypeAction.$$$reportNull$$$0(1);
        }
        ProjectFacetsConfigurator facetsConfigurator = this.myContext.getModulesConfigurator().getFacetsConfigurator();
        ArrayList<Module> suitableModules = new ArrayList<Module>(Arrays.asList(this.myContext.getModules()));
        Iterator iterator = suitableModules.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)iterator.next();
            if (type2.isSuitableModuleType(ModuleType.get((Module)module)) && (!type2.isOnlyOneFacetAllowed() || !facetsConfigurator.hasFacetOfType(module, null, type2.getId()))) continue;
            iterator.remove();
        }
        Project project = this.myContext.getProject();
        if (suitableModules.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)JavaUiBundle.message("dialog.message.no.suitable.modules.for.0.facet.found", type2.getPresentableName()), (String)JavaUiBundle.message("dialog.title.cannot.create.facet", new Object[0]));
            return;
        }
        ChooseModulesDialog dialog = new ChooseModulesDialog(project, suitableModules, "Choose Module", type2.getPresentableName() + " facet will be added to selected module");
        dialog.setSingleSelectionMode();
        dialog.show();
        List elements = dialog.getChosenElements();
        if (!dialog.isOK() || elements.size() != 1) {
            return;
        }
        Module module = (Module)elements.get(0);
        Facet facet = ModuleStructureConfigurable.getInstance(project).getFacetEditorFacade().createAndAddFacet(type2, module, null);
        ProjectStructureConfigurable.getInstance(project).select(facet, true);
    }

    public static AnAction[] createAddFacetActions(FacetStructureConfigurable configurable) {
        ArrayList<AddFacetOfTypeAction> result = new ArrayList<AddFacetOfTypeAction>();
        StructureConfigurableContext context = configurable.myContext;
        for (FacetType type2 : FacetTypeRegistry.getInstance().getSortedFacetTypes()) {
            if (!AddFacetOfTypeAction.hasSuitableModules(context, type2)) continue;
            result.add(new AddFacetOfTypeAction(type2, context));
        }
        return result.toArray(AnAction.EMPTY_ARRAY);
    }

    private static boolean hasSuitableModules(StructureConfigurableContext context, FacetType type2) {
        for (Module module : context.getModules()) {
            if (!type2.isSuitableModuleType(ModuleType.get((Module)module))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/AddFacetOfTypeAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addFacetToModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ChooseParentFacetDialog
    extends ChooseElementsDialog<Facet> {
        private ChooseParentFacetDialog(Project project, List<? extends Facet> items) {
            super(project, items, "Select Parent Facet", null, true);
            this.myChooser.setSingleSelectionMode();
        }

        protected String getItemText(Facet item) {
            return item.getName() + " (module " + item.getModule().getName() + ")";
        }

        protected Icon getItemIcon(Facet item) {
            return item.getType().getIcon();
        }
    }
}

