/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.CommonBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.CreateNewLibraryAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.AddLibraryToModuleDependenciesAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ChangeLibraryLevelAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLibrariesConfigurable
extends BaseStructureConfigurable {
    @NotNull
    protected final String myLevel;

    protected BaseLibrariesConfigurable(@NotNull Project project, @NotNull String libraryTableLevel) {
        if (project == null) {
            BaseLibrariesConfigurable.$$$reportNull$$$0(0);
        }
        if (libraryTableLevel == null) {
            BaseLibrariesConfigurable.$$$reportNull$$$0(1);
        }
        super(project);
        this.myLevel = libraryTableLevel;
    }

    public static BaseLibrariesConfigurable getInstance(@NotNull Project project, @NotNull String tableLevel) {
        if (project == null) {
            BaseLibrariesConfigurable.$$$reportNull$$$0(2);
        }
        if (tableLevel == null) {
            BaseLibrariesConfigurable.$$$reportNull$$$0(3);
        }
        if (tableLevel.equals("project")) {
            return ProjectLibrariesConfigurable.getInstance(project);
        }
        return GlobalLibrariesConfigurable.getInstance(project);
    }

    public abstract LibraryTablePresentation getLibraryTablePresentation();

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.library";
    }

    public boolean isModified() {
        boolean isModified = false;
        for (LibrariesModifiableModel provider : this.myContext.myLevel2Providers.values()) {
            isModified |= provider.isChanged();
        }
        return isModified || super.isModified();
    }

    @Override
    public void checkCanApply() throws ConfigurationException {
        super.checkCanApply();
        this.checkForEmptyAndDuplicatedNames(JavaUiBundle.message("configurable.library.prefix", new Object[0]), CommonBundle.getErrorTitle(), LibraryConfigurable.class);
        for (LibraryConfigurable configurable : this.getLibraryConfigurables()) {
            if (!configurable.getDisplayName().isEmpty()) continue;
            ((LibraryProjectStructureElement)configurable.getProjectStructureElement()).navigate();
            throw new ConfigurationException("Library name is not specified");
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.myTree.setRootVisible(false);
    }

    @Override
    protected void loadTree() {
        this.createLibrariesNode(this.myContext.createModifiableModelProvider(this.myLevel));
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<LibraryProjectStructureElement> result = new ArrayList<LibraryProjectStructureElement>();
        for (LibraryConfigurable libraryConfigurable : this.getLibraryConfigurables()) {
            result.add(new LibraryProjectStructureElement(this.myContext, libraryConfigurable.getEditableObject()));
        }
        ArrayList<LibraryProjectStructureElement> arrayList = result;
        if (arrayList == null) {
            BaseLibrariesConfigurable.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private List<LibraryConfigurable> getLibraryConfigurables() {
        ArrayList<LibraryConfigurable> libraryConfigurables = new ArrayList<LibraryConfigurable>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            NamedConfigurable configurable;
            TreeNode node = this.myRoot.getChildAt(i);
            if (!(node instanceof MasterDetailsComponent.MyNode) || !((configurable = ((MasterDetailsComponent.MyNode)node).getConfigurable()) instanceof LibraryConfigurable)) continue;
            libraryConfigurables.add((LibraryConfigurable)configurable);
        }
        return libraryConfigurables;
    }

    private void createLibrariesNode(StructureLibraryTableModifiableModelProvider modelProvider) {
        Library[] libraries2;
        for (Library library : libraries2 = modelProvider.getModifiableModel().getLibraries()) {
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new LibraryConfigurable(modelProvider, library, this.myContext, this.TREE_UPDATER)));
        }
        TreeUtil.sortRecursively((MutableTreeNode)this.myRoot, (o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName()));
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
    }

    public void apply() throws ConfigurationException {
        super.apply();
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (LibrariesModifiableModel provider : this.myContext.myLevel2Providers.values()) {
                provider.deferredCommit();
            }
        });
    }

    @NotNull
    public String getLevel() {
        String string = this.myLevel;
        if (string == null) {
            BaseLibrariesConfigurable.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void createLibraryNode(Library library) {
        LibraryTable table = library.getTable();
        if (table != null) {
            String level = table.getTableLevel();
            LibraryConfigurable configurable = new LibraryConfigurable(this.myContext.createModifiableModelProvider(level), library, this.myContext, this.TREE_UPDATER);
            MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable);
            this.addNode(node, this.myRoot);
            ProjectStructureDaemonAnalyzer daemonAnalyzer = this.myContext.getDaemonAnalyzer();
            daemonAnalyzer.queueUpdate(new LibraryProjectStructureElement(this.myContext, library));
            daemonAnalyzer.queueUpdateForAllElementsWithErrors();
        }
    }

    public void removeLibraryNode(@NotNull Library library) {
        if (library == null) {
            BaseLibrariesConfigurable.$$$reportNull$$$0(6);
        }
        this.removeLibrary(new LibraryProjectStructureElement(this.myContext, library));
    }

    public void dispose() {
        if (this.myContext != null) {
            for (LibrariesModifiableModel provider : this.myContext.myLevel2Providers.values()) {
                Disposer.dispose((Disposable)provider);
            }
        }
    }

    @Override
    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean fromPopup) {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add((Object)new CopyLibraryAction());
        if (fromPopup) {
            BaseLibrariesConfigurable targetGroup = this.getOppositeGroup();
            actions.add((Object)new ChangeLibraryLevelAction(this.myProject, (JComponent)this.myTree, this, targetGroup));
            actions.add((Object)new AddLibraryToModuleDependenciesAction(this.myProject, this));
        }
        ArrayList<Object> arrayList = actions;
        if (arrayList == null) {
            BaseLibrariesConfigurable.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(this.getAddText()){

            public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = CreateNewLibraryAction.createActionOrGroup(BaseLibrariesConfigurable.this.getAddText(), BaseLibrariesConfigurable.this, BaseLibrariesConfigurable.this.myProject);
                if (anActionArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable$1", "getChildren"));
            }
        };
    }

    protected abstract String getAddText();

    public abstract StructureLibraryTableModifiableModelProvider getModelProvider();

    public abstract BaseLibrariesConfigurable getOppositeGroup();

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        boolean selectionChanged;
        boolean bl = selectionChanged = !Comparing.equal((Object)this.myCurrentConfigurable, (Object)configurable);
        if (this.myCurrentConfigurable instanceof LibraryConfigurable && selectionChanged) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onUnselected();
        }
        super.updateSelection(configurable);
        if (this.myCurrentConfigurable instanceof LibraryConfigurable && selectionChanged) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onSelected();
        }
    }

    @Override
    public void onStructureUnselected() {
        if (this.myCurrentConfigurable instanceof LibraryConfigurable) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onUnselected();
        }
    }

    @Override
    public void onStructureSelected() {
        if (this.myCurrentConfigurable instanceof LibraryConfigurable) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onSelected();
        }
    }

    public void removeLibrary(@NotNull LibraryProjectStructureElement element) {
        if (element == null) {
            BaseLibrariesConfigurable.$$$reportNull$$$0(8);
        }
        this.removeLibraries(Collections.singletonList(element));
    }

    public void removeLibraries(@NotNull List<? extends LibraryProjectStructureElement> libraries2) {
        if (libraries2 == null) {
            BaseLibrariesConfigurable.$$$reportNull$$$0(9);
        }
        ArrayList<TreePath> pathsToRemove = new ArrayList<TreePath>();
        for (LibraryProjectStructureElement libraryProjectStructureElement : libraries2) {
            this.getModelProvider().getModifiableModel().removeLibrary(libraryProjectStructureElement.getLibrary());
            MasterDetailsComponent.MyNode node = BaseLibrariesConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)libraryProjectStructureElement.getLibrary());
            if (node == null) continue;
            pathsToRemove.add(TreeUtil.getPathFromRoot((TreeNode)node));
        }
        this.myContext.getDaemonAnalyzer().removeElements(libraries2);
        this.removePaths(TreePathUtil.toTreePathArray(pathsToRemove));
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new RemoveConfigurableHandler<Library>(LibraryConfigurable.class){

            @Override
            public boolean remove(@NotNull Collection<? extends Library> libraries2) {
                if (libraries2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                ArrayList<Pair> toRemove2 = new ArrayList<Pair>();
                String firstLibraryUsageDescription = null;
                String firstLibraryWithUsageName = null;
                int librariesWithUsages = 0;
                for (Library library : libraries2) {
                    LibraryTable table = library.getTable();
                    if (table == null) continue;
                    LibraryProjectStructureElement libraryElement = new LibraryProjectStructureElement(BaseLibrariesConfigurable.this.myContext, library);
                    ArrayList<ProjectStructureElementUsage> usages = new ArrayList<ProjectStructureElementUsage>(BaseLibrariesConfigurable.this.myContext.getDaemonAnalyzer().getUsages(libraryElement));
                    if (usages.size() > 0) {
                        if (librariesWithUsages == 0) {
                            MultiMap containerType2Usage = new MultiMap();
                            for (ProjectStructureElementUsage usage : usages) {
                                containerType2Usage.putValue((Object)usage.getContainingElement().getTypeName(), (Object)usage);
                            }
                            ArrayList types = new ArrayList(containerType2Usage.keySet());
                            Collections.sort(types);
                            StringBuilder sb = new StringBuilder("Library '");
                            Library libraryModel = BaseLibrariesConfigurable.this.myContext.getLibraryModel(library);
                            sb.append(libraryModel != null ? libraryModel.getName() : library.getName()).append("' is used in ");
                            for (int i = 0; i < types.size(); ++i) {
                                if (i > 0 && i == types.size() - 1) {
                                    sb.append(" and in ");
                                } else if (i > 0) {
                                    sb.append(", in ");
                                }
                                String type2 = (String)types.get(i);
                                Collection usagesOfType = containerType2Usage.get((Object)type2);
                                if (usagesOfType.size() > 1) {
                                    sb.append(usagesOfType.size()).append(" ").append(StringUtil.decapitalize((String)StringUtil.pluralize((String)type2)));
                                    continue;
                                }
                                sb.append(StringUtil.decapitalize((String)((ProjectStructureElementUsage)usagesOfType.iterator().next()).getContainingElement().getPresentableText()));
                            }
                            firstLibraryWithUsageName = library.getName();
                            firstLibraryUsageDescription = sb.toString();
                        }
                        ++librariesWithUsages;
                    }
                    toRemove2.add(Pair.create((Object)libraryElement, usages));
                }
                if (librariesWithUsages > 0) {
                    String message2;
                    if (librariesWithUsages == 1) {
                        String message22 = firstLibraryUsageDescription + ".\nAre you sure you want to delete this library?";
                    } else {
                        message2 = JavaUiBundle.message("libraries.remove.confirmation.text", firstLibraryWithUsageName, librariesWithUsages - 1);
                    }
                    if (0 != Messages.showOkCancelDialog((Project)BaseLibrariesConfigurable.this.myProject, (String)message2, (String)JavaUiBundle.message("libraries.remove.confirmation.title", librariesWithUsages), (Icon)Messages.getQuestionIcon())) {
                        return false;
                    }
                }
                for (Pair pair2 : toRemove2) {
                    for (ProjectStructureElementUsage usage : (Collection)pair2.getSecond()) {
                        usage.removeSourceElement();
                    }
                    BaseLibrariesConfigurable.this.getModelProvider().getModifiableModel().removeLibrary(((LibraryProjectStructureElement)pair2.getFirst()).getLibrary());
                    BaseLibrariesConfigurable.this.myContext.getDaemonAnalyzer().removeElement((ProjectStructureElement)pair2.getFirst());
                }
                return true;
            }

            @Override
            public boolean canBeRemoved(@NotNull Collection<? extends Library> libraries2) {
                if (libraries2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                for (Library library : libraries2) {
                    LibraryTable table = library.getTable();
                    if (table == null || table.isEditable()) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "libraries";
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "remove";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canBeRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    protected String getEmptySelectionString() {
        return JavaUiBundle.message("configurable.empty.text.select.library", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTableLevel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableLevel";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStructureElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLevel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeLibraryNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeLibrary";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CopyLibraryAction
    extends AnAction {
        private CopyLibraryAction() {
            super(CommonBundle.messagePointer((String)"button.copy", (Object[])new Object[0]), CommonBundle.messagePointer((String)"button.copy", (Object[])new Object[0]), COPY_ICON);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object o;
            if (e == null) {
                CopyLibraryAction.$$$reportNull$$$0(0);
            }
            if ((o = BaseLibrariesConfigurable.this.getSelectedObject()) instanceof LibraryEx) {
                LibraryEx selected = (LibraryEx)o;
                String newName = Messages.showInputDialog((String)JavaUiBundle.message("label.enter.library.name", new Object[0]), (String)JavaUiBundle.message("dialog.title.copy.library", new Object[0]), null, (String)(selected.getName() + "2"), (InputValidator)new NonEmptyInputValidator());
                if (newName == null) {
                    return;
                }
                BaseLibrariesConfigurable configurable = BaseLibrariesConfigurable.this;
                LibraryEx library = (LibraryEx)BaseLibrariesConfigurable.this.myContext.getLibrary(selected.getName(), BaseLibrariesConfigurable.this.myLevel);
                LOG.assertTrue(library != null);
                LibrariesModifiableModel libsModel = configurable.getModelProvider().getModifiableModel();
                Library lib = libsModel.createLibrary(newName, library.getKind());
                LibraryEx.ModifiableModelEx model = libsModel.getLibraryEditor(lib).getModel();
                LibraryEditingUtil.copyLibrary(library, Collections.emptyMap(), model);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyLibraryAction.$$$reportNull$$$0(1);
            }
            if (BaseLibrariesConfigurable.this.myTree.getSelectionPaths() == null || BaseLibrariesConfigurable.this.myTree.getSelectionPaths().length != 1) {
                e.getPresentation().setEnabled(false);
            } else {
                e.getPresentation().setEnabled(BaseLibrariesConfigurable.this.getSelectedObject() instanceof LibraryEx);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable$CopyLibraryAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

