/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LibrariesModifiableModel
implements LibraryTable.ModifiableModel {
    private final Map<Library, ExistingLibraryEditor> myLibrary2EditorMap = new IdentityHashMap<Library, ExistingLibraryEditor>();
    private final Set<Library> myRemovedLibraries = Collections.newSetFromMap(new IdentityHashMap());
    private LibraryTable.ModifiableModel myLibrariesModifiableModel;
    private final Project myProject;
    private final LibraryTable myTable;
    private final LibraryEditorListener myLibraryEditorListener;

    public LibrariesModifiableModel(LibraryTable table, Project project, LibraryEditorListener libraryEditorListener) {
        this.myProject = project;
        this.myTable = table;
        this.myLibraryEditorListener = libraryEditorListener;
    }

    @NotNull
    public Library createLibrary(String name2) {
        Library library = this.createLibrary(name2, null);
        if (library == null) {
            LibrariesModifiableModel.$$$reportNull$$$0(0);
        }
        return library;
    }

    @NotNull
    public Library createLibrary(String name2, @Nullable PersistentLibraryKind<?> type2) {
        Library library = this.createLibrary(name2, type2, null);
        if (library == null) {
            LibrariesModifiableModel.$$$reportNull$$$0(1);
        }
        return library;
    }

    @NotNull
    public Library createLibrary(String name2, @Nullable PersistentLibraryKind<?> type2, @Nullable ProjectModelExternalSource externalSource) {
        Library library = this.getLibrariesModifiableModel().createLibrary(name2, type2, externalSource);
        BaseLibrariesConfigurable configurable = ProjectStructureConfigurable.getInstance(this.myProject).getConfigurableFor(library);
        configurable.createLibraryNode(library);
        Library library2 = library;
        if (library2 == null) {
            LibrariesModifiableModel.$$$reportNull$$$0(2);
        }
        return library2;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            LibrariesModifiableModel.$$$reportNull$$$0(3);
        }
        if (this.getLibrariesModifiableModel().getLibraryByName(library.getName()) == null) {
            return;
        }
        this.removeLibraryEditor(library);
        Library existingLibrary = this.myTable.getLibraryByName(library.getName());
        this.getLibrariesModifiableModel().removeLibrary(library);
        BaseLibrariesConfigurable configurable = ProjectStructureConfigurable.getInstance(this.myProject).getConfigurableFor(library);
        configurable.removeLibraryNode(library);
        if (existingLibrary == library) {
            this.myRemovedLibraries.add(library);
        }
    }

    public void commit() {
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator iterator = this.getLibrariesModifiableModel().getLibraryIterator();
        if (iterator == null) {
            LibrariesModifiableModel.$$$reportNull$$$0(4);
        }
        return iterator;
    }

    public Library getLibraryByName(@NotNull String name2) {
        if (name2 == null) {
            LibrariesModifiableModel.$$$reportNull$$$0(5);
        }
        return this.getLibrariesModifiableModel().getLibraryByName(name2);
    }

    public Library @NotNull [] getLibraries() {
        Library[] libraryArray = this.getLibrariesModifiableModel().getLibraries();
        if (libraryArray == null) {
            LibrariesModifiableModel.$$$reportNull$$$0(6);
        }
        return libraryArray;
    }

    public boolean isChanged() {
        for (LibraryEditor libraryEditor : this.myLibrary2EditorMap.values()) {
            if (!libraryEditor.hasChanges()) continue;
            return true;
        }
        return this.getLibrariesModifiableModel().isChanged();
    }

    public void deferredCommit() {
        ArrayList<ExistingLibraryEditor> libraryEditors = new ArrayList<ExistingLibraryEditor>(this.myLibrary2EditorMap.values());
        this.myLibrary2EditorMap.clear();
        for (ExistingLibraryEditor libraryEditor : libraryEditors) {
            libraryEditor.commit();
            Disposer.dispose((Disposable)libraryEditor);
        }
        if (!libraryEditors.isEmpty() || !this.myRemovedLibraries.isEmpty() || this.myLibrariesModifiableModel != null && this.myLibrariesModifiableModel.isChanged()) {
            this.getLibrariesModifiableModel().commit();
            this.myLibrariesModifiableModel = null;
        }
        this.myRemovedLibraries.clear();
    }

    public boolean wasLibraryRemoved(Library library) {
        return this.myRemovedLibraries.contains(library);
    }

    public boolean hasLibraryEditor(Library library) {
        return this.myLibrary2EditorMap.containsKey(library);
    }

    public ExistingLibraryEditor getLibraryEditor(Library library) {
        Library source;
        if (library instanceof LibraryEx && (source = ((LibraryEx)library).getSource()) != null) {
            return this.getLibraryEditor(source);
        }
        ExistingLibraryEditor libraryEditor = this.myLibrary2EditorMap.get(library);
        if (libraryEditor == null) {
            libraryEditor = this.createLibraryEditor(library);
        }
        return libraryEditor;
    }

    private ExistingLibraryEditor createLibraryEditor(Library library) {
        ExistingLibraryEditor libraryEditor = new ExistingLibraryEditor(library, this.myLibraryEditorListener);
        this.myLibrary2EditorMap.put(library, libraryEditor);
        return libraryEditor;
    }

    private void removeLibraryEditor(Library library) {
        ExistingLibraryEditor libraryEditor = this.myLibrary2EditorMap.remove(library);
        if (libraryEditor != null) {
            Disposer.dispose((Disposable)libraryEditor);
        }
    }

    public Library.ModifiableModel getLibraryModifiableModel(Library library) {
        return this.getLibraryEditor(library).getModel();
    }

    private LibraryTable.ModifiableModel getLibrariesModifiableModel() {
        if (this.myLibrariesModifiableModel == null) {
            this.myLibrariesModifiableModel = this.myTable.getModifiableModel();
        }
        return this.myLibrariesModifiableModel;
    }

    public void dispose() {
        if (this.myLibrariesModifiableModel != null) {
            Disposer.dispose((Disposable)this.myLibrariesModifiableModel);
            this.myLibrariesModifiableModel = null;
        }
        this.disposeLibraryEditors();
    }

    private void disposeLibraryEditors() {
        for (ExistingLibraryEditor libraryEditor : this.myLibrary2EditorMap.values()) {
            Disposer.dispose((Disposable)libraryEditor);
        }
        this.myLibrary2EditorMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibrary";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryIterator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeLibrary";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

