/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.JavaModuleSystemEx;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExportsDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddRequiresDirectiveFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCompilerConfigurationProxy;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.JavaPlatformModuleSystem;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003 !\"B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\u0010H\u0016J,\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\nH\u0016J(\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007H\u0002J(\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\nH\u0002J\"\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\u0010H\u0016J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\u001e2\u0006\u0010\u001f\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/psi/impl/JavaPlatformModuleSystem;", "Lcom/intellij/codeInsight/JavaModuleSystemEx;", "()V", "ERR", "Lcom/intellij/codeInsight/JavaModuleSystemEx$ErrorWithFixes;", "checkAccess", "target", "Lcom/intellij/psi/PsiFileSystemItem;", "place", "packageName", "", "quick", "", "targetPackageName", "targetFile", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/psi/PsiElement;", "getName", "hasUpgrade", "module", "Lcom/intellij/openapi/module/Module;", "targetName", "inAddedExports", "useName", "inAddedModules", "moduleName", "isAccessible", "optionValues", "Lkotlin/sequences/Sequence;", "options", "", "name", "AddExportsOptionFix", "AddModulesOptionFix", "CompilerOptionFix", "intellij.java.impl"})
public final class JavaPlatformModuleSystem
implements JavaModuleSystemEx {
    private final JavaModuleSystemEx.ErrorWithFixes ERR = new JavaModuleSystemEx.ErrorWithFixes("-");

    @NotNull
    public String getName() {
        return "Java Platform Module System";
    }

    public boolean isAccessible(@NotNull String targetPackageName, @Nullable PsiFile targetFile, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)targetPackageName, (String)"targetPackageName");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        PsiFile psiFile = targetFile;
        return this.checkAccess(targetPackageName, (PsiFile)(psiFile != null ? psiFile.getOriginalFile() : null), place, true) == null;
    }

    @Nullable
    public JavaModuleSystemEx.ErrorWithFixes checkAccess(@NotNull String targetPackageName, @Nullable PsiFile targetFile, @NotNull PsiElement place) {
        Intrinsics.checkParameterIsNotNull((Object)targetPackageName, (String)"targetPackageName");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        PsiFile psiFile = targetFile;
        return this.checkAccess(targetPackageName, (PsiFile)(psiFile != null ? psiFile.getOriginalFile() : null), place, false);
    }

    private final JavaModuleSystemEx.ErrorWithFixes checkAccess(String targetPackageName, PsiFile targetFile, PsiElement place, boolean quick) {
        PsiFile useFile;
        PsiFile psiFile = place.getContainingFile();
        Object object = useFile = psiFile != null ? psiFile.getOriginalFile() : null;
        if (useFile != null && PsiUtil.isLanguageLevel9OrHigher((PsiElement)((PsiElement)useFile))) {
            VirtualFile useVFile = useFile.getVirtualFile();
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)useFile.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(useFile.project)");
            ProjectFileIndex index = projectFileIndex;
            if (useVFile == null || !index.isInLibrarySource(useVFile)) {
                Module module;
                PsiPackage target;
                if (targetFile != null && targetFile.isPhysical()) {
                    return this.checkAccess((PsiFileSystemItem)targetFile, (PsiFileSystemItem)useFile, targetPackageName, quick);
                }
                if (useVFile != null && (target = JavaPsiFacade.getInstance((Project)useFile.getProject()).findPackage(targetPackageName)) != null && (module = index.getModuleForFile(useVFile)) != null) {
                    Object object2;
                    boolean test = index.isInTestSourceContent(useVFile);
                    Object[] dirs = target.getDirectories(module.getModuleWithDependenciesAndLibrariesScope(test));
                    Intrinsics.checkExpressionValueIsNotNull((Object)dirs, (String)"dirs");
                    Object[] objectArray = dirs;
                    boolean bl = false;
                    if (objectArray.length == 0) {
                        return quick ? this.ERR : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorBundle.message("package.not.found", target.getQualifiedName()));
                    }
                    PsiDirectory psiDirectory = dirs[0];
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"dirs[0]");
                    PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)psiDirectory;
                    PsiFileSystemItem psiFileSystemItem2 = (PsiFileSystemItem)useFile;
                    String string = target.getQualifiedName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.qualifiedName");
                    JavaModuleSystemEx.ErrorWithFixes error = this.checkAccess(psiFileSystemItem, psiFileSystemItem2, string, quick);
                    if (error == null) {
                        object2 = null;
                    } else if (dirs.length == 1) {
                        object2 = error;
                    } else {
                        boolean bl2;
                        block10: {
                            Sequence $this$any$iv = SequencesKt.drop((Sequence)ArraysKt.asSequence((Object[])dirs), (int)1);
                            boolean $i$f$any = false;
                            for (Object element$iv : $this$any$iv) {
                                PsiDirectory it = (PsiDirectory)element$iv;
                                boolean bl3 = false;
                                PsiDirectory psiDirectory2 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory2, (String)"it");
                                PsiFileSystemItem psiFileSystemItem3 = (PsiFileSystemItem)psiDirectory2;
                                PsiFileSystemItem psiFileSystemItem4 = (PsiFileSystemItem)useFile;
                                String string2 = target.getQualifiedName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"target.qualifiedName");
                                if (!(this.checkAccess(psiFileSystemItem3, psiFileSystemItem4, string2, true) == null)) continue;
                                bl2 = true;
                                break block10;
                            }
                            bl2 = false;
                        }
                        object2 = bl2 ? null : error;
                    }
                    return object2;
                }
            }
        }
        return null;
    }

    private final JavaModuleSystemEx.ErrorWithFixes checkAccess(PsiFileSystemItem target, PsiFileSystemItem place, String packageName, boolean quick) {
        block18: {
            PsiJavaModule useModule;
            block14: {
                Module module;
                boolean bl;
                Object useName;
                String targetName;
                PsiJavaModule targetModule;
                block15: {
                    boolean isRoot;
                    block17: {
                        block16: {
                            VirtualFile origin;
                            Module module2;
                            targetModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)target);
                            useModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)place);
                            if (targetModule == null) break block14;
                            if (Intrinsics.areEqual((Object)targetModule, (Object)useModule)) {
                                return null;
                            }
                            String string = targetModule.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"targetModule.name");
                            targetName = string;
                            Object object = useModule;
                            if (object == null || (object = object.getName()) == null) {
                                object = "ALL-UNNAMED";
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"useModule?.name ?: \"ALL-UNNAMED\"");
                            useName = object;
                            VirtualFile virtualFile = place.getVirtualFile();
                            if (virtualFile != null) {
                                VirtualFile virtualFile2 = virtualFile;
                                boolean bl2 = false;
                                bl = false;
                                VirtualFile it = virtualFile2;
                                boolean bl3 = false;
                                module2 = ProjectFileIndex.getInstance((Project)place.getProject()).getModuleForFile(it);
                            } else {
                                module2 = module = null;
                            }
                            if (useModule != null) break block15;
                            PsiFile psiFile = targetModule.getContainingFile();
                            Object object2 = origin = psiFile != null ? psiFile.getVirtualFile() : null;
                            if (origin == null || module == null) break block16;
                            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                            if (moduleRootManager.getFileIndex().getOrderEntryForFile(origin) instanceof JdkOrderEntry) break block17;
                        }
                        return null;
                    }
                    boolean bl4 = isRoot = !StringsKt.startsWith$default((String)targetName, (String)"java.", (boolean)false, (int)2, null) || this.inAddedModules(module, targetName) || this.hasUpgrade(module, targetName, packageName, place);
                    if (!isRoot) {
                        PsiJavaModule root = JavaPsiFacade.getInstance((Project)place.getProject()).findModule("java.se", module.getModuleWithLibrariesScope());
                        boolean bl5 = isRoot = root == null || JavaModuleGraphUtil.reads(root, targetModule);
                    }
                    if (!isRoot) {
                        return quick ? this.ERR : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorBundle.message("module.access.not.in.graph", packageName, targetName), CollectionsKt.listOf((Object)new AddModulesOptionFix(module, targetName)));
                    }
                }
                if (!(targetModule instanceof LightJavaModule || JavaModuleGraphUtil.exports(targetModule, packageName, useModule) || module != null && this.inAddedExports(module, targetName, packageName, (String)useName))) {
                    if (quick) {
                        return this.ERR;
                    }
                    CharSequence charSequence = packageName;
                    bl = false;
                    List fixes = charSequence.length() == 0 ? CollectionsKt.emptyList() : (targetModule instanceof PsiCompiledElement && module != null ? CollectionsKt.listOf((Object)new AddExportsOptionFix(module, targetName, packageName, (String)useName)) : (!(targetModule instanceof PsiCompiledElement) && useModule != null ? CollectionsKt.listOf((Object)((Object)new AddExportsDirectiveFix(targetModule, packageName, (String)useName))) : CollectionsKt.emptyList()));
                    charSequence = useModule;
                    return charSequence == null ? new JavaModuleSystemEx.ErrorWithFixes(JavaErrorBundle.message("module.access.from.unnamed", packageName, targetName), fixes) : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorBundle.message("module.access.from.named", packageName, targetName, useName), fixes);
                }
                if (useModule != null && !Intrinsics.areEqual((Object)targetName, (Object)"java.base") && !JavaModuleGraphUtil.reads(useModule, targetModule)) {
                    return quick ? this.ERR : (PsiNameHelper.isValidModuleName((String)targetName, (PsiElement)((PsiElement)useModule)) ? new JavaModuleSystemEx.ErrorWithFixes(JavaErrorBundle.message("module.access.does.not.read", packageName, targetName, useName), CollectionsKt.listOf((Object)((Object)new AddRequiresDirectiveFix(useModule, targetName)))) : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorBundle.message("module.access.bad.name", packageName, targetName)));
                }
                break block18;
            }
            if (useModule != null) {
                return quick ? this.ERR : new JavaModuleSystemEx.ErrorWithFixes(JavaErrorBundle.message("module.access.to.unnamed", packageName, useModule.getName()));
            }
        }
        return null;
    }

    private final boolean hasUpgrade(Module module, String targetName, String packageName, PsiFileSystemItem place) {
        VirtualFile useVFile;
        PsiPackage target;
        if (PsiJavaModule.UPGRADEABLE.contains(targetName) && (target = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(packageName)) != null && (useVFile = place.getVirtualFile()) != null) {
            boolean bl;
            block2: {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                ModuleFileIndex moduleFileIndex = moduleRootManager.getFileIndex();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleFileIndex, (String)"ModuleRootManager.getInstance(module).fileIndex");
                ModuleFileIndex index = moduleFileIndex;
                boolean test = index.isInTestSourceContent(useVFile);
                Object[] dirs = target.getDirectories(module.getModuleWithDependenciesAndLibrariesScope(test));
                Intrinsics.checkExpressionValueIsNotNull((Object)dirs, (String)"dirs");
                Sequence $this$any$iv = ArraysKt.asSequence((Object[])dirs);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiDirectory it = (PsiDirectory)element$iv;
                    boolean bl2 = false;
                    PsiDirectory psiDirectory = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiDirectory, (String)"it");
                    if (!(!(index.getOrderEntryForFile(psiDirectory.getVirtualFile()) instanceof JdkOrderEntry))) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    private final boolean inAddedExports(Module module, String targetName, String packageName, String useName) {
        boolean bl;
        block2: {
            List options = JavaCompilerConfigurationProxy.getAdditionalOptions((Project)module.getProject(), (Module)module);
            if (options.isEmpty()) {
                return false;
            }
            String prefix = targetName + '/' + packageName + '=';
            List list = options;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"options");
            Sequence $this$any$iv = SequencesKt.flatMap((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(this.optionValues(list, "--add-exports"), (Function1)((Function1)new Function1<String, Boolean>(prefix){
                final /* synthetic */ String $prefix;

                public final boolean invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return StringsKt.startsWith$default((String)it, (String)this.$prefix, (boolean)false, (int)2, null);
                }
                {
                    this.$prefix = string;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<String, String>(prefix){
                final /* synthetic */ String $prefix;

                @NotNull
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String string = it;
                    int n = this.$prefix.length();
                    boolean bl = false;
                    String string2 = string.substring(n);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    return string2;
                }
                {
                    this.$prefix = string;
                    super(1);
                }
            })), (Function1)inAddedExports.3.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)useName)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean inAddedModules(Module module, String moduleName) {
        boolean bl;
        block1: {
            List options;
            List list = options = JavaCompilerConfigurationProxy.getAdditionalOptions((Project)module.getProject(), (Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"options");
            Sequence $this$any$iv = SequencesKt.flatMap(this.optionValues(list, "--add-modules"), (Function1)inAddedModules.1.INSTANCE);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it, (Object)moduleName) || Intrinsics.areEqual((Object)it, (Object)"ALL-SYSTEM") || Intrinsics.areEqual((Object)it, (Object)"ALL-MODULE-PATH"))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<String> optionValues(List<String> options, String name2) {
        Sequence sequence;
        if (options.isEmpty()) {
            sequence = SequencesKt.emptySequence();
        } else {
            void useValue;
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            sequence = SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)options), (Function1)((Function1)new Function1<String, String>(name2, (Ref.BooleanRef)useValue){
                final /* synthetic */ String $name;
                final /* synthetic */ Ref.BooleanRef $useValue;

                @NotNull
                public final String invoke(@NotNull String it) {
                    String string;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (Intrinsics.areEqual((Object)it, (Object)this.$name)) {
                        this.$useValue.element = true;
                        string = "";
                    } else if (this.$useValue.element) {
                        this.$useValue.element = false;
                        string = it;
                    } else if (StringsKt.startsWith$default((String)it, (String)this.$name, (boolean)false, (int)2, null) && it.charAt(this.$name.length()) == '=') {
                        String string2 = it;
                        int n = this.$name.length() + 1;
                        boolean bl = false;
                        String string3 = string2.substring(n);
                        string = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    } else {
                        string = "";
                    }
                    return string;
                }
                {
                    this.$name = string;
                    this.$useValue = booleanRef;
                    super(1);
                }
            })), (Function1)optionValues.2.INSTANCE);
        }
        return sequence;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\b\"\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0017J%\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0096\u0002J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0016\u0010\u0015\u001a\u00020\f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0017H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/psi/impl/JavaPlatformModuleSystem$CompilerOptionFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "getElementToMakeWritable", "Lcom/intellij/psi/PsiElement;", "currentFile", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "isAvailable", "", "startInWriteAction", "update", "options", "", "intellij.java.impl"})
    private static abstract class CompilerOptionFix
    implements IntentionAction {
        private final Module module;

        @NonNls
        @NotNull
        public String getFamilyName() {
            return "Fix compiler option";
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return !this.module.isDisposed();
        }

        public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            if (this.isAvailable(project, editor, file)) {
                List list = JavaCompilerConfigurationProxy.getAdditionalOptions((Project)this.module.getProject(), (Module)this.module);
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"JavaCompilerConfiguratio\u2026s(module.project, module)");
                List options = CollectionsKt.toMutableList((Collection)list);
                this.update(options);
                JavaCompilerConfigurationProxy.setAdditionalOptions((Project)this.module.getProject(), (Module)this.module, (List)options);
                PsiManager.getInstance((Project)project).dropPsiCaches();
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        }

        protected abstract void update(@NotNull List<String> var1);

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            Intrinsics.checkParameterIsNotNull((Object)currentFile, (String)"currentFile");
            return null;
        }

        public boolean startInWriteAction() {
            return true;
        }

        public CompilerOptionFix(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            this.module = module;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\r\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0014R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/psi/impl/JavaPlatformModuleSystem$AddExportsOptionFix;", "Lcom/intellij/psi/impl/JavaPlatformModuleSystem$CompilerOptionFix;", "module", "Lcom/intellij/openapi/module/Module;", "targetName", "", "packageName", "useName", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "qualifier", "getText", "Lorg/jetbrains/annotations/NotNull;", "update", "", "options", "", "intellij.java.impl"})
    private static final class AddExportsOptionFix
    extends CompilerOptionFix {
        private final String qualifier;
        private final String useName;

        @NotNull
        public String getText() {
            String string = QuickFixBundle.message("add.compiler.option.fix.name", "--add-exports " + this.qualifier + '=' + this.useName);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"QuickFixBundle.message(\"\u2026${qualifier}=${useName}\")");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void update(@NotNull List<String> options) {
            Intrinsics.checkParameterIsNotNull(options, (String)"options");
            int idx = -1;
            int candidate = -1;
            int offset = 0;
            String prefix = "--add-exports";
            boolean bl = false;
            for (String option : (Iterable)options) {
                void i;
                if (StringsKt.startsWith$default((String)option, (String)prefix, (boolean)false, (int)2, null)) {
                    if (option.length() == prefix.length()) {
                        candidate = i + true;
                        offset = 0;
                    } else if (option.charAt(prefix.length()) == '=') {
                        candidate = i;
                        offset = prefix.length() + 1;
                    }
                }
                if (i == candidate && StringsKt.startsWith$default((String)option, (String)this.qualifier, (int)offset, (boolean)false, (int)4, null)) {
                    int qualifierEnd = this.qualifier.length() + offset;
                    if (option.length() == qualifierEnd || option.charAt(qualifierEnd) == '=') {
                        idx = i;
                    }
                }
                ++i;
            }
            switch (idx) {
                case -1: {
                    Collection collection = options;
                    Iterable iterable = CollectionsKt.listOf((Object[])new String[]{prefix, this.qualifier + '=' + this.useName});
                    boolean bl2 = false;
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                    break;
                }
                default: {
                    options.set(idx, StringsKt.trimEnd((String)options.get(idx), (char[])new char[]{','}) + ',' + this.useName);
                }
            }
        }

        public AddExportsOptionFix(@NotNull Module module, @NotNull String targetName, @NotNull String packageName, @NotNull String useName) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)targetName, (String)"targetName");
            Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
            Intrinsics.checkParameterIsNotNull((Object)useName, (String)"useName");
            super(module);
            this.useName = useName;
            this.qualifier = targetName + '/' + packageName;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\bH\u0016J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/psi/impl/JavaPlatformModuleSystem$AddModulesOptionFix;", "Lcom/intellij/psi/impl/JavaPlatformModuleSystem$CompilerOptionFix;", "module", "Lcom/intellij/openapi/module/Module;", "moduleName", "", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "getText", "Lorg/jetbrains/annotations/NotNull;", "update", "", "options", "", "intellij.java.impl"})
    private static final class AddModulesOptionFix
    extends CompilerOptionFix {
        private final String moduleName;

        @NotNull
        public String getText() {
            String string = QuickFixBundle.message("add.compiler.option.fix.name", "--add-modules " + this.moduleName);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"QuickFixBundle.message(\"\u2026d-modules ${moduleName}\")");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void update(@NotNull List<String> options) {
            Object object;
            Object option2;
            Intrinsics.checkParameterIsNotNull(options, (String)"options");
            int idx = -1;
            String prefix = "--add-modules";
            int n = 0;
            for (Object option2 : (Iterable)options) {
                void i;
                if (StringsKt.startsWith$default((String)option2, (String)prefix, (boolean)false, (int)2, null)) {
                    if (((String)option2).length() == prefix.length()) {
                        idx = i + true;
                    } else if (((String)option2).charAt(prefix.length()) == '=') {
                        idx = i;
                    }
                }
                ++i;
            }
            n = idx;
            if (n == -1) {
                option2 = options;
                object = CollectionsKt.listOf((Object[])new String[]{prefix, this.moduleName});
                boolean bl = false;
                CollectionsKt.addAll((Collection)option2, (Iterable)object);
            } else if (n == options.size()) {
                option2 = options;
                object = this.moduleName;
                boolean bl = false;
                option2.add(object);
            } else {
                String value2 = options.get(idx);
                options.set(idx, StringsKt.endsWith$default((CharSequence)value2, (char)'=', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)value2, (char)',', (boolean)false, (int)2, null) ? value2 + this.moduleName : value2 + ',' + this.moduleName);
            }
        }

        public AddModulesOptionFix(@NotNull Module module, @NotNull String moduleName) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
            super(module);
            this.moduleName = moduleName;
        }
    }
}

