/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.impl.file.PsiJavaDirectoryImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class PsiJavaDirectoryFactory
extends PsiDirectoryFactory {
    private final PsiManagerImpl myManager;

    public PsiJavaDirectoryFactory(@NotNull Project project) {
        if (project == null) {
            PsiJavaDirectoryFactory.$$$reportNull$$$0(0);
        }
        this.myManager = (PsiManagerImpl)PsiManager.getInstance((Project)project);
    }

    @NotNull
    public PsiDirectory createDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            PsiJavaDirectoryFactory.$$$reportNull$$$0(1);
        }
        return new PsiJavaDirectoryImpl(this.myManager, file);
    }

    @NotNull
    public String getQualifiedName(@NotNull PsiDirectory directory, boolean presentable) {
        PsiPackage aPackage;
        if (directory == null) {
            PsiJavaDirectoryFactory.$$$reportNull$$$0(2);
        }
        if ((aPackage = JavaDirectoryService.getInstance().getPackage(directory)) != null) {
            String qualifiedName = aPackage.getQualifiedName();
            if (!qualifiedName.isEmpty()) {
                String string = qualifiedName;
                if (string == null) {
                    PsiJavaDirectoryFactory.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (presentable) {
                String string = JavaBundle.message((String)"default.package.presentable.name", (Object[])new Object[0]) + " (" + directory.getVirtualFile().getPresentableUrl() + ")";
                if (string == null) {
                    PsiJavaDirectoryFactory.$$$reportNull$$$0(4);
                }
                return string;
            }
            return "";
        }
        return presentable ? StringUtil.notNullize((String)FileUtil.getLocationRelativeToUserHome((String)directory.getVirtualFile().getPresentableUrl())) : "";
    }

    @Nullable
    public PsiDirectoryContainer getDirectoryContainer(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PsiJavaDirectoryFactory.$$$reportNull$$$0(5);
        }
        return JavaDirectoryService.getInstance().getPackage(directory);
    }

    public boolean isPackage(@NotNull PsiDirectory directory) {
        VirtualFile virtualFile;
        ProjectFileIndex fileIndex;
        if (directory == null) {
            PsiJavaDirectoryFactory.$$$reportNull$$$0(6);
        }
        return (fileIndex = ProjectRootManager.getInstance((Project)this.myManager.getProject()).getFileIndex()).isUnderSourceRootOfType(virtualFile = directory.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) && fileIndex.getPackageNameByDirectory(virtualFile) != null;
    }

    public boolean isValidPackageName(String name2) {
        return PsiNameHelper.getInstance((Project)this.myManager.getProject()).isQualifiedName(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/PsiJavaDirectoryFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/PsiJavaDirectoryFactory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryContainer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

