/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.javadoc.CommentFormatter;
import com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.annotations.NotNull;

public class FormatCommentsProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        if (element == null) {
            FormatCommentsProcessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            FormatCommentsProcessor.$$$reportNull$$$0(1);
        }
        PsiElement e = SourceTreeToPsiMap.treeElementToPsi((ASTNode)element);
        assert (e != null && e.isValid());
        PsiFile file = e.getContainingFile();
        Project project = e.getProject();
        if (!((JavaCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, JavaCodeStyleSettings.class)).ENABLE_JAVADOC_FORMATTING || element.getPsi().getContainingFile().getLanguage() != JavaLanguage.INSTANCE || InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(element.getPsi().getContainingFile())) {
            TextRange textRange = range;
            if (textRange == null) {
                FormatCommentsProcessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        return FormatCommentsProcessor.formatCommentsInner(project, element, range);
    }

    @NotNull
    private static TextRange formatCommentsInner(@NotNull Project project, @NotNull ASTNode element, @NotNull TextRange markedRange) {
        if (project == null) {
            FormatCommentsProcessor.$$$reportNull$$$0(3);
        }
        if (element == null) {
            FormatCommentsProcessor.$$$reportNull$$$0(4);
        }
        if (markedRange == null) {
            FormatCommentsProcessor.$$$reportNull$$$0(5);
        }
        TextRange resultTextRange = markedRange;
        PsiElement elementPsi = element.getPsi();
        assert (elementPsi.isValid());
        PsiFile file = elementPsi.getContainingFile();
        boolean shouldFormat = markedRange.contains(element.getTextRange());
        if (shouldFormat) {
            ASTNode rangeAnchor = elementPsi instanceof PsiDocComment ? element.getTreeParent() : element;
            TextRange before = rangeAnchor.getTextRange();
            new CommentFormatter(file).processComment(element);
            int deltaRange = rangeAnchor.getTextRange().getLength() - before.getLength();
            resultTextRange = new TextRange(markedRange.getStartOffset(), markedRange.getEndOffset() + deltaRange);
        }
        if (shouldFormat && (elementPsi instanceof PsiMethod || elementPsi instanceof PsiField || elementPsi instanceof PsiDocComment) || markedRange.getEndOffset() < element.getStartOffset()) {
            TextRange textRange = resultTextRange;
            if (textRange == null) {
                FormatCommentsProcessor.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        for (ASTNode current = element.getFirstChildNode(); current != null; current = current.getTreeNext()) {
            if (shouldFormat && current.getPsi() instanceof PsiDocComment && elementPsi instanceof PsiClass) continue;
            resultTextRange = FormatCommentsProcessor.formatCommentsInner(project, current, resultTextRange);
        }
        TextRange textRange = resultTextRange;
        if (textRange == null) {
            FormatCommentsProcessor.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/FormatCommentsProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markedRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/FormatCommentsProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "formatCommentsInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatCommentsInner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

