/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLangClassMemberReference
extends PsiReferenceBase<PsiLiteralExpression>
implements InsertHandler<LookupElement> {
    private final PsiExpression myContext;

    public JavaLangClassMemberReference(@NotNull PsiLiteralExpression literal, @NotNull PsiExpression context) {
        if (literal == null) {
            JavaLangClassMemberReference.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JavaLangClassMemberReference.$$$reportNull$$$0(1);
        }
        super((PsiElement)literal);
        this.myContext = context;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JavaLangClassMemberReference.$$$reportNull$$$0(2);
        }
        return element;
    }

    public PsiElement resolve() {
        Object value2 = ((PsiLiteralExpression)this.myElement).getValue();
        if (value2 instanceof String) {
            JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
            String name2 = (String)value2;
            String type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement);
            if (type2 != null && (ownerClass = this.getOwnerClass()) != null) {
                switch (type2) {
                    case "getField": {
                        return ownerClass.getPsiClass().findFieldByName(name2, true);
                    }
                    case "getDeclaredField": {
                        PsiField field = ownerClass.getPsiClass().findFieldByName(name2, false);
                        return JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)field, ownerClass) ? field : null;
                    }
                    case "getMethod": {
                        Object[] methods = ownerClass.getPsiClass().findMethodsByName(name2, true);
                        if (methods.length > 1 && (methods = ContainerUtil.filter((Object[])methods, method -> JavaReflectionReferenceUtil.isRegularMethod(method) && JavaReflectionReferenceUtil.isPublic((PsiMember)method)).toArray(PsiMethod.EMPTY_ARRAY)).length > 1) {
                            return this.findOverloadedMethod((PsiMethod[])methods);
                        }
                        return methods.length != 0 ? methods[0] : null;
                    }
                    case "getDeclaredMethod": {
                        Object[] methods = ownerClass.getPsiClass().findMethodsByName(name2, false);
                        if (methods.length > 1 && (methods = ContainerUtil.filter((Object[])methods, method -> JavaReflectionReferenceUtil.isRegularMethod(method) && JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)method, ownerClass)).toArray(PsiMethod.EMPTY_ARRAY)).length > 1) {
                            return this.findOverloadedMethod((PsiMethod[])methods);
                        }
                        return methods.length != 0 ? methods[0] : null;
                    }
                    case "newUpdater": {
                        return ownerClass.getPsiClass().findFieldByName(name2, false);
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private JavaReflectionReferenceUtil.ReflectiveClass getOwnerClass() {
        return JavaReflectionReferenceUtil.getReflectiveClass(this.myContext);
    }

    public Object @NotNull [] getVariants() {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        String type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement);
        if (type2 != null && (ownerClass = this.getOwnerClass()) != null) {
            switch (type2) {
                case "getDeclaredField": {
                    Object[] objectArray = Arrays.stream(ownerClass.getPsiClass().getFields()).sorted(Comparator.comparing(PsiField::getName)).map(field -> JavaLookupElementBuilder.forField(field)).toArray();
                    if (objectArray == null) {
                        JavaLangClassMemberReference.$$$reportNull$$$0(3);
                    }
                    return objectArray;
                }
                case "getField": {
                    THashSet uniqueNames = new THashSet();
                    Object[] objectArray = Arrays.stream(ownerClass.getPsiClass().getAllFields()).filter(arg_0 -> JavaLangClassMemberReference.lambda$getVariants$3(ownerClass, (Set)uniqueNames, arg_0)).sorted(Comparator.comparingInt(field -> JavaReflectionReferenceUtil.isPublic((PsiMember)field) ? 0 : 1).thenComparing(PsiField::getName)).map(field -> JavaReflectionReferenceUtil.withPriority((LookupElement)JavaLookupElementBuilder.forField(field), JavaReflectionReferenceUtil.isPublic((PsiMember)field))).toArray();
                    if (objectArray == null) {
                        JavaLangClassMemberReference.$$$reportNull$$$0(4);
                    }
                    return objectArray;
                }
                case "getDeclaredMethod": {
                    Object[] objectArray = Arrays.stream(ownerClass.getPsiClass().getMethods()).filter(method -> JavaReflectionReferenceUtil.isRegularMethod(method)).sorted(Comparator.comparing(PsiMethod::getName)).map(method -> JavaReflectionReferenceUtil.lookupMethod(method, this)).filter(Objects::nonNull).toArray();
                    if (objectArray == null) {
                        JavaLangClassMemberReference.$$$reportNull$$$0(5);
                    }
                    return objectArray;
                }
                case "getMethod": {
                    Object[] objectArray = ownerClass.getPsiClass().getVisibleSignatures().stream().map(MethodSignatureBackedByPsiMethod::getMethod).filter(method -> JavaReflectionReferenceUtil.isRegularMethod(method) && JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)method, ownerClass)).sorted(Comparator.comparingInt(method -> JavaReflectionReferenceUtil.getMethodSortOrder(method)).thenComparing(PsiMethod::getName)).map(method -> JavaReflectionReferenceUtil.withPriority(JavaReflectionReferenceUtil.lookupMethod(method, this), -JavaReflectionReferenceUtil.getMethodSortOrder(method))).filter(Objects::nonNull).toArray();
                    if (objectArray == null) {
                        JavaLangClassMemberReference.$$$reportNull$$$0(6);
                    }
                    return objectArray;
                }
                case "newUpdater": {
                    Object[] objectArray = Arrays.stream(ownerClass.getPsiClass().getFields()).sorted(Comparator.comparingInt(field -> JavaReflectionReferenceUtil.isAtomicallyUpdateable(field) ? 0 : 1).thenComparing(PsiField::getName)).map(field -> JavaReflectionReferenceUtil.withPriority((LookupElement)JavaLookupElementBuilder.forField(field), JavaReflectionReferenceUtil.isAtomicallyUpdateable(field))).toArray();
                    if (objectArray == null) {
                        JavaLangClassMemberReference.$$$reportNull$$$0(7);
                    }
                    return objectArray;
                }
            }
        }
        if (EMPTY_ARRAY == null) {
            JavaLangClassMemberReference.$$$reportNull$$$0(8);
        }
        return EMPTY_ARRAY;
    }

    @Contract(value="null, _ -> false")
    private static boolean isPotentiallyAccessible(PsiMember member, JavaReflectionReferenceUtil.ReflectiveClass psiClass) {
        return member != null && (member.getContainingClass() == psiClass.getPsiClass() || JavaReflectionReferenceUtil.isPublic(member));
    }

    @Nullable
    private PsiElement findOverloadedMethod(PsiMethod[] methods) {
        List<PsiExpression> arguments;
        PsiMethodCallExpression definitionCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiMethodCallExpression.class);
        if (definitionCall != null && (arguments = JavaLangClassMemberReference.getReflectionMethodArguments(definitionCall, 1)) != null) {
            List parameterTypes = ContainerUtil.map(arguments, type2 -> JavaReflectionReferenceUtil.getReflectiveType(type2));
            return JavaLangClassMemberReference.matchMethod(methods, parameterTypes);
        }
        return null;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Object object;
        if (context == null) {
            JavaLangClassMemberReference.$$$reportNull$$$0(9);
        }
        if (item == null) {
            JavaLangClassMemberReference.$$$reportNull$$$0(10);
        }
        if ((object = item.getObject()) instanceof JavaReflectionReferenceUtil.ReflectiveSignature) {
            JavaReflectionReferenceUtil.ReflectiveSignature signature = (JavaReflectionReferenceUtil.ReflectiveSignature)object;
            String text2 = signature.getText(false, false, type2 -> type2 + ".class");
            JavaReflectionReferenceUtil.replaceText(context, text2.isEmpty() ? "" : ", " + text2);
        }
    }

    @Nullable
    public static PsiMethod matchMethod(PsiMethod @NotNull [] methods, @NotNull List<? extends JavaReflectionReferenceUtil.ReflectiveType> argumentTypes) {
        if (argumentTypes == null) {
            JavaLangClassMemberReference.$$$reportNull$$$0(11);
        }
        if (methods == null) {
            JavaLangClassMemberReference.$$$reportNull$$$0(12);
        }
        int mismatchCount = Integer.MAX_VALUE;
        PsiMethod bestGuess = null;
        for (PsiMethod method : methods) {
            int match = JavaLangClassMemberReference.matchMethodArguments(method, argumentTypes);
            if (match == 0) {
                return method;
            }
            if (match < 0 || mismatchCount <= match) continue;
            mismatchCount = match;
            bestGuess = method;
        }
        return bestGuess;
    }

    private static int matchMethodArguments(PsiMethod method, List<? extends JavaReflectionReferenceUtil.ReflectiveType> argumentTypes) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != argumentTypes.size()) {
            return -1;
        }
        int mismatchCount = 0;
        for (int i = 0; i < parameters2.length; ++i) {
            JavaReflectionReferenceUtil.ReflectiveType argumentType = argumentTypes.get(i);
            if (argumentType == null) {
                ++mismatchCount;
                continue;
            }
            if (argumentType.isEqualTo(parameters2[i].getType())) continue;
            return -1;
        }
        return mismatchCount;
    }

    @Nullable
    public static List<PsiExpression> getReflectionMethodArguments(@NotNull PsiMethodCallExpression definitionCall, int argumentOffset) {
        List<PsiExpression> arrayElements;
        PsiExpression[] arguments;
        if (definitionCall == null) {
            JavaLangClassMemberReference.$$$reportNull$$$0(13);
        }
        if ((arguments = definitionCall.getArgumentList().getExpressions()).length == argumentOffset + 1 && (arrayElements = JavaReflectionReferenceUtil.getVarargs(arguments[argumentOffset])) != null) {
            return arrayElements;
        }
        if (arguments.length >= argumentOffset) {
            return Arrays.asList(arguments).subList(argumentOffset, arguments.length);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$getVariants$3(JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Set uniqueNames, PsiField field) {
        return JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)field, ownerClass) && uniqueNames.add(field.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/JavaLangClassMemberReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchMethod";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getReflectionMethodArguments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

