/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.scope.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodsProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiScopesUtil {
    private static final Logger LOG = Logger.getInstance(PsiScopesUtil.class);

    private PsiScopesUtil() {
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor2, @NotNull PsiElement entrance, @Nullable PsiElement maxScope) {
        if (processor2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(0);
        }
        if (entrance == null) {
            PsiScopesUtil.$$$reportNull$$$0(1);
        }
        return PsiScopesUtil.treeWalkUp(processor2, entrance, maxScope, ResolveState.initial());
    }

    public static boolean treeWalkUp(@NotNull PsiScopeProcessor processor2, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState state) {
        String name2;
        if (processor2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(2);
        }
        if (entrance == null) {
            PsiScopesUtil.$$$reportNull$$$0(3);
        }
        if (state == null) {
            PsiScopesUtil.$$$reportNull$$$0(4);
        }
        if (!entrance.isValid()) {
            LOG.error((Throwable)new PsiInvalidElementAccessException(entrance));
        }
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        NameHint hint = (NameHint)processor2.getHint(NameHint.KEY);
        String string = name2 = hint == null ? null : hint.getName(state);
        while (scope != null) {
            ProgressIndicatorProvider.checkCanceled();
            if (scope instanceof PsiClass) {
                processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, (Object)scope);
            }
            if (!scope.processDeclarations(processor2, state, prevParent, entrance)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.EXIT_LEVEL, (Object)scope);
            processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.CHANGE_LEVEL, null);
            scope = scope instanceof PsiClassImpl ? ((PsiClassImpl)scope).getContext(name2) : scope.getContext();
        }
        return true;
    }

    public static boolean walkChildrenScopes(@NotNull PsiElement thisElement, @NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        if (thisElement == null) {
            PsiScopesUtil.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(6);
        }
        if (state == null) {
            PsiScopesUtil.$$$reportNull$$$0(7);
        }
        PsiElement child = null;
        if (lastParent != null && lastParent.getParent() == thisElement && (child = lastParent.getPrevSibling()) == null) {
            return true;
        }
        if (child == null) {
            child = thisElement.getLastChild();
        }
        while (child != null) {
            if (!child.processDeclarations(processor2, state, null, place)) {
                return false;
            }
            child = child.getPrevSibling();
        }
        return true;
    }

    public static void processTypeDeclarations(PsiType type2, PsiElement place, PsiScopeProcessor processor2) {
        if (type2 instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)place);
            PsiClass arrayClass = JavaPsiFacade.getElementFactory((Project)place.getProject()).getArrayClass(languageLevel);
            PsiTypeParameter[] arrayTypeParameters = arrayClass.getTypeParameters();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (arrayTypeParameters.length > 0) {
                substitutor = substitutor.put(arrayTypeParameters[0], ((PsiArrayType)type2).getComponentType());
            }
            arrayClass.processDeclarations(processor2, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor), (PsiElement)arrayClass, place);
        } else if (type2 instanceof PsiIntersectionType) {
            for (PsiType psiType : ((PsiIntersectionType)type2).getConjuncts()) {
                PsiScopesUtil.processTypeDeclarations(psiType, place, processor2);
            }
        } else if (type2 instanceof PsiDisjunctionType) {
            PsiType lub = ((PsiDisjunctionType)type2).getLeastUpperBound();
            PsiScopesUtil.processTypeDeclarations(lub, place, processor2);
        } else if (type2 instanceof PsiCapturedWildcardType) {
            PsiType classType = PsiScopesUtil.convertToTypeParameter((PsiCapturedWildcardType)type2, place);
            if (classType != null) {
                PsiScopesUtil.processTypeDeclarations(classType, place, processor2);
            }
        } else {
            PsiClassType.ClassResolveResult result = PsiUtil.resolveGenericsClassInType((PsiType)type2);
            PsiClass clazz = (PsiClass)result.getElement();
            if (clazz != null) {
                clazz.processDeclarations(processor2, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)result.getSubstitutor()), (PsiElement)clazz, place);
            }
        }
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor2, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope) {
        if (processor2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(8);
        }
        if (ref == null) {
            PsiScopesUtil.$$$reportNull$$$0(9);
        }
        return PsiScopesUtil.resolveAndWalk(processor2, ref, maxScope, false);
    }

    public static boolean resolveAndWalk(@NotNull PsiScopeProcessor processor2, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiElement maxScope, boolean incompleteCode) {
        if (processor2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(10);
        }
        if (ref == null) {
            PsiScopesUtil.$$$reportNull$$$0(11);
        }
        PsiElement qualifier = ref.getQualifier();
        PsiElement classNameElement = ref.getReferenceNameElement();
        if (classNameElement == null) {
            return true;
        }
        if (qualifier != null) {
            PsiElement target = null;
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (qualifier instanceof PsiExpression || qualifier instanceof PsiJavaCodeReferenceElement || qualifier instanceof PsiTypeElement) {
                PsiType type2 = null;
                if (qualifier instanceof PsiExpression) {
                    type2 = ((PsiExpression)qualifier).getType();
                    assert (type2 == null || type2.isValid()) : type2.getClass() + "; " + qualifier;
                    PsiScopesUtil.processTypeDeclarations(type2, (PsiElement)ref, processor2);
                } else if (qualifier instanceof PsiTypeElement) {
                    type2 = ((PsiTypeElement)qualifier).getType();
                    PsiScopesUtil.processTypeDeclarations(type2, (PsiElement)ref, processor2);
                }
                if (type2 == null && qualifier instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)qualifier;
                    JavaResolveResult result = referenceElement.advancedResolve(incompleteCode);
                    target = result.getElement();
                    substitutor = result.getSubstitutor();
                    if (target instanceof PsiVariable) {
                        type2 = substitutor.substitute(((PsiVariable)target).getType());
                        if (type2 instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor = substitutor.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                    } else if (target instanceof PsiMethod) {
                        type2 = substitutor.substitute(((PsiMethod)target).getReturnType());
                        if (type2 instanceof PsiClassType) {
                            PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
                            target = typeResult.getElement();
                            substitutor = substitutor.putAll(typeResult.getSubstitutor());
                        } else {
                            target = null;
                        }
                        PsiType[] types = referenceElement.getTypeParameters();
                        if (target instanceof PsiClass) {
                            substitutor = substitutor.putAll((PsiClass)target, types);
                        }
                    } else if (target instanceof PsiClass) {
                        processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.START_STATIC, null);
                    }
                }
            }
            if (target != null) {
                return target.processDeclarations(processor2, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor), target, (PsiElement)ref);
            }
        } else {
            return PsiScopesUtil.treeWalkUp(processor2, (PsiElement)ref, maxScope);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setupAndRunProcessor(@NotNull MethodsProcessor processor2, @NotNull PsiCallExpression call, boolean dummyImplicitConstructor) throws MethodProcessorSetupFailedException {
        if (processor2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(12);
        }
        if (call == null) {
            PsiScopesUtil.$$$reportNull$$$0(13);
        }
        if (call instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)call;
            PsiReferenceExpression ref = methodCall.getMethodExpression();
            processor2.setArgumentList(methodCall.getArgumentList());
            processor2.obtainTypeArguments((PsiCallExpression)methodCall);
            if (!ref.isQualified() || ref.getReferenceNameElement() instanceof PsiKeyword) {
                PsiElement referenceNameElement2 = ref.getReferenceNameElement();
                if (referenceNameElement2 == null) {
                    return;
                }
                if (referenceNameElement2 instanceof PsiKeyword) {
                    PsiKeyword keyword = (PsiKeyword)referenceNameElement2;
                    if (keyword.getTokenType() == JavaTokenType.THIS_KEYWORD) {
                        PsiClass aClass = JavaResolveUtil.getContextClass((PsiElement)methodCall);
                        if (aClass == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for this expression");
                        }
                        processor2.setIsConstructor(true);
                        processor2.setAccessClass(aClass);
                        aClass.processDeclarations((PsiScopeProcessor)processor2, ResolveState.initial(), null, (PsiElement)call);
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor2, aClass);
                        return;
                    } else if (keyword.getTokenType() == JavaTokenType.SUPER_KEYWORD) {
                        PsiClass aClass = JavaResolveUtil.getContextClass((PsiElement)methodCall);
                        if (aClass == null) {
                            throw new MethodProcessorSetupFailedException("Can't resolve class for super expression");
                        }
                        PsiClass superClass = aClass.getSuperClass();
                        if (superClass == null) return;
                        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
                        PsiClass runSuper = superClass;
                        ArrayList<PsiSubstitutor> contextSubstitutors = new ArrayList<PsiSubstitutor>();
                        do {
                            if (runSuper != null) {
                                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)runSuper, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                                contextSubstitutors.add(superSubstitutor);
                            }
                            if (aClass.hasModifierProperty("static")) break;
                            if ((aClass = JavaResolveUtil.getContextClass((PsiElement)aClass)) == null) continue;
                            runSuper = aClass.getSuperClass();
                        } while (aClass != null);
                        for (int i = contextSubstitutors.size() - 1; i >= 0; --i) {
                            PsiSubstitutor contextSubstitutor = (PsiSubstitutor)contextSubstitutors.get(i);
                            substitutor = substitutor.putAll(contextSubstitutor);
                        }
                        processor2.setIsConstructor(true);
                        processor2.setAccessClass(null);
                        PsiMethod[] constructors = superClass.getConstructors();
                        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor);
                        for (PsiMethod constructor : constructors) {
                            if (processor2.execute((PsiElement)constructor, state)) continue;
                            return;
                        }
                        if (!dummyImplicitConstructor) return;
                        PsiScopesUtil.processDummyConstructor(processor2, superClass);
                        return;
                    } else {
                        LOG.error("Unknown name element " + referenceNameElement2 + " in reference " + ref.getText() + "(" + ref + ")");
                    }
                    return;
                } else if (referenceNameElement2 instanceof PsiIdentifier) {
                    processor2.setIsConstructor(false);
                    processor2.setName(referenceNameElement2.getText());
                    processor2.setAccessClass(null);
                    PsiScopesUtil.resolveAndWalk(processor2, (PsiJavaCodeReferenceElement)ref, null);
                    return;
                } else {
                    LOG.error("Unknown name element " + referenceNameElement2 + " in reference " + ref.getText() + "(" + ref + ")");
                }
                return;
            } else {
                PsiElement referenceName = methodCall.getMethodExpression().getReferenceNameElement();
                PsiManager manager = call.getManager();
                PsiElement qualifier = ref.getQualifier();
                if (referenceName == null) {
                    throw new MethodProcessorSetupFailedException("Can't resolve method name for this expression");
                }
                if (referenceName instanceof PsiIdentifier && qualifier instanceof PsiExpression) {
                    PsiEnumConstantInitializer initializingClass2;
                    PsiElement resolve2;
                    PsiType type2 = ((PsiExpression)qualifier).getType();
                    if (type2 != null && qualifier instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiEnumConstant && (initializingClass2 = ((PsiEnumConstant)resolve2).getInitializingClass()) != null && PsiScopesUtil.getOverridingMethod((PsiAnonymousClass)initializingClass2, methodCall.getMethodExpression().getReferenceName()) != null) {
                        PsiScopesUtil.processQualifierResult((JavaResolveResult)new ClassCandidateInfo((PsiElement)initializingClass2, PsiSubstitutor.EMPTY), processor2, methodCall);
                        return;
                    }
                    if (type2 == null) {
                        if (!(qualifier instanceof PsiJavaCodeReferenceElement)) throw new MethodProcessorSetupFailedException("Cant determine qualifier type!");
                        JavaResolveResult result = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(false);
                        if (!(result.getElement() instanceof PsiClass)) return;
                        processor2.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.START_STATIC, null);
                        PsiScopesUtil.processQualifierResult(result, processor2, methodCall);
                        return;
                    } else if (type2 instanceof PsiDisjunctionType) {
                        PsiScopesUtil.processQualifierType(((PsiDisjunctionType)type2).getLeastUpperBound(), processor2, manager, methodCall);
                        return;
                    } else if (type2 instanceof PsiCapturedWildcardType) {
                        PsiType psiType = PsiScopesUtil.convertToTypeParameter((PsiCapturedWildcardType)type2, (PsiElement)methodCall);
                        if (psiType == null) return;
                        PsiScopesUtil.processQualifierType(psiType, processor2, manager, methodCall);
                        return;
                    } else {
                        PsiScopesUtil.processQualifierType(type2, processor2, manager, methodCall);
                    }
                    return;
                } else {
                    LOG.error("ref: " + ref + " (" + ref.getClass() + "), ref.getReferenceNameElement()=" + ref.getReferenceNameElement() + "; methodCall.getMethodExpression().getReferenceNameElement()=" + methodCall.getMethodExpression().getReferenceNameElement() + "; qualifier=" + qualifier);
                }
            }
            return;
        } else {
            LOG.assertTrue(call instanceof PsiNewExpression);
            PsiNewExpression newExpr = (PsiNewExpression)call;
            PsiJavaCodeReferenceElement classRef = newExpr.getClassOrAnonymousClassReference();
            if (classRef == null) {
                throw new MethodProcessorSetupFailedException("Cant get reference to class in new expression");
            }
            JavaResolveResult result = classRef.advancedResolve(false);
            PsiClass aClass = (PsiClass)result.getElement();
            if (aClass == null) {
                throw new MethodProcessorSetupFailedException("Cant resolve class in new expression");
            }
            processor2.setIsConstructor(true);
            processor2.setAccessClass(aClass);
            processor2.setArgumentList(newExpr.getArgumentList());
            processor2.obtainTypeArguments((PsiCallExpression)newExpr);
            aClass.processDeclarations((PsiScopeProcessor)processor2, ResolveState.initial().put(PsiSubstitutor.KEY, (Object)result.getSubstitutor()), null, (PsiElement)call);
            if (!dummyImplicitConstructor) return;
            PsiScopesUtil.processDummyConstructor(processor2, aClass);
        }
    }

    private static PsiType convertToTypeParameter(PsiCapturedWildcardType type2, PsiElement methodCall) {
        GlobalSearchScope placeResolveScope = methodCall.getResolveScope();
        PsiType upperBound = PsiClassImplUtil.correctType(type2.getUpperBound(), placeResolveScope);
        while (upperBound instanceof PsiCapturedWildcardType) {
            upperBound = PsiClassImplUtil.correctType(((PsiCapturedWildcardType)upperBound).getUpperBound(), placeResolveScope);
        }
        if (upperBound instanceof PsiArrayType) {
            return upperBound;
        }
        if (upperBound != null) {
            return InferenceSession.createTypeParameterTypeWithUpperBound(upperBound, methodCall);
        }
        return null;
    }

    public static PsiMethod getOverridingMethod(PsiAnonymousClass anonymousClass, String name2) {
        PsiClass baseClass;
        PsiMethod[] refMethods = anonymousClass.findMethodsByName(name2, false);
        if (refMethods.length > 0 && (baseClass = PsiUtil.resolveClassInType((PsiType)anonymousClass.getBaseClassType())) != null && !PsiScopesUtil.hasCovariantOverridingOrNotPublic(baseClass, refMethods)) {
            for (PsiMethod method : refMethods) {
                if (method.findSuperMethods(baseClass).length <= 0) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean hasCovariantOverridingOrNotPublic(PsiClass baseClass, PsiMethod[] refMethods) {
        for (PsiMethod method : refMethods) {
            PsiType methodReturnType = method.getReturnType();
            for (PsiMethod superMethod : method.findSuperMethods(baseClass)) {
                if (!Comparing.equal((Object)methodReturnType, (Object)superMethod.getReturnType())) {
                    return true;
                }
                if (superMethod.hasModifierProperty("public")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean processQualifierType(@NotNull PsiType type2, MethodsProcessor processor2, PsiManager manager, PsiMethodCallExpression call) throws MethodProcessorSetupFailedException {
        if (type2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(14);
        }
        PsiUtil.ensureValidType((PsiType)type2);
        if (type2 instanceof PsiClassType) {
            PsiClassType.ClassResolveResult qualifierResult = ((PsiClassType)type2).resolveGenerics();
            return PsiScopesUtil.processQualifierResult((JavaResolveResult)qualifierResult, processor2, call);
        }
        if (type2 instanceof PsiArrayType) {
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)call);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
            PsiClassType.ClassResolveResult qualifierResult = factory.getArrayClassType(((PsiArrayType)type2).getComponentType(), languageLevel).resolveGenerics();
            return PsiScopesUtil.processQualifierResult((JavaResolveResult)qualifierResult, processor2, call);
        }
        if (type2 instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)type2).getConjuncts()) {
                if (PsiScopesUtil.processQualifierType(conjunct, processor2, manager, call)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processQualifierResult(@NotNull JavaResolveResult qualifierResult, @NotNull MethodsProcessor processor2, @NotNull PsiMethodCallExpression methodCall) throws MethodProcessorSetupFailedException {
        PsiElement resolve2;
        if (qualifierResult == null) {
            PsiScopesUtil.$$$reportNull$$$0(15);
        }
        if (processor2 == null) {
            PsiScopesUtil.$$$reportNull$$$0(16);
        }
        if (methodCall == null) {
            PsiScopesUtil.$$$reportNull$$$0(17);
        }
        if ((resolve2 = qualifierResult.getElement()) == null) {
            throw new MethodProcessorSetupFailedException("Cant determine qualifier class!");
        }
        if (resolve2 instanceof PsiTypeParameter) {
            processor2.setAccessClass((PsiClass)resolve2);
        } else if (resolve2 instanceof PsiClass) {
            PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
            if (!(qualifier instanceof PsiSuperExpression)) {
                processor2.setAccessClass((PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement());
            } else if (((PsiSuperExpression)qualifier).getQualifier() != null && PsiUtil.isLanguageLevel8OrHigher((PsiElement)qualifier) && "java.lang.Cloneable".equals(((PsiClass)resolve2).getQualifiedName()) && ((PsiClass)resolve2).isInterface()) {
                processor2.setAccessClass((PsiClass)resolve2);
            }
        }
        processor2.setIsConstructor(false);
        processor2.setName(methodCall.getMethodExpression().getReferenceName());
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)qualifierResult.getSubstitutor());
        return resolve2.processDeclarations((PsiScopeProcessor)processor2, state, (PsiElement)methodCall, (PsiElement)methodCall);
    }

    private static void processDummyConstructor(MethodsProcessor processor2, PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return;
        }
        try {
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length != 0) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
            PsiMethod dummyConstructor = factory.createConstructor();
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier != null) {
                Objects.requireNonNull(dummyConstructor.getNameIdentifier()).replace((PsiElement)nameIdentifier);
            }
            processor2.forceAddResult(dummyConstructor);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrance";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisElement";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierResult";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/scope/util/PsiScopesUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "treeWalkUp";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "walkChildrenScopes";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveAndWalk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "setupAndRunProcessor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processQualifierType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "processQualifierResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

