/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class BackpointerUsageVisitor
extends JavaRecursiveElementWalkingVisitor {
    private PsiMember myCause;
    private final List<? extends PsiField> myFields;
    private final List<? extends PsiClass> myInnerClasses;
    private final List<? extends PsiMethod> myMethods;
    private final PsiClass mySourceClass;
    private final boolean myCheckThisExpression;

    BackpointerUsageVisitor(List<? extends PsiField> fields, List<? extends PsiClass> innerClasses, List<? extends PsiMethod> methods, PsiClass sourceClass) {
        this(fields, innerClasses, methods, sourceClass, true);
    }

    BackpointerUsageVisitor(List<? extends PsiField> fields, List<? extends PsiClass> innerClasses, List<? extends PsiMethod> methods, PsiClass sourceClass, boolean checkThisExpression) {
        this.myFields = fields;
        this.myInnerClasses = innerClasses;
        this.myMethods = methods;
        this.mySourceClass = sourceClass;
        this.myCheckThisExpression = checkThisExpression;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            BackpointerUsageVisitor.$$$reportNull$$$0(0);
        }
        if (this.myCause != null) {
            return;
        }
        super.visitElement(element);
    }

    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        if (this.myCause != null) {
            return;
        }
        super.visitReferenceExpression(expression2);
        PsiExpression qualifier = expression2.getQualifierExpression();
        PsiElement referent = expression2.resolve();
        if (!(referent instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)referent;
        if (this.myFields.contains(field) || this.myInnerClasses.contains(field.getContainingClass())) {
            return;
        }
        if (field.hasModifierProperty("static")) {
            return;
        }
        if (qualifier == null || this.myCheckThisExpression && (qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression)) {
            this.myCause = field;
        }
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        if (this.myCause != null) {
            return;
        }
        super.visitMethodCallExpression(expression2);
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiMethod method = expression2.resolveMethod();
        if (method == null) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        if (this.myMethods.contains(method) || this.myInnerClasses.contains(containingClass)) {
            return;
        }
        if (method.hasModifierProperty("static")) {
            return;
        }
        if (!containingClass.equals(this.mySourceClass)) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null || this.myCheckThisExpression && (qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression)) {
            this.myCause = method;
        }
    }

    public boolean isBackpointerRequired() {
        return this.myCause != null;
    }

    public PsiMember getCause() {
        return this.myCause;
    }

    public boolean backpointerRequired() {
        for (PsiMethod psiMethod : this.myMethods) {
            psiMethod.accept((PsiElementVisitor)this);
            if (this.myCause == null) continue;
            return true;
        }
        for (PsiField psiField : this.myFields) {
            psiField.accept((PsiElementVisitor)this);
            if (this.myCause == null) continue;
            return true;
        }
        for (PsiClass psiClass : this.myInnerClasses) {
            psiClass.accept((PsiElementVisitor)this);
            if (this.myCause == null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/extractclass/BackpointerUsageVisitor", "visitElement"));
    }
}

