/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.EmptyInstruction;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.inline.InlineMethodHelper;
import com.intellij.refactoring.inline.InlineMethodSpecialization;
import com.intellij.refactoring.inline.InlineTransformer;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.rename.RenameJavaMemberProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(InlineMethodProcessor.class);
    private PsiMethod myMethod;
    private PsiJavaCodeReferenceElement myReference;
    private final Editor myEditor;
    private final boolean myInlineThisOnly;
    private final boolean mySearchInComments;
    private final boolean mySearchForTextOccurrences;
    private final boolean myDeleteTheDeclaration;
    private final Function<PsiReference, InlineTransformer> myTransformerChooser;
    private final PsiManager myManager;
    private final PsiElementFactory myFactory;
    private final CodeStyleManager myCodeStyleManager;
    private final JavaCodeStyleManager myJavaCodeStyle;
    private PsiCodeBlock[] myAddedBraces;
    private final String myDescriptiveName;
    private Map<PsiField, PsiClassInitializer> myAddedClassInitializers;
    private PsiMethod myMethodCopy;
    private Map<Language, InlineHandler.Inliner> myInliners;
    private static final Key<String> MARK_KEY = Key.create((String)"");

    public InlineMethodProcessor(@NotNull Project project, @NotNull PsiMethod method, @Nullable PsiJavaCodeReferenceElement reference, Editor editor, boolean isInlineThisOnly) {
        if (project == null) {
            InlineMethodProcessor.$$$reportNull$$$0(0);
        }
        if (method == null) {
            InlineMethodProcessor.$$$reportNull$$$0(1);
        }
        this(project, method, reference, editor, isInlineThisOnly, false, false, true);
    }

    public InlineMethodProcessor(@NotNull Project project, @NotNull PsiMethod method, @Nullable PsiJavaCodeReferenceElement reference, Editor editor, boolean isInlineThisOnly, boolean searchInComments, boolean searchForTextOccurrences) {
        if (project == null) {
            InlineMethodProcessor.$$$reportNull$$$0(2);
        }
        if (method == null) {
            InlineMethodProcessor.$$$reportNull$$$0(3);
        }
        this(project, method, reference, editor, isInlineThisOnly, searchInComments, searchForTextOccurrences, true);
    }

    public InlineMethodProcessor(@NotNull Project project, @NotNull PsiMethod method, @Nullable PsiJavaCodeReferenceElement reference, Editor editor, boolean isInlineThisOnly, boolean searchInComments, boolean searchForTextOccurrences, boolean isDeleteTheDeclaration) {
        if (project == null) {
            InlineMethodProcessor.$$$reportNull$$$0(4);
        }
        if (method == null) {
            InlineMethodProcessor.$$$reportNull$$$0(5);
        }
        super(project);
        this.myMethod = InlineMethodSpecialization.specialize(method, (PsiReference)reference);
        this.myTransformerChooser = InlineTransformer.getSuitableTransformer(this.myMethod);
        this.myReference = reference;
        this.myEditor = editor;
        this.myInlineThisOnly = isInlineThisOnly;
        this.mySearchInComments = searchInComments;
        this.mySearchForTextOccurrences = searchForTextOccurrences;
        this.myDeleteTheDeclaration = isDeleteTheDeclaration;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
        this.myCodeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        this.myJavaCodeStyle = JavaCodeStyleManager.getInstance((Project)this.myProject);
        this.myDescriptiveName = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myMethod);
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"inline.method.command", (Object[])new Object[]{this.myDescriptiveName});
        if (string == null) {
            InlineMethodProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineMethodProcessor.$$$reportNull$$$0(7);
        }
        return new InlineViewDescriptor((PsiElement)this.myMethod);
    }

    protected UsageInfo @NotNull [] findUsages() {
        if (this.myInlineThisOnly) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo((PsiQualifiedReferenceElement)this.myReference)};
            if (usageInfoArray == null) {
                InlineMethodProcessor.$$$reportNull$$$0(8);
            }
            return usageInfoArray;
        }
        HashSet<UsageInfo> usages = new HashSet<UsageInfo>();
        if (this.myReference != null) {
            usages.add(new UsageInfo((PsiQualifiedReferenceElement)this.myReference));
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myMethod, (SearchScope)this.myRefactoringScope)) {
            usages.add(new UsageInfo(reference.getElement()));
        }
        OverridingMethodsSearch.search((PsiMethod)this.myMethod, (SearchScope)this.myRefactoringScope, (boolean)false).forEach(method -> {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)Override.class.getName(), (int)0)) {
                usages.add(new UsageInfo((PsiElement)method));
            }
            return true;
        });
        if (this.mySearchInComments || this.mySearchForTextOccurrences) {
            String stringToSearch;
            NonCodeUsageInfoFactory infoFactory = new NonCodeUsageInfoFactory((PsiElement)this.myMethod, this.myMethod.getName()){

                public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                    if (usage == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)InlineMethodProcessor.this.myMethod, (PsiElement)usage, (boolean)false)) {
                        return null;
                    }
                    return super.createUsageInfo(usage, startOffset, endOffset);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/inline/InlineMethodProcessor$1", "createUsageInfo"));
                }
            };
            if (this.mySearchInComments) {
                stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)this.myMethod, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.STRINGS_AND_COMMENTS);
                TextOccurrencesUtil.addUsagesInStringsAndComments((PsiElement)this.myMethod, (SearchScope)this.myRefactoringScope, (String)stringToSearch, usages, (UsageInfoFactory)infoFactory);
            }
            if (this.mySearchForTextOccurrences && this.myRefactoringScope instanceof GlobalSearchScope) {
                stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)this.myMethod, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA);
                TextOccurrencesUtil.addTextOccurrences((PsiElement)this.myMethod, (String)stringToSearch, (GlobalSearchScope)((GlobalSearchScope)this.myRefactoringScope), usages, (UsageInfoFactory)infoFactory);
            }
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            InlineMethodProcessor.$$$reportNull$$$0(9);
        }
        return usageInfoArray;
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineMethodProcessor.$$$reportNull$$$0(10);
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            InlineMethodProcessor.$$$reportNull$$$0(11);
        }
        boolean condition2 = elements.length == 1 && elements[0] instanceof PsiMethod;
        LOG.assertTrue(condition2);
        this.myMethod = (PsiMethod)elements[0];
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            InlineMethodProcessor.$$$reportNull$$$0(12);
        }
        if (!this.myInlineThisOnly && this.checkReadOnly() && !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)this.myMethod)) {
            return false;
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        if (!this.myInlineThisOnly) {
            PsiMethod[] superMethods;
            for (PsiMethod psiMethod : superMethods = this.myMethod.findSuperMethods()) {
                String className2 = Objects.requireNonNull(psiMethod.getContainingClass()).getQualifiedName();
                String message2 = psiMethod.hasModifierProperty("abstract") ? JavaRefactoringBundle.message((String)"inlined.method.implements.method.from.0", (Object[])new Object[]{className2}) : JavaRefactoringBundle.message((String)"inlined.method.overrides.method.from.0", (Object[])new Object[]{className2});
                conflicts.putValue((Object)psiMethod, (Object)message2);
            }
            for (PsiMethod psiMethod : usagesIn) {
                String errorMessage;
                PsiExpression qualifierExpression2;
                PsiElement element = psiMethod.getElement();
                if (element instanceof PsiDocMethodOrFieldRef && !PsiTreeUtil.isAncestor((PsiElement)this.myMethod, (PsiElement)element, (boolean)false)) {
                    conflicts.putValue((Object)element, (Object)"Inlined method is used in javadoc");
                }
                if (element instanceof PsiLiteralExpression) {
                    if (Stream.of(element.getReferences()).anyMatch(JavaLangClassMemberReference.class::isInstance)) {
                        conflicts.putValue((Object)element, (Object)"Inlined method is used reflectively");
                    }
                }
                if (element instanceof PsiMethodReferenceExpression && (qualifierExpression2 = ((PsiMethodReferenceExpression)element).getQualifierExpression()) != null) {
                    ArrayList sideEffects = new ArrayList();
                    SideEffectChecker.checkSideEffects(qualifierExpression2, sideEffects);
                    if (!sideEffects.isEmpty()) {
                        conflicts.putValue((Object)element, (Object)"Inlined method is used in method reference with side effects in qualifier");
                    }
                }
                if (element instanceof PsiReferenceExpression && this.myTransformerChooser.apply((PsiReference)element).isFallBackTransformer()) {
                    conflicts.putValue((Object)element, (Object)JavaRefactoringBundle.message((String)"inlined.method.will.be.transformed.to.single.return.form", (Object[])new Object[0]));
                }
                if ((errorMessage = InlineMethodProcessor.checkUnableToInsertCodeBlock(this.myMethod.getBody(), element)) == null) continue;
                conflicts.putValue((Object)element, (Object)errorMessage);
            }
        } else if (this.myReference != null && this.myTransformerChooser.apply((PsiReference)this.myReference).isFallBackTransformer()) {
            conflicts.putValue((Object)this.myReference, (Object)JavaRefactoringBundle.message((String)"inlined.method.will.be.transformed.to.single.return.form", (Object[])new Object[0]));
        }
        this.myInliners = GenericInlineHandler.initInliners((PsiElement)this.myMethod, (UsageInfo[])usagesIn, (InlineHandler.Settings)new InlineHandler.Settings(){

            public boolean isOnlyOneReferenceToInline() {
                return InlineMethodProcessor.this.myInlineThisOnly;
            }
        }, (MultiMap)conflicts, (Language[])new Language[]{JavaLanguage.INSTANCE});
        InlineMethodProcessor.addInaccessibleMemberConflicts((PsiElement)this.myMethod, usagesIn, new ReferencedElementsCollector(), (MultiMap<PsiElement, String>)conflicts);
        this.addInaccessibleSuperCallsConflicts(usagesIn, (MultiMap<PsiElement, String>)conflicts);
        return this.showConflicts(conflicts, usagesIn);
    }

    private boolean checkReadOnly() {
        return this.myMethod.isWritable() || this.myMethod instanceof PsiCompiledElement;
    }

    private void addInaccessibleSuperCallsConflicts(final UsageInfo[] usagesIn, final MultiMap<PsiElement, String> conflicts) {
        this.myMethod.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
            }

            public void visitAnonymousClass(PsiAnonymousClass aClass) {
            }

            public void visitSuperExpression(PsiSuperExpression expression2) {
                super.visitSuperExpression(expression2);
                PsiType type2 = expression2.getType();
                PsiClass superClass = PsiUtil.resolveClassInType((PsiType)type2);
                if (superClass != null) {
                    HashSet<PsiClass> targetContainingClasses = new HashSet<PsiClass>();
                    PsiExpression qualifiedCall = null;
                    for (UsageInfo info : usagesIn) {
                        PsiElement element = info.getElement();
                        if (element == null) continue;
                        PsiClass targetContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                        if (!(targetContainingClass == null || InheritanceUtil.isInheritorOrSelf((PsiClass)targetContainingClass, (PsiClass)superClass, (boolean)true) && PsiUtil.getEnclosingStaticElement((PsiElement)element, (PsiClass)targetContainingClass) == null)) {
                            targetContainingClasses.add(targetContainingClass);
                            continue;
                        }
                        if (!(element instanceof PsiReferenceExpression) || ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)element)) continue;
                        qualifiedCall = ((PsiReferenceExpression)element).getQualifierExpression();
                    }
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethodCallExpression.class);
                    LOG.assertTrue(methodCallExpression != null);
                    if (!targetContainingClasses.isEmpty()) {
                        conflicts.putValue((Object)expression2, (Object)("Inlined method calls " + methodCallExpression.getText() + " which won't be accessed in " + StringUtil.join(targetContainingClasses, psiClass -> RefactoringUIUtil.getDescription((PsiElement)psiClass, (boolean)false), (String)",")));
                    }
                    if (qualifiedCall != null) {
                        conflicts.putValue((Object)expression2, (Object)("Inlined method calls " + methodCallExpression.getText() + " which won't be accessible on qualifier " + qualifiedCall.getText()));
                    }
                }
            }
        });
    }

    public static void addInaccessibleMemberConflicts(PsiElement element, UsageInfo[] usages, ReferencedElementsCollector collector, MultiMap<PsiElement, String> conflicts) {
        element.accept((PsiElementVisitor)collector);
        Map<PsiMember, Set<PsiMember>> containersToReferenced = InlineMethodProcessor.getInaccessible(collector.myReferencedMembers, usages, element);
        containersToReferenced.forEach((container, referencedInaccessible) -> {
            for (PsiMember referenced : referencedInaccessible) {
                String referencedDescription = RefactoringUIUtil.getDescription((PsiElement)referenced, (boolean)true);
                String containerDescription = RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true);
                String message2 = RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{referencedDescription, containerDescription});
                conflicts.putValue(container, (Object)CommonRefactoringUtil.capitalize((String)message2));
            }
        });
    }

    static Map<PsiMember, Set<PsiMember>> getInaccessible(HashSet<? extends PsiMember> referencedElements, UsageInfo[] usages, PsiElement elementToInline) {
        HashMap<PsiMember, Set<PsiMember>> result = new HashMap<PsiMember, Set<PsiMember>>();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)elementToInline.getProject()).getResolveHelper();
        for (UsageInfo usage : usages) {
            PsiMember memberContainer;
            HashSet<PsiMember> inaccessibleReferenced;
            PsiElement container;
            PsiElement usageElement = usage.getElement();
            if (usageElement == null || !((container = ConflictsUtil.getContainer(usageElement)) instanceof PsiMember) || (inaccessibleReferenced = (HashSet<PsiMember>)result.get(memberContainer = (PsiMember)container)) != null) continue;
            inaccessibleReferenced = new HashSet<PsiMember>();
            result.put(memberContainer, inaccessibleReferenced);
            for (PsiMember psiMember : referencedElements) {
                PsiElement resolveScope;
                if (PsiTreeUtil.isAncestor((PsiElement)elementToInline, (PsiElement)psiMember, (boolean)false) || elementToInline instanceof PsiClass && InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)elementToInline), (PsiClass)psiMember.getContainingClass(), (boolean)true)) continue;
                PsiElement psiElement = resolveScope = usageElement instanceof PsiReferenceExpression ? ((PsiReferenceExpression)usageElement).advancedResolve(false).getCurrentFileResolveScope() : null;
                if (resolveHelper.isAccessible(psiMember, psiMember.getModifierList(), usageElement, null, resolveScope)) continue;
                inaccessibleReferenced.add(psiMember);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineMethodProcessor.$$$reportNull$$$0(13);
        }
        RangeMarker position = null;
        if (this.myEditor != null) {
            int offset = this.myEditor.getCaretModel().getOffset();
            position = this.myEditor.getDocument().createRangeMarker(offset, offset + 1);
        }
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            this.doRefactoring(usages);
        }
        finally {
            a.finish();
        }
        if (position != null) {
            if (position.isValid()) {
                this.myEditor.getCaretModel().moveToOffset(position.getStartOffset());
            }
            position.dispose();
        }
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.inline.method";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myMethod);
        return data;
    }

    private void doRefactoring(UsageInfo[] usages) {
        try {
            if (this.myInlineThisOnly) {
                if (this.myMethod.isConstructor() && InlineUtil.isChainingConstructor(this.myMethod)) {
                    if (this.myReference instanceof PsiMethodReferenceExpression) {
                        this.inlineMethodReference((PsiMethodReferenceExpression)this.myReference);
                    } else {
                        PsiCall constructorCall = RefactoringUtil.getEnclosingConstructorCall(this.myReference);
                        if (constructorCall != null) {
                            InlineMethodProcessor.inlineConstructorCall(constructorCall);
                        }
                    }
                } else {
                    this.myReference = this.addBracesWhenNeeded(new PsiReferenceExpression[]{(PsiReferenceExpression)this.myReference})[0];
                    if (this.myReference instanceof PsiMethodReferenceExpression) {
                        this.inlineMethodReference((PsiMethodReferenceExpression)this.myReference);
                    } else {
                        this.inlineMethodCall((PsiReferenceExpression)this.myReference);
                    }
                }
            } else {
                CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
                if (this.myMethod.isConstructor()) {
                    for (UsageInfo usage : usages) {
                        PsiElement element = usage.getElement();
                        if (element instanceof PsiMethodReferenceExpression) {
                            this.inlineMethodReference((PsiMethodReferenceExpression)element);
                            continue;
                        }
                        if (element instanceof PsiJavaCodeReferenceElement) {
                            PsiCall constructorCall = RefactoringUtil.getEnclosingConstructorCall((PsiJavaCodeReferenceElement)element);
                            if (constructorCall == null) continue;
                            InlineMethodProcessor.inlineConstructorCall(constructorCall);
                            continue;
                        }
                        if (element instanceof PsiEnumConstant) {
                            InlineMethodProcessor.inlineConstructorCall((PsiCall)((PsiEnumConstant)element));
                            continue;
                        }
                        if (element instanceof PsiDocMethodOrFieldRef) continue;
                        GenericInlineHandler.inlineReference((UsageInfo)usage, (PsiElement)this.myMethod, this.myInliners);
                    }
                } else {
                    ArrayList<PsiReferenceExpression> refExprList = new ArrayList<PsiReferenceExpression>();
                    ArrayList<PsiElement> imports2Delete = new ArrayList<PsiElement>();
                    for (UsageInfo usage : usages) {
                        PsiElement element = usage.getElement();
                        if (element instanceof PsiReferenceExpression) {
                            refExprList.add((PsiReferenceExpression)element);
                            continue;
                        }
                        if (element instanceof PsiImportStaticReferenceElement) {
                            JavaResolveResult[] resolveResults = ((PsiImportStaticReferenceElement)element).multiResolve(false);
                            if (resolveResults.length >= 2) continue;
                            imports2Delete.add(PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class));
                            continue;
                        }
                        if (element instanceof PsiMethod) {
                            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiMethod)element), (boolean)false, (String[])new String[]{Override.class.getName()});
                            if (annotation == null) continue;
                            annotation.delete();
                            continue;
                        }
                        if (JavaLanguage.INSTANCE == element.getLanguage()) continue;
                        GenericInlineHandler.inlineReference((UsageInfo)usage, (PsiElement)this.myMethod, this.myInliners);
                    }
                    PsiReferenceExpression[] refs = refExprList.toArray(new PsiReferenceExpression[0]);
                    refs = this.addBracesWhenNeeded(refs);
                    for (PsiReferenceExpression ref : refs) {
                        if (ref instanceof PsiMethodReferenceExpression) {
                            this.inlineMethodReference((PsiMethodReferenceExpression)ref);
                            continue;
                        }
                        this.inlineMethodCall(ref);
                    }
                    for (PsiElement psiElement : imports2Delete) {
                        if (psiElement == null || !psiElement.isValid()) continue;
                        psiElement.delete();
                    }
                }
                if (this.myMethod.isValid() && this.myMethod.isWritable() && this.myDeleteTheDeclaration) {
                    this.myMethod.delete();
                }
            }
            this.removeAddedBracesWhenPossible();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void inlineMethodReference(PsiMethodReferenceExpression reference) {
        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda(reference, false, false);
        if (lambdaExpression == null) {
            return;
        }
        PsiExpression callExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambdaExpression.getBody());
        if (callExpression instanceof PsiMethodCallExpression) {
            this.inlineMethodCall(((PsiMethodCallExpression)callExpression).getMethodExpression());
        } else if (callExpression instanceof PsiCall) {
            InlineMethodProcessor.inlineConstructorCall((PsiCall)callExpression);
        } else {
            LOG.error("Unexpected expr: " + callExpression.getText());
        }
        LambdaRefactoringUtil.simplifyToExpressionLambda(lambdaExpression);
        if (this.myInlineThisOnly) {
            LambdaRefactoringUtil.removeSideEffectsFromLambdaBody(this.myEditor, lambdaExpression);
        }
    }

    public static void inlineConstructorCall(PsiCall constructorCall) {
        PsiStatement[] statements;
        PsiParameter[] parameters2;
        PsiType varargType;
        PsiMethod oldConstructor = constructorCall.resolveMethod();
        LOG.assertTrue(oldConstructor != null);
        oldConstructor = (PsiMethod)oldConstructor.getNavigationElement();
        PsiExpression[] instanceCreationArguments = constructorCall.getArgumentList().getExpressions();
        if (oldConstructor.isVarArgs() && (varargType = (parameters2 = oldConstructor.getParameterList().getParameters())[parameters2.length - 1].getType()) instanceof PsiEllipsisType) {
            PsiType arrayType = constructorCall.resolveMethodGenerics().getSubstitutor().substitute(((PsiEllipsisType)varargType).getComponentType());
            PsiExpression[] exprs = new PsiExpression[parameters2.length];
            System.arraycopy(instanceCreationArguments, 0, exprs, 0, parameters2.length - 1);
            StringBuilder varargs = new StringBuilder();
            for (int i = parameters2.length - 1; i < instanceCreationArguments.length; ++i) {
                if (varargs.length() > 0) {
                    varargs.append(", ");
                }
                varargs.append(instanceCreationArguments[i].getText());
            }
            exprs[parameters2.length - 1] = JavaPsiFacade.getElementFactory((Project)constructorCall.getProject()).createExpressionFromText("new " + arrayType.getCanonicalText() + "[]{" + varargs + "}", (PsiElement)constructorCall);
            instanceCreationArguments = exprs;
        }
        LOG.assertTrue((statements = oldConstructor.getBody().getStatements()).length == 1 && statements[0] instanceof PsiExpressionStatement);
        PsiExpression expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
        LOG.assertTrue(expression2 instanceof PsiMethodCallExpression);
        ChangeContextUtil.encodeContextInfo((PsiElement)expression2, true);
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2.copy();
        PsiExpression[] args = methodCall.getArgumentList().getExpressions();
        for (PsiExpression arg : args) {
            InlineMethodProcessor.replaceParameterReferences((PsiElement)arg, oldConstructor, instanceCreationArguments);
        }
        try {
            PsiExpressionList exprList = (PsiExpressionList)constructorCall.getArgumentList().replace((PsiElement)methodCall.getArgumentList());
            ChangeContextUtil.decodeContextInfo((PsiElement)exprList, (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)constructorCall, PsiClass.class), null);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        ChangeContextUtil.clearContextInfo((PsiElement)expression2);
    }

    private static void replaceParameterReferences(PsiElement element, PsiMethod oldConstructor, PsiExpression[] instanceCreationArguments) {
        PsiReferenceExpression expression2;
        PsiElement resolved;
        boolean isParameterReference = false;
        if (element instanceof PsiReferenceExpression && (resolved = (expression2 = (PsiReferenceExpression)element).resolve()) instanceof PsiParameter && element.getManager().areElementsEquivalent(((PsiParameter)resolved).getDeclarationScope(), (PsiElement)oldConstructor)) {
            isParameterReference = true;
            PsiElement declarationScope = ((PsiParameter)resolved).getDeclarationScope();
            PsiParameter[] declarationParameters = ((PsiMethod)declarationScope).getParameterList().getParameters();
            for (int j = 0; j < declarationParameters.length; ++j) {
                if (declarationParameters[j] != resolved) continue;
                try {
                    expression2.replace((PsiElement)instanceCreationArguments[j]);
                    continue;
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        if (!isParameterReference) {
            PsiElement child = element.getFirstChild();
            while (child != null) {
                PsiElement next = child.getNextSibling();
                InlineMethodProcessor.replaceParameterReferences(child, oldConstructor, instanceCreationArguments);
                child = next;
            }
        }
    }

    public void inlineMethodCall(PsiReferenceExpression ref) throws IncorrectOperationException {
        this.myMethodCopy = (PsiMethod)this.myMethod.copy();
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)ref.getParent();
        InlineMethodHelper helper = new InlineMethodHelper(this.myProject, this.myMethod, this.myMethodCopy, (PsiCallExpression)methodCall);
        final BlockData blockData = this.prepareBlock(ref, helper);
        ChangeContextUtil.encodeContextInfo((PsiElement)blockData.block, false);
        InlineUtil.solveVariableNameConflicts((PsiElement)blockData.block, (PsiElement)ref, (PsiElement)this.myMethodCopy.getBody());
        helper.initializeParameters(blockData.parmVars);
        this.addThisInitializer(methodCall, blockData.thisVar);
        PsiElement anchor = RefactoringUtil.getParentStatement((PsiElement)methodCall, true);
        if (anchor == null) {
            PsiExpression returnExpr;
            PsiEnumConstant enumConstant = (PsiEnumConstant)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiEnumConstant.class);
            if (enumConstant != null && (returnExpr = InlineMethodProcessor.getSimpleReturnedExpression(this.myMethod)) != null) {
                ChangeContextUtil.encodeContextInfo((PsiElement)returnExpr, true);
                PsiElement copy = returnExpr.copy();
                ChangeContextUtil.clearContextInfo((PsiElement)returnExpr);
                if (copy instanceof PsiReferenceExpression && ((PsiReferenceExpression)copy).getQualifierExpression() == null) {
                    copy = this.inlineParameterReference((PsiReferenceExpression)copy, blockData);
                } else {
                    copy.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                        public void visitReferenceExpression(PsiReferenceExpression expression2) {
                            super.visitReferenceExpression(expression2);
                            InlineMethodProcessor.this.inlineParameterReference(expression2, blockData);
                        }
                    });
                }
                PsiElement replace = methodCall.replace(copy);
                if (blockData.thisVar != null) {
                    ChangeContextUtil.decodeContextInfo(replace, this.myMethod.getContainingClass(), blockData.thisVar.getInitializer());
                }
            }
            return;
        }
        PsiElement anchorParent = anchor.getParent();
        PsiLocalVariable thisVar = null;
        PsiLocalVariable[] parmVars = new PsiLocalVariable[blockData.parmVars.length];
        PsiLocalVariable resultVar = null;
        PsiStatement[] statements = blockData.block.getStatements();
        PsiElement firstBodyElement = blockData.block.getFirstBodyElement();
        if (firstBodyElement instanceof PsiWhiteSpace) {
            firstBodyElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)firstBodyElement);
        }
        PsiElement firstAdded = null;
        if (firstBodyElement != null && firstBodyElement != blockData.block.getRBrace()) {
            int last = statements.length - 1;
            PsiElement rBraceOrReturnStatement = last >= 0 ? PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statements[last]) : blockData.block.getLastBodyElement();
            LOG.assertTrue(rBraceOrReturnStatement != null);
            PsiElement beforeRBraceStatement = rBraceOrReturnStatement.getPrevSibling();
            LOG.assertTrue(beforeRBraceStatement != null);
            block0: for (PsiElement e = firstAdded = anchorParent.addRangeBefore(firstBodyElement, beforeRBraceStatement, anchor); e != anchor; e = e.getNextSibling()) {
                Object[] elements;
                PsiLocalVariable var;
                if (!(e instanceof PsiDeclarationStatement) || (var = (PsiLocalVariable)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])(elements = ((PsiDeclarationStatement)e).getDeclaredElements())), PsiLocalVariable.class)) == null) continue;
                String name2 = var.getName();
                if (blockData.resultVar != null && name2.equals(blockData.resultVar.getName())) {
                    resultVar = var;
                    continue;
                }
                if (blockData.thisVar != null && name2.equals(blockData.thisVar.getName())) {
                    thisVar = var;
                    continue;
                }
                for (int i = 0; i < blockData.parmVars.length; ++i) {
                    if (!name2.equals(blockData.parmVars[i].getName())) continue;
                    parmVars[i] = var;
                    continue block0;
                }
            }
        }
        PsiClass thisClass = this.myMethod.getContainingClass();
        PsiExpression thisAccessExpr = thisVar != null ? (!InlineUtil.canInlineParameterOrThisVariable(thisVar) ? this.myFactory.createExpressionFromText(thisVar.getName(), null) : thisVar.getInitializer()) : null;
        ChangeContextUtil.decodeContextInfo(anchorParent, thisClass, thisAccessExpr);
        PsiReferenceExpression resultUsage = InlineMethodProcessor.replaceCall(this.myFactory, methodCall, firstAdded, blockData.resultVar);
        if (thisVar != null) {
            InlineUtil.tryInlineGeneratedLocal(thisVar, false);
        }
        helper.inlineParameters(parmVars);
        if (resultVar != null && resultUsage != null) {
            InlineUtil.tryInlineResultVariable(resultVar, resultUsage);
        }
        ChangeContextUtil.clearContextInfo(anchorParent);
    }

    @Nullable
    static PsiReferenceExpression replaceCall(@NotNull PsiElementFactory factory, @NotNull PsiMethodCallExpression methodCall, @Nullable PsiElement firstAdded, @Nullable PsiLocalVariable resultVar) {
        if (factory == null) {
            InlineMethodProcessor.$$$reportNull$$$0(14);
        }
        if (methodCall == null) {
            InlineMethodProcessor.$$$reportNull$$$0(15);
        }
        if (resultVar != null) {
            PsiExpression expr2 = factory.createExpressionFromText(resultVar.getName(), null);
            return (PsiReferenceExpression)new CommentTracker().replaceAndRestoreComments((PsiElement)methodCall, (PsiElement)expr2);
        }
        CommentTracker tracker = new CommentTracker();
        PsiElement anchor = RefactoringUtil.getParentStatement((PsiElement)methodCall, true);
        assert (anchor != null);
        if (firstAdded != null) {
            tracker.delete(anchor);
            tracker.insertCommentsBefore(firstAdded);
        } else {
            tracker.deleteAndRestoreComments(anchor);
        }
        return null;
    }

    @NotNull
    private PsiExpression inlineParameterReference(@NotNull PsiReferenceExpression expression2, BlockData blockData) {
        if (expression2 == null) {
            InlineMethodProcessor.$$$reportNull$$$0(16);
        }
        if (expression2.getQualifierExpression() != null) {
            PsiReferenceExpression psiReferenceExpression = expression2;
            if (psiReferenceExpression == null) {
                InlineMethodProcessor.$$$reportNull$$$0(17);
            }
            return psiReferenceExpression;
        }
        PsiElement resolve2 = expression2.resolve();
        if (!(resolve2 instanceof PsiParameter)) {
            PsiReferenceExpression psiReferenceExpression = expression2;
            if (psiReferenceExpression == null) {
                InlineMethodProcessor.$$$reportNull$$$0(18);
            }
            return psiReferenceExpression;
        }
        int paramIdx = ArrayUtil.find((Object[])this.myMethod.getParameterList().getParameters(), (Object)resolve2);
        if (paramIdx < 0) {
            PsiReferenceExpression psiReferenceExpression = expression2;
            if (psiReferenceExpression == null) {
                InlineMethodProcessor.$$$reportNull$$$0(19);
            }
            return psiReferenceExpression;
        }
        PsiExpression initializer = blockData.parmVars[paramIdx].getInitializer();
        if (initializer == null) {
            PsiReferenceExpression psiReferenceExpression = expression2;
            if (psiReferenceExpression == null) {
                InlineMethodProcessor.$$$reportNull$$$0(20);
            }
            return psiReferenceExpression;
        }
        PsiExpression psiExpression = InlineUtil.inlineInitializer((PsiVariable)resolve2, initializer, (PsiJavaCodeReferenceElement)expression2);
        if (psiExpression == null) {
            InlineMethodProcessor.$$$reportNull$$$0(21);
        }
        return psiExpression;
    }

    private void substituteMethodTypeParams(PsiElement scope, PsiSubstitutor substitutor) {
        InlineUtil.substituteTypeParams(scope, substitutor, this.myFactory);
    }

    private boolean syncNeeded(PsiReferenceExpression ref) {
        PsiClass targetContainingClass;
        if (!this.myMethod.hasModifierProperty("synchronized")) {
            return false;
        }
        PsiMethod containingMethod = Util.getContainingMethod((PsiElement)ref);
        if (containingMethod == null) {
            return true;
        }
        if (!containingMethod.hasModifierProperty("synchronized")) {
            return true;
        }
        PsiClass sourceContainingClass = this.myMethod.getContainingClass();
        return !sourceContainingClass.equals(targetContainingClass = containingMethod.getContainingClass());
    }

    private BlockData prepareBlock(PsiReferenceExpression ref, InlineMethodHelper helper) throws IncorrectOperationException {
        PsiCodeBlock block = Objects.requireNonNull(this.myMethodCopy.getBody());
        PsiSubstitutor callSubstitutor = helper.getSubstitutor();
        if (callSubstitutor != PsiSubstitutor.EMPTY) {
            this.substituteMethodTypeParams((PsiElement)block, callSubstitutor);
        }
        PsiStatement[] originalStatements = block.getStatements();
        PsiType returnType = callSubstitutor.substitute(this.myMethod.getReturnType());
        InlineTransformer transformer = this.myTransformerChooser.apply((PsiReference)ref);
        PsiLocalVariable[] parmVars = helper.declareParameters();
        PsiLocalVariable thisVar = this.declareThis(callSubstitutor, block);
        this.addSynchronization(ref, block, originalStatements, thisVar);
        PsiLocalVariable resultVar = transformer.transformBody(this.myMethodCopy, (PsiReference)ref, returnType);
        return new BlockData(block, thisVar, parmVars, resultVar);
    }

    @Nullable
    private PsiLocalVariable declareThis(PsiSubstitutor callSubstitutor, PsiCodeBlock block) {
        PsiClass containingClass = this.myMethod.getContainingClass();
        if (this.myMethod.hasModifierProperty("static") || containingClass == null) {
            return null;
        }
        PsiType thisType = GenericsUtil.getVariableTypeByExpressionType((PsiType)this.myFactory.createType(containingClass, callSubstitutor));
        String[] names2 = this.myJavaCodeStyle.suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, null, (PsiType)thisType).names;
        String thisVarName = names2[0];
        thisVarName = this.myJavaCodeStyle.suggestUniqueVariableName(thisVarName, this.myMethod.getFirstChild(), true);
        PsiExpression initializer = this.myFactory.createExpressionFromText("null", null);
        PsiDeclarationStatement declaration2 = this.myFactory.createVariableDeclarationStatement(thisVarName, thisType, initializer);
        declaration2 = (PsiDeclarationStatement)block.addAfter((PsiElement)declaration2, null);
        return (PsiLocalVariable)declaration2.getDeclaredElements()[0];
    }

    private void addSynchronization(PsiReferenceExpression ref, PsiCodeBlock block, PsiStatement[] originalStatements, PsiLocalVariable thisVar) {
        PsiClass containingClass = this.myMethod.getContainingClass();
        String lockName = null;
        if (thisVar != null) {
            lockName = thisVar.getName();
        } else if (this.myMethod.hasModifierProperty("static") && containingClass != null) {
            lockName = containingClass.getQualifiedName() + ".class";
        }
        if (lockName != null && this.syncNeeded(ref)) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)this.myFactory.createStatementFromText("synchronized(" + lockName + "){}", (PsiElement)block);
            synchronizedStatement = (PsiSynchronizedStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)synchronizedStatement);
            synchronizedStatement = (PsiSynchronizedStatement)block.add((PsiElement)synchronizedStatement);
            PsiCodeBlock synchronizedBody = Objects.requireNonNull(synchronizedStatement.getBody());
            for (PsiStatement originalStatement : originalStatements) {
                synchronizedBody.add((PsiElement)originalStatement);
                originalStatement.delete();
            }
        }
    }

    private void addThisInitializer(PsiMethodCallExpression methodCall, PsiLocalVariable thisVar) throws IncorrectOperationException {
        if (thisVar != null) {
            PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                PsiElement parent = methodCall.getContext();
                while (!(parent instanceof PsiClass) && !(parent instanceof PsiFile)) {
                    assert (parent != null) : methodCall;
                    parent = parent.getContext();
                }
                if (parent instanceof PsiClass) {
                    PsiClass parentClass = (PsiClass)parent;
                    PsiClass containingClass = this.myMethod.getContainingClass();
                    if (containingClass != null && parentClass.isInheritor(containingClass, true)) {
                        String name2 = parentClass.getName();
                        qualifier = this.myFactory.createExpressionFromText(name2 == null ? "this" : name2 + ".this", null);
                    } else if (containingClass != null && parentClass.equals(containingClass)) {
                        qualifier = this.myFactory.createExpressionFromText("this", null);
                    } else if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)parent, (boolean)false)) {
                        String name3 = containingClass.getName();
                        qualifier = name3 != null ? this.myFactory.createExpressionFromText(name3 + ".this", null) : this.myFactory.createExpressionFromText("this", null);
                    } else {
                        do {
                            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)(parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, (boolean)true)), (PsiClass)containingClass, (boolean)true)) continue;
                            String childClassName = parentClass.getName();
                            qualifier = this.myFactory.createExpressionFromText(childClassName != null ? childClassName + ".this" : "this", null);
                            break;
                        } while (parentClass != null);
                    }
                } else {
                    qualifier = this.myFactory.createExpressionFromText("this", null);
                }
            } else if (qualifier instanceof PsiSuperExpression) {
                qualifier = this.myFactory.createExpressionFromText("this", null);
            }
            thisVar.getInitializer().replace((PsiElement)qualifier);
        }
    }

    private PsiReferenceExpression[] addBracesWhenNeeded(PsiReferenceExpression[] refs) throws IncorrectOperationException {
        ArrayList<PsiReferenceExpression> refsVector = new ArrayList<PsiReferenceExpression>();
        ArrayList<PsiCodeBlock> addedBracesVector = new ArrayList<PsiCodeBlock>();
        this.myAddedClassInitializers = new HashMap<PsiField, PsiClassInitializer>();
        for (PsiReferenceExpression ref : refs) {
            if (ref instanceof PsiMethodReferenceExpression) continue;
            ref.putCopyableUserData(MARK_KEY, (Object)"");
        }
        block1: for (PsiReferenceExpression ref : refs) {
            PsiCodeBlock body2;
            if (!ref.isValid()) continue;
            if (ref instanceof PsiMethodReferenceExpression) {
                refsVector.add(ref);
                continue;
            }
            PsiElement parentStatement = RefactoringUtil.getParentStatement((PsiElement)ref, true);
            if (parentStatement != null) {
                PsiElement parent = ref.getParent();
                while (!parent.equals(parentStatement)) {
                    if (parent instanceof PsiExpressionStatement || parent instanceof PsiReturnStatement) {
                        String text2 = "{\n}";
                        PsiBlockStatement blockStatement = (PsiBlockStatement)this.myFactory.createStatementFromText(text2, null);
                        blockStatement = (PsiBlockStatement)this.myCodeStyleManager.reformat((PsiElement)blockStatement);
                        blockStatement.getCodeBlock().add(parent);
                        blockStatement = (PsiBlockStatement)parent.replace((PsiElement)blockStatement);
                        PsiStatement newStatement = blockStatement.getCodeBlock().getStatements()[0];
                        InlineMethodProcessor.addMarkedElements(refsVector, (PsiElement)newStatement);
                        addedBracesVector.add(blockStatement.getCodeBlock());
                        continue block1;
                    }
                    parent = parent.getParent();
                }
                PsiElement lambdaExpr = parentStatement.getParent();
                if (lambdaExpr instanceof PsiLambdaExpression) {
                    PsiStatement statementFromText;
                    PsiLambdaExpression newLambdaExpr = (PsiLambdaExpression)this.myFactory.createExpressionFromText(((PsiLambdaExpression)lambdaExpr).getParameterList().getText() + " -> {\n}", lambdaExpr);
                    if (PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)lambdaExpr)))) {
                        statementFromText = this.myFactory.createStatementFromText("a;", lambdaExpr);
                        ((PsiExpressionStatement)statementFromText).getExpression().replace(parentStatement);
                    } else {
                        statementFromText = this.myFactory.createStatementFromText("return a;", lambdaExpr);
                        ((PsiReturnStatement)statementFromText).getReturnValue().replace(parentStatement);
                    }
                    newLambdaExpr.getBody().add((PsiElement)statementFromText);
                    body2 = (PsiCodeBlock)((PsiLambdaExpression)lambdaExpr.replace((PsiElement)newLambdaExpr)).getBody();
                    PsiStatement newStatement = body2.getStatements()[0];
                    InlineMethodProcessor.addMarkedElements(refsVector, (PsiElement)newStatement);
                    addedBracesVector.add(body2);
                    continue;
                }
            } else {
                PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiField.class);
                if (field != null) {
                    if (field instanceof PsiEnumConstant) {
                        this.inlineEnumConstantParameter(refsVector, ref);
                        continue;
                    }
                    if (this.myAddedClassInitializers.containsKey(field)) continue;
                    field.normalizeDeclaration();
                    PsiExpression initializer = field.getInitializer();
                    LOG.assertTrue(initializer != null);
                    PsiClassInitializer classInitializer = this.myFactory.createClassInitializer();
                    PsiClass containingClass = field.getContainingClass();
                    classInitializer = (PsiClassInitializer)containingClass.addAfter((PsiElement)classInitializer, (PsiElement)field);
                    containingClass.addAfter(CodeEditUtil.createLineFeed((PsiManager)field.getManager()), (PsiElement)field);
                    body2 = classInitializer.getBody();
                    PsiExpressionStatement statement = (PsiExpressionStatement)this.myFactory.createStatementFromText(field.getName() + " = 0;", (PsiElement)body2);
                    statement = (PsiExpressionStatement)body2.add((PsiElement)statement);
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement.getExpression();
                    assignment.getLExpression().replace((PsiElement)RenameJavaMemberProcessor.createMemberReference((PsiMember)field, (PsiElement)assignment));
                    assignment.getRExpression().replace((PsiElement)initializer);
                    InlineMethodProcessor.addMarkedElements(refsVector, (PsiElement)statement);
                    if (field.hasModifierProperty("static")) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)classInitializer, (String)"static", (boolean)true);
                    }
                    this.myAddedClassInitializers.put(field, classInitializer);
                    continue;
                }
            }
            refsVector.add(ref);
        }
        for (PsiReferenceExpression ref : refs) {
            ref.putCopyableUserData(MARK_KEY, null);
        }
        this.myAddedBraces = addedBracesVector.toArray(PsiCodeBlock.EMPTY_ARRAY);
        return refsVector.toArray(new PsiReferenceExpression[0]);
    }

    private void inlineEnumConstantParameter(List<? super PsiReferenceExpression> refsVector, PsiReferenceExpression ref) throws IncorrectOperationException {
        PsiExpression expr2 = InlineMethodProcessor.getSimpleReturnedExpression(this.myMethod);
        if (expr2 != null) {
            refsVector.add((PsiReferenceExpression)ref);
        } else {
            PsiExpressionList args;
            PsiExpression[] argExpressions;
            PsiCall call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiCall.class);
            String text2 = "new Object() { " + this.myMethod.getReturnTypeElement().getText() + " evaluate() { return " + call.getText() + ";}}.evaluate";
            PsiExpression callExpr = JavaPsiFacade.getInstance((Project)this.myProject).getParserFacade().createExpressionFromText(text2, (PsiElement)call);
            PsiReferenceExpression classExpr = (PsiReferenceExpression)ref.replace((PsiElement)callExpr);
            PsiNewExpression newObject = (PsiNewExpression)Objects.requireNonNull(classExpr.getQualifierExpression());
            PsiMethod evaluateMethod = Objects.requireNonNull(newObject.getAnonymousClass()).getMethods()[0];
            PsiExpression retVal = ((PsiReturnStatement)Objects.requireNonNull(evaluateMethod.getBody()).getStatements()[0]).getReturnValue();
            if (retVal instanceof PsiMethodCallExpression) {
                refsVector.add((PsiReferenceExpression)((PsiMethodCallExpression)retVal).getMethodExpression());
            }
            if (classExpr.getParent() instanceof PsiMethodCallExpression && (argExpressions = (args = ((PsiMethodCallExpression)classExpr.getParent()).getArgumentList()).getExpressions()).length > 0) {
                args.deleteChildRange((PsiElement)argExpressions[0], (PsiElement)argExpressions[argExpressions.length - 1]);
            }
        }
    }

    @Nullable
    private static PsiExpression getSimpleReturnedExpression(PsiMethod method) {
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return null;
        }
        PsiStatement[] psiStatements = body2.getStatements();
        if (psiStatements.length != 1) {
            return null;
        }
        PsiStatement statement = psiStatements[0];
        if (!(statement instanceof PsiReturnStatement)) {
            return null;
        }
        return ((PsiReturnStatement)statement).getReturnValue();
    }

    private static void addMarkedElements(final List<? super PsiReferenceExpression> array, PsiElement scope) {
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (element.getCopyableUserData(MARK_KEY) != null) {
                    array.add((PsiReferenceExpression)element);
                    element.putCopyableUserData(MARK_KEY, null);
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/inline/InlineMethodProcessor$5", "visitElement"));
            }
        });
    }

    private void removeAddedBracesWhenPossible() throws IncorrectOperationException {
        if (this.myAddedBraces == null) {
            return;
        }
        for (PsiCodeBlock codeBlock : this.myAddedBraces) {
            PsiStatement[] statements = codeBlock.getStatements();
            if (statements.length != 1) continue;
            PsiElement codeBlockParent = codeBlock.getParent();
            PsiStatement statement = statements[0];
            if (codeBlockParent instanceof PsiLambdaExpression) {
                if (statement instanceof PsiReturnStatement) {
                    PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
                    if (returnValue == null) continue;
                    codeBlock.replace((PsiElement)returnValue);
                    continue;
                }
                if (!(statement instanceof PsiExpressionStatement)) continue;
                codeBlock.replace((PsiElement)((PsiExpressionStatement)statement).getExpression());
                continue;
            }
            if (codeBlockParent instanceof PsiBlockStatement) {
                if (InlineMethodProcessor.ifStatementWithAppendableElseBranch(statement) && codeBlockParent.getParent() instanceof PsiIfStatement && ((PsiIfStatement)codeBlockParent.getParent()).getElseBranch() != null) continue;
                codeBlockParent.replace((PsiElement)statement);
                continue;
            }
            codeBlock.replace((PsiElement)statement);
        }
        this.myAddedClassInitializers.forEach((psiField, classInitializer) -> {
            PsiExpression newInitializer = this.getSimpleFieldInitializer((PsiField)psiField, (PsiClassInitializer)classInitializer);
            PsiExpression fieldInitializer = Objects.requireNonNull(psiField.getInitializer());
            if (newInitializer != null) {
                fieldInitializer.replace((PsiElement)newInitializer);
                classInitializer.delete();
            } else {
                fieldInitializer.delete();
            }
        });
    }

    private static boolean ifStatementWithAppendableElseBranch(PsiStatement statement) {
        if (statement instanceof PsiIfStatement) {
            PsiStatement elseBranch = ((PsiIfStatement)statement).getElseBranch();
            return elseBranch == null || elseBranch instanceof PsiIfStatement;
        }
        return false;
    }

    @Nullable
    private PsiExpression getSimpleFieldInitializer(PsiField field, PsiClassInitializer initializer) {
        PsiStatement[] statements = initializer.getBody().getStatements();
        if (statements.length != 1) {
            return null;
        }
        if (!(statements[0] instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpression expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
        if (!(expression2 instanceof PsiAssignmentExpression)) {
            return null;
        }
        PsiExpression lExpression = ((PsiAssignmentExpression)expression2).getLExpression();
        if (!(lExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement resolved = ((PsiReferenceExpression)lExpression).resolve();
        if (!this.myManager.areElementsEquivalent((PsiElement)field, resolved)) {
            return null;
        }
        return ((PsiAssignmentExpression)expression2).getRExpression();
    }

    @Deprecated
    public static String checkCalledInSuperOrThisExpr(PsiCodeBlock methodBody2, PsiElement element) {
        return InlineMethodProcessor.checkUnableToInsertCodeBlock(methodBody2, element, expr2 -> JavaPsiConstructorUtil.isConstructorCall((PsiElement)expr2) && expr2.getMethodExpression() != element) ? "Inline cannot be applied to multiline method in constructor call" : null;
    }

    public static String checkUnableToInsertCodeBlock(PsiCodeBlock methodBody2, PsiElement element) {
        if (InlineMethodProcessor.checkUnableToInsertCodeBlock(methodBody2, element, expr2 -> JavaPsiConstructorUtil.isConstructorCall((PsiElement)expr2) && expr2.getMethodExpression() != element)) {
            return "Inline cannot be applied to multiline method in constructor call";
        }
        return InlineMethodProcessor.checkUnableToInsertCodeBlock(methodBody2, element, expr2 -> {
            PsiElement parent = expr2.getParent();
            return parent instanceof PsiLoopStatement && PsiUtil.isCondition((PsiElement)expr2, (PsiElement)parent);
        }) ? "Inline cannot be applied to multiline method in loop condition" : null;
    }

    private static boolean checkUnableToInsertCodeBlock(PsiCodeBlock methodBody2, PsiElement element, Predicate<? super PsiMethodCallExpression> errorCondition) {
        PsiStatement[] statements = methodBody2.getStatements();
        if (statements.length > 1 || statements.length == 1 && !(statements[0] instanceof PsiExpressionStatement)) {
            PsiMethodCallExpression expr2 = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            while (expr2 != null) {
                if (errorCondition.test((PsiMethodCallExpression)expr2)) {
                    return true;
                }
                expr2 = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expr2, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            }
        }
        return false;
    }

    public static boolean checkBadReturns(PsiMethod method) {
        PsiReturnStatement[] returns = PsiUtil.findReturnStatements((PsiMethod)method);
        PsiCodeBlock body2 = method.getBody();
        return InlineMethodProcessor.checkBadReturns(returns, body2);
    }

    public static boolean checkBadReturns(PsiReturnStatement[] returns, PsiCodeBlock body2) {
        int offset;
        ControlFlow controlFlow;
        if (returns.length == 0) {
            return false;
        }
        try {
            controlFlow = ControlFlowFactory.getInstance(body2.getProject()).getControlFlow((PsiElement)body2, new LocalsControlFlowPolicy((PsiElement)body2), false);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Control flow:");
            LOG.debug(controlFlow.toString());
        }
        ArrayList<Instruction> instructions = new ArrayList<Instruction>(controlFlow.getInstructions());
        for (PsiReturnStatement aReturn : returns) {
            int endOffset = controlFlow.getEndOffset((PsiElement)aReturn);
            for (offset = controlFlow.getStartOffset((PsiElement)aReturn); offset <= endOffset && !(instructions.get(offset) instanceof GoToInstruction); ++offset) {
            }
            LOG.assertTrue(instructions.get(offset) instanceof GoToInstruction);
            instructions.set(offset, EmptyInstruction.INSTANCE);
        }
        for (PsiReturnStatement aReturn : returns) {
            offset = controlFlow.getEndOffset((PsiElement)aReturn);
            while (offset != instructions.size()) {
                Instruction instruction = (Instruction)instructions.get(offset);
                if (instruction instanceof GoToInstruction) {
                    offset = ((GoToInstruction)instruction).offset;
                    continue;
                }
                if (instruction instanceof ThrowToInstruction) {
                    offset = ((ThrowToInstruction)instruction).offset;
                    continue;
                }
                if (instruction instanceof ConditionalThrowToInstruction) {
                    ++offset;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            InlineMethodProcessor.$$$reportNull$$$0(22);
        }
        if (this.myInlineThisOnly) {
            List<PsiJavaCodeReferenceElement> list = Collections.singletonList(this.myReference);
            if (list == null) {
                InlineMethodProcessor.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (!this.checkReadOnly()) {
            List list = Collections.emptyList();
            if (list == null) {
                InlineMethodProcessor.$$$reportNull$$$0(24);
            }
            return list;
        }
        List<Object> list = this.myReference == null ? Collections.singletonList(this.myMethod) : Arrays.asList(this.myReference, this.myMethod);
        if (list == null) {
            InlineMethodProcessor.$$$reportNull$$$0(25);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineMethodProcessor";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineMethodProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineParameterReference";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceCall";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "inlineParameterReference";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BlockData {
        final PsiCodeBlock block;
        final PsiLocalVariable thisVar;
        final PsiLocalVariable[] parmVars;
        final PsiLocalVariable resultVar;

        BlockData(PsiCodeBlock block, PsiLocalVariable thisVar, PsiLocalVariable[] parmVars, PsiLocalVariable resultVar) {
            this.block = block;
            this.thisVar = thisVar;
            this.parmVars = parmVars;
            this.resultVar = resultVar;
        }
    }
}

