/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class IntroduceEmptyVariableHandler {
    private static final String VARIABLE_NAME = "IntroducedVariable";
    private static final String TYPE_NAME = "Type";

    public void invoke(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiType type2) {
        Project project;
        if (editor == null) {
            IntroduceEmptyVariableHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            IntroduceEmptyVariableHandler.$$$reportNull$$$0(1);
        }
        if (type2 == null) {
            IntroduceEmptyVariableHandler.$$$reportNull$$$0(2);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)(project = file.getProject()), (PsiElement)file)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement at = file.findElementAt(offset);
        PsiElement anchorStatement = RefactoringUtil.getParentStatement(at, false);
        if (anchorStatement == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"invalid.expression.context", (Object[])new Object[0])), (String)RefactoringBundle.message((String)"introduce.variable.title"), (String)"refactoring.introduceVariable");
            return;
        }
        SuggestedNameInfo suggestedNameInfo = IntroduceEmptyVariableHandler.getSuggestedVariableNames(project, type2, at);
        assert (suggestedNameInfo.names.length > 0);
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = editor.getDocument();
            String initialVariableName = suggestedNameInfo.names[0];
            document.insertString(offset, (CharSequence)initialVariableName);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            PsiElement context = anchorStatement.getParent();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            String value2 = PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
            PsiExpression initializer = elementFactory.createExpressionFromText(value2, anchorStatement);
            PsiDeclarationStatement declaration2 = elementFactory.createVariableDeclarationStatement(initialVariableName, type2, initializer, context);
            if (RefactoringUtil.isLoopOrIf(context)) {
                declaration2 = (PsiDeclarationStatement)RefactoringUtil.putStatementInLoopBody((PsiStatement)declaration2, context, anchorStatement);
                context = declaration2.getParent();
            } else {
                declaration2 = (PsiDeclarationStatement)context.addBefore((PsiElement)declaration2, anchorStatement);
            }
            PsiLocalVariable localVariable = (PsiLocalVariable)declaration2.getDeclaredElements()[0];
            PsiTypeElement typeElement = localVariable.getTypeElement();
            PsiReference reference = (PsiReference)ReferencesSearch.search((PsiElement)localVariable, (SearchScope)new LocalSearchScope(context)).findFirst();
            assert (reference != null);
            PsiElement variableReference = reference.getElement();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl(context);
            templateBuilder.replaceElement((PsiElement)typeElement, TYPE_NAME, (Expression)new ConstantNode(typeElement.getText()), true, true);
            templateBuilder.replaceElement((PsiElement)localVariable.getNameIdentifier(), VARIABLE_NAME, (Expression)new ConstantNode(suggestedNameInfo.names[0]).withLookupStrings(suggestedNameInfo.names), true);
            templateBuilder.replaceElement(variableReference, VARIABLE_NAME, (String)null, false);
            templateBuilder.replaceElement((PsiElement)Objects.requireNonNull(localVariable.getInitializer()), "");
            templateBuilder.setEndVariableAfter(variableReference);
            Template template = templateBuilder.buildInlineTemplate();
            editor.getCaretModel().moveToOffset(context.getTextOffset());
            TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        });
    }

    private static SuggestedNameInfo getSuggestedVariableNames(@NotNull Project project, PsiType type2, PsiElement at) {
        if (project == null) {
            IntroduceEmptyVariableHandler.$$$reportNull$$$0(3);
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, type2);
        String[] strings = JavaCompletionUtil.completeVariableNameForRefactoring(codeStyleManager, type2, VariableKind.LOCAL_VARIABLE, nameInfo);
        SuggestedNameInfo.Delegate delegate = new SuggestedNameInfo.Delegate(strings, nameInfo);
        return codeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)delegate, at, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceVariable/IntroduceEmptyVariableHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuggestedVariableNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

