/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AutocreatingMoveDestination
implements MoveDestination {
    @NotNull
    protected final PackageWrapper myPackage;
    protected final PsiManager myManager;
    protected final ProjectFileIndex myFileIndex;

    public AutocreatingMoveDestination(@NotNull PackageWrapper targetPackage) {
        if (targetPackage == null) {
            AutocreatingMoveDestination.$$$reportNull$$$0(0);
        }
        this.myPackage = targetPackage;
        this.myManager = this.myPackage.getManager();
        this.myFileIndex = ProjectRootManager.getInstance((Project)this.myManager.getProject()).getFileIndex();
    }

    @NotNull
    public abstract PackageWrapper getTargetPackage();

    public abstract PsiDirectory getTargetDirectory(PsiDirectory var1) throws IncorrectOperationException;

    public abstract PsiDirectory getTargetDirectory(PsiFile var1) throws IncorrectOperationException;

    @Nullable
    protected String checkCanCreateInSourceRoot(VirtualFile targetSourceRoot) {
        String targetQName = this.myPackage.getQualifiedName();
        String sourceRootPackage = this.myFileIndex.getPackageNameByDirectory(targetSourceRoot);
        if (!RefactoringUtil.canCreateInSourceRoot(sourceRootPackage, targetQName)) {
            return JavaRefactoringBundle.message((String)"source.folder.0.has.package.prefix.1", (Object[])new Object[]{targetSourceRoot.getPresentableUrl(), sourceRootPackage, targetQName});
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPackage", "com/intellij/refactoring/move/moveClassesOrPackages/AutocreatingMoveDestination", "<init>"));
    }
}

