/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.naming.AutomaticGetterSetterRenamerFactory;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomaticGetterSetterRenamer
extends AutomaticRenamer {
    private static final Logger LOG = Logger.getInstance(AutomaticGetterSetterRenamerFactory.class);

    public AutomaticGetterSetterRenamer(PsiElement element, String newName) {
        LinkedHashMap<PsiElement, String> allRenames = new LinkedHashMap<PsiElement, String>();
        AutomaticGetterSetterRenamer.prepareFieldRenaming((PsiField)element, newName, allRenames);
        for (Map.Entry entry : allRenames.entrySet()) {
            this.myElements.add((PsiNamedElement)entry.getKey());
            this.suggestAllNames(((PsiNamedElement)entry.getKey()).getName(), (String)entry.getValue());
        }
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    public boolean allowChangeSuggestedName() {
        return false;
    }

    public @NlsContexts.DialogTitle String getDialogTitle() {
        return JavaRefactoringBundle.message((String)"rename.accessors.title", (Object[])new Object[0]);
    }

    public @NlsContexts.Button String getDialogDescription() {
        return JavaRefactoringBundle.message((String)"rename.accessors.with.the.following.names.to", (Object[])new Object[0]);
    }

    public String entityName() {
        return JavaRefactoringBundle.message((String)"entity.name.accessor", (Object[])new Object[0]);
    }

    private static void prepareFieldRenaming(PsiField field, String newName, Map<PsiElement, String> allRenames) {
        String newGetterName;
        PsiClass aClass = field.getContainingClass();
        Project project = field.getProject();
        JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)project);
        String propertyName = PropertyUtilBase.suggestPropertyName((PsiField)field, (String)field.getName());
        String newPropertyName = PropertyUtilBase.suggestPropertyName((PsiField)field, (String)newName);
        boolean isStatic = field.hasModifierProperty("static");
        PsiMethod[] getters = GetterSetterPrototypeProvider.findGetters(aClass, propertyName, isStatic);
        PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)aClass, (String)propertyName, (boolean)isStatic, (boolean)false);
        boolean shouldRenameSetterParameter = false;
        if (setter != null) {
            shouldRenameSetterParameter = AutomaticGetterSetterRenamer.shouldRenameSetterParameter(manager, propertyName, setter);
        }
        if (getters != null) {
            ArrayList<PsiMethod> validGetters = new ArrayList<PsiMethod>();
            for (PsiMethod getter : getters) {
                newGetterName = GetterSetterPrototypeProvider.suggestNewGetterName(propertyName, newPropertyName, getter);
                String getterId = null;
                if (newGetterName == null) {
                    getterId = getter.getName();
                    newGetterName = PropertyUtilBase.suggestGetterName((String)newPropertyName, (PsiType)field.getType(), (String)getterId);
                }
                if (newGetterName.equals(getterId)) continue;
                boolean valid = true;
                for (PsiMethod method : getter.findDeepestSuperMethods()) {
                    if (!(method instanceof PsiCompiledElement)) continue;
                    valid = false;
                    break;
                }
                if (!valid) continue;
                validGetters.add(getter);
            }
            getters = validGetters.isEmpty() ? null : validGetters.toArray(PsiMethod.EMPTY_ARRAY);
        }
        String newSetterName = "";
        if (setter != null) {
            newSetterName = PropertyUtilBase.suggestSetterName((String)newPropertyName);
            String newSetterParameterName = manager.propertyNameToVariableName(newPropertyName, VariableKind.PARAMETER);
            if (newSetterName.equals(setter.getName())) {
                setter = null;
                newSetterName = null;
                shouldRenameSetterParameter = false;
            } else if (newSetterParameterName.equals(setter.getParameterList().getParameters()[0].getName())) {
                shouldRenameSetterParameter = false;
            } else {
                PsiMethod[] psiMethodArray = setter.findDeepestSuperMethods();
                int n = psiMethodArray.length;
                for (int getter = 0; getter < n; ++getter) {
                    PsiMethod method = psiMethodArray[getter];
                    if (!(method instanceof PsiCompiledElement)) continue;
                    setter = null;
                    shouldRenameSetterParameter = false;
                    break;
                }
            }
        }
        if (getters != null) {
            for (PsiMethod getter : getters) {
                newGetterName = GetterSetterPrototypeProvider.suggestNewGetterName(propertyName, newPropertyName, getter);
                if (newGetterName == null) {
                    newGetterName = PropertyUtilBase.suggestGetterName((String)newPropertyName, (PsiType)field.getType(), (String)getter.getName());
                }
                AutomaticGetterSetterRenamer.addOverriddenAndImplemented(getter, newGetterName, null, propertyName, manager, allRenames);
            }
        }
        if (setter != null) {
            AutomaticGetterSetterRenamer.addOverriddenAndImplemented(setter, newSetterName, shouldRenameSetterParameter ? newPropertyName : null, propertyName, manager, allRenames);
        }
    }

    private static boolean shouldRenameSetterParameter(JavaCodeStyleManager manager, String propertyName, PsiMethod setter) {
        String parameterName = manager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
        PsiParameter setterParameter = setter.getParameterList().getParameters()[0];
        boolean shouldRenameSetterParameter = parameterName.equals(setterParameter.getName());
        return shouldRenameSetterParameter;
    }

    public static void addOverriddenAndImplemented(@NotNull PsiMethod methodPrototype, @NotNull String newName, @Nullable String newPropertyName, @NotNull String oldParameterName, @NotNull JavaCodeStyleManager manager, @NotNull Map<PsiElement, String> allRenames) {
        PsiMethod[] methods;
        if (methodPrototype == null) {
            AutomaticGetterSetterRenamer.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            AutomaticGetterSetterRenamer.$$$reportNull$$$0(1);
        }
        if (oldParameterName == null) {
            AutomaticGetterSetterRenamer.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            AutomaticGetterSetterRenamer.$$$reportNull$$$0(3);
        }
        if (allRenames == null) {
            AutomaticGetterSetterRenamer.$$$reportNull$$$0(4);
        }
        if ((methods = methodPrototype.findDeepestSuperMethods()).length == 0) {
            methods = new PsiMethod[]{methodPrototype};
        }
        for (PsiMethod method : methods) {
            AutomaticGetterSetterRenamer.addGetterOrSetterWithParameter(method, newName, newPropertyName, oldParameterName, manager, allRenames);
            OverridingMethodsSearch.search((PsiMethod)method).forEach(psiMethod -> {
                RenameProcessor.assertNonCompileElement((PsiElement)psiMethod);
                AutomaticGetterSetterRenamer.addGetterOrSetterWithParameter(psiMethod, newName, newPropertyName, oldParameterName, manager, allRenames);
                return true;
            });
        }
    }

    private static void addGetterOrSetterWithParameter(@NotNull PsiMethod methodPrototype, @NotNull String newName, @Nullable String newPropertyName, @NotNull String oldParameterName, @NotNull JavaCodeStyleManager manager, @NotNull Map<PsiElement, String> allRenames) {
        if (methodPrototype == null) {
            AutomaticGetterSetterRenamer.$$$reportNull$$$0(5);
        }
        if (newName == null) {
            AutomaticGetterSetterRenamer.$$$reportNull$$$0(6);
        }
        if (oldParameterName == null) {
            AutomaticGetterSetterRenamer.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            AutomaticGetterSetterRenamer.$$$reportNull$$$0(8);
        }
        if (allRenames == null) {
            AutomaticGetterSetterRenamer.$$$reportNull$$$0(9);
        }
        allRenames.put((PsiElement)methodPrototype, newName);
        if (newPropertyName != null) {
            PsiParameter[] parameters2 = methodPrototype.getParameterList().getParameters();
            LOG.assertTrue(parameters2.length > 0, (Object)methodPrototype.getName());
            PsiParameter parameter2 = parameters2[0];
            if (AutomaticGetterSetterRenamer.shouldRenameSetterParameter(manager, oldParameterName, methodPrototype)) {
                allRenames.put((PsiElement)parameter2, manager.propertyNameToVariableName(newPropertyName, VariableKind.PARAMETER));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodPrototype";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldParameterName";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/naming/AutomaticGetterSetterRenamer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addOverriddenAndImplemented";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addGetterOrSetterWithParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

