/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverridingMethodUsageInfo;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class OverridingMethodsDialog
extends DialogWrapper {
    private final List<? extends UsageInfo> myOverridingMethods;
    private final String[] myMethodText;
    private final boolean[] myChecked;
    private static final int CHECK_COLUMN = 0;
    private JBTable myTable;
    private final UsagePreviewPanel myUsagePreviewPanel;

    OverridingMethodsDialog(Project project, List<? extends UsageInfo> overridingMethods) {
        super(project, true);
        this.myOverridingMethods = overridingMethods;
        this.myChecked = new boolean[this.myOverridingMethods.size()];
        Arrays.fill(this.myChecked, true);
        this.myMethodText = new String[this.myOverridingMethods.size()];
        for (int i = 0; i < this.myMethodText.length; ++i) {
            this.myMethodText[i] = PsiFormatUtil.formatMethod((PsiMethod)((SafeDeleteOverridingMethodUsageInfo)this.myOverridingMethods.get(i)).getOverridingMethod(), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4355, (int)2);
        }
        this.myUsagePreviewPanel = new UsagePreviewPanel(project, new UsageViewPresentation());
        this.setTitle(JavaRefactoringBundle.message((String)"unused.overriding.methods.title", (Object[])new Object[0]));
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.safeDelete.OverridingMethodsDialog";
    }

    public ArrayList<UsageInfo> getSelected() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (int i = 0; i < this.myChecked.length; ++i) {
            if (!this.myChecked[i]) continue;
            result.add(this.myOverridingMethods.get(i));
        }
        return result;
    }

    protected String getHelpId() {
        return "refactoring.safeDelete.overridingMethods";
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add(new JLabel(JavaRefactoringBundle.message((String)"there.are.unused.methods.that.override.methods.you.delete", (Object[])new Object[0])));
        panel2.add(new JLabel(JavaRefactoringBundle.message((String)"choose.the.ones.you.want.to.be.deleted", (Object[])new Object[0])));
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        super.dispose();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(8, 0, 4, 0));
        final MyTableModel tableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)tableModel);
        this.myTable.setShowGrid(false);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn checkboxColumn = columnModel.getColumn(0);
        TableUtil.setupCheckboxColumn((TableColumn)checkboxColumn);
        checkboxColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OverridingMethodsDialog.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = OverridingMethodsDialog.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (OverridingMethodsDialog.this.myChecked[row]) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        ((OverridingMethodsDialog)OverridingMethodsDialog.this).myChecked[row] = valueToBeSet;
                    }
                    tableModel.updateData();
                }
            }
        });
        panel2.setLayout(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        panel2.add((Component)scrollPane, "Center");
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = OverridingMethodsDialog.this.myTable.getSelectionModel().getLeadSelectionIndex();
                if (index != -1) {
                    UsageInfo usageInfo = (UsageInfo)OverridingMethodsDialog.this.myOverridingMethods.get(index);
                    OverridingMethodsDialog.this.myUsagePreviewPanel.updateLayout(Collections.singletonList(usageInfo));
                } else {
                    OverridingMethodsDialog.this.myUsagePreviewPanel.updateLayout(null);
                }
            }
        };
        this.myTable.getSelectionModel().addListSelectionListener(selectionListener);
        final Splitter splitter = new Splitter(true, 0.3f);
        splitter.setFirstComponent((JComponent)panel2);
        splitter.setSecondComponent((JComponent)this.myUsagePreviewPanel);
        this.myUsagePreviewPanel.updateLayout(null);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                splitter.dispose();
            }
        });
        if (tableModel.getRowCount() != 0) {
            this.myTable.getSelectionModel().addSelectionInterval(0, 0);
        }
        return splitter;
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return OverridingMethodsDialog.this.myChecked.length;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? " " : JavaRefactoringBundle.message((String)"method.column", (Object[])new Object[0]);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return OverridingMethodsDialog.this.myChecked[rowIndex];
            }
            return OverridingMethodsDialog.this.myMethodText[rowIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                ((OverridingMethodsDialog)OverridingMethodsDialog.this).myChecked[rowIndex] = (Boolean)aValue;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        void updateData() {
            this.fireTableDataChanged();
        }
    }
}

