/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DfaBasedFilter {
    @Nullable
    private final DfaBasedFilter myNextFilter;
    @NotNull
    private final DfType myDfType;

    private DfaBasedFilter(@Nullable DfaBasedFilter nextFilter, @NotNull DfType type2) {
        if (type2 == null) {
            DfaBasedFilter.$$$reportNull$$$0(0);
        }
        this.myNextFilter = nextFilter;
        this.myDfType = type2;
    }

    DfaBasedFilter(@NotNull DfType type2) {
        if (type2 == null) {
            DfaBasedFilter.$$$reportNull$$$0(1);
        }
        this(null, type2);
    }

    @NotNull
    DfType getDfType() {
        DfType dfType = this.myDfType;
        if (dfType == null) {
            DfaBasedFilter.$$$reportNull$$$0(2);
        }
        return dfType;
    }

    DfaBasedFilter wrap() {
        return new DfaBasedFilter(this, DfTypes.TOP);
    }

    DfaBasedFilter unwrap() {
        return this.myNextFilter;
    }

    boolean allowed(@NotNull PsiElement element) {
        if (element == null) {
            DfaBasedFilter.$$$reportNull$$$0(3);
        }
        return this.allowed(element, true);
    }

    boolean requiresAssertionViolation(@NotNull PsiElement element) {
        if (element == null) {
            DfaBasedFilter.$$$reportNull$$$0(4);
        }
        return this.allowed(element, true) && !this.allowed(element, false);
    }

    private boolean allowed(@NotNull PsiElement element, boolean assertionsDisabled) {
        Object constValue;
        if (element == null) {
            DfaBasedFilter.$$$reportNull$$$0(5);
        }
        if (this.myDfType instanceof DfConstantType && element instanceof PsiLiteralValue && !((constValue = ((DfConstantType)this.myDfType).getValue()) instanceof PsiElement)) {
            Object value2 = ((PsiLiteralValue)element).getValue();
            return Objects.equals(value2, constValue);
        }
        DfType dfType = this.getElementDfType(element, assertionsDisabled);
        return dfType.meet(this.myDfType) != DfTypes.BOTTOM;
    }

    @Nullable
    DfaBasedFilter mergeFilter(@NotNull PsiElement element) {
        DfType meet;
        DfType type2;
        if (element == null) {
            DfaBasedFilter.$$$reportNull$$$0(6);
        }
        if ((type2 = this.getElementDfType(element, true)) instanceof DfReferenceType) {
            type2 = ((DfReferenceType)type2).dropLocality().dropMutability();
        }
        if ((meet = type2.meet(this.myDfType)) == DfTypes.TOP && this.myNextFilter == null) {
            return null;
        }
        if (meet == DfTypes.BOTTOM || meet.equals(this.myDfType)) {
            return this;
        }
        return new DfaBasedFilter(this.myNextFilter, meet);
    }

    @NotNull
    private DfType getElementDfType(@NotNull PsiElement element, boolean assertionsDisabled) {
        if (element == null) {
            DfaBasedFilter.$$$reportNull$$$0(7);
        }
        if (!(element instanceof PsiExpression)) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                DfaBasedFilter.$$$reportNull$$$0(8);
            }
            return dfType;
        }
        PsiExpression expression2 = (PsiExpression)element;
        PsiType expressionType = expression2.getType();
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expressionType) && this.myDfType instanceof DfReferenceType) {
            DfType dfType = DfTypes.typedObject((PsiType)((PsiPrimitiveType)expressionType).getBoxedType((PsiElement)expression2), Nullability.NOT_NULL);
            if (dfType == null) {
                DfaBasedFilter.$$$reportNull$$$0(9);
            }
            return dfType;
        }
        if (!(expressionType instanceof PsiPrimitiveType) && this.myDfType instanceof DfPrimitiveType) {
            DfType dfType = DfTypes.typedObject((PsiType)PsiPrimitiveType.getUnboxedType((PsiType)expressionType), Nullability.NOT_NULL);
            if (dfType == null) {
                DfaBasedFilter.$$$reportNull$$$0(10);
            }
            return dfType;
        }
        CommonDataflow.DataflowResult result = CommonDataflow.getDataflowResult(expression2);
        if (result == null) {
            DfType dfType = DfTypes.TOP;
            if (dfType == null) {
                DfaBasedFilter.$$$reportNull$$$0(11);
            }
            return dfType;
        }
        expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        DfType dfType = assertionsDisabled ? result.getDfTypeNoAssertions(expression2) : result.getDfType(expression2);
        if (dfType == null) {
            DfaBasedFilter.$$$reportNull$$$0(12);
        }
        return dfType;
    }

    @NotNull
    public String toString() {
        String string = this.myDfType.toString();
        if (string == null) {
            DfaBasedFilter.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getPresentationText(@NotNull PsiElement element) {
        if (element == null) {
            DfaBasedFilter.$$$reportNull$$$0(14);
        }
        if (element instanceof PsiLiteralExpression || element instanceof PsiExpression && JavaPsiMathUtil.getNumberFromLiteral((PsiExpression)element) != null) {
            return "";
        }
        if (element instanceof PsiNewExpression && ((PsiNewExpression)element).isArrayCreation()) {
            return "";
        }
        String string = DfaBasedFilter.getPresentationText(this.myDfType, DfaBasedFilter.getElementType(element));
        if (string == null) {
            DfaBasedFilter.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private static PsiType getElementType(@NotNull PsiElement element) {
        if (element == null) {
            DfaBasedFilter.$$$reportNull$$$0(16);
        }
        if (element instanceof PsiExpression) {
            return ((PsiExpression)element).getType();
        }
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        return null;
    }

    static String getPresentationText(@NotNull DfType type2, @Nullable PsiType psiType) {
        if (type2 == null) {
            DfaBasedFilter.$$$reportNull$$$0(17);
        }
        if (type2 == DfTypes.TOP) {
            return "";
        }
        if (type2 instanceof DfIntegralType) {
            LongRangeSet psiRange = LongRangeSet.fromType(psiType);
            LongRangeSet dfRange = ((DfIntegralType)type2).getRange();
            if (psiRange != null && dfRange.contains(psiRange)) {
                return "";
            }
            return dfRange.getPresentationText(psiType);
        }
        if (type2 instanceof DfConstantType) {
            return type2.toString();
        }
        if (type2 instanceof DfReferenceType) {
            DfReferenceType stripped = ((DfReferenceType)type2).dropNullability();
            DfaNullability nullability = ((DfReferenceType)type2).getNullability();
            TypeConstraint constraint = ((DfReferenceType)type2).getConstraint();
            if (constraint.getPresentationText(psiType).isEmpty()) {
                stripped = stripped.dropTypeConstraint();
            }
            String constraintText = stripped.toString();
            if (nullability == DfaNullability.NOT_NULL) {
                if (constraintText.isEmpty()) {
                    return "not-null";
                }
                return constraintText + " (not-null)";
            }
            if (nullability != DfaNullability.NULL) {
                if (constraintText.isEmpty()) {
                    return "";
                }
                return "null or " + constraintText;
            }
        }
        return type2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/DfaBasedFilter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/DfaBasedFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementDfType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "allowed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requiresAssertionViolation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeFilter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementDfType";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getElementType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

