/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.execution.filters.ExceptionAnalysisProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.slicer.DfaBasedFilter;
import com.intellij.slicer.SliceValueFilter;
import com.intellij.slicer.StackFilter;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaValueFilter
implements SliceValueFilter {
    public static final JavaValueFilter ALLOW_EVERYTHING = new JavaValueFilter(null, null);
    @Nullable
    private final DfaBasedFilter myDfaFilter;
    @Nullable
    private final StackFilter myStackFilter;

    JavaValueFilter(@Nullable DfaBasedFilter filter, @Nullable StackFilter stackFilter) {
        this.myDfaFilter = filter;
        this.myStackFilter = stackFilter;
    }

    JavaValueFilter(@NotNull DfType dfType) {
        if (dfType == null) {
            JavaValueFilter.$$$reportNull$$$0(0);
        }
        this(new DfaBasedFilter(dfType), null);
    }

    public boolean allowed(@NotNull PsiElement element) {
        if (element == null) {
            JavaValueFilter.$$$reportNull$$$0(1);
        }
        return !(this.myDfaFilter != null && !this.myDfaFilter.allowed(element) || this.myStackFilter != null && !this.myStackFilter.isAcceptable(element));
    }

    @NotNull
    public JavaValueFilter withStack(List<ExceptionAnalysisProvider.StackLine> lines) {
        return new JavaValueFilter(this.myDfaFilter, StackFilter.from(lines));
    }

    @NotNull
    JavaValueFilter withType(DfType type2) {
        return new JavaValueFilter(new DfaBasedFilter(type2), this.myStackFilter);
    }

    @NotNull
    JavaValueFilter pushFrame() {
        if (this.myStackFilter == null) {
            JavaValueFilter javaValueFilter = this;
            if (javaValueFilter == null) {
                JavaValueFilter.$$$reportNull$$$0(2);
            }
            return javaValueFilter;
        }
        return new JavaValueFilter(this.myDfaFilter, this.myStackFilter.pushFrame());
    }

    @NotNull
    JavaValueFilter popFrame(Project project) {
        if (this.myStackFilter == null) {
            JavaValueFilter javaValueFilter = this;
            if (javaValueFilter == null) {
                JavaValueFilter.$$$reportNull$$$0(3);
            }
            return javaValueFilter;
        }
        return new JavaValueFilter(this.myDfaFilter, this.myStackFilter.popFrame(project));
    }

    @NotNull
    JavaValueFilter dropFrameFilter() {
        if (this.myStackFilter == null) {
            JavaValueFilter javaValueFilter = this;
            if (javaValueFilter == null) {
                JavaValueFilter.$$$reportNull$$$0(4);
            }
            return javaValueFilter;
        }
        return new JavaValueFilter(this.myDfaFilter, null);
    }

    @NotNull
    JavaValueFilter wrap() {
        if (this.myDfaFilter == null) {
            JavaValueFilter javaValueFilter = this;
            if (javaValueFilter == null) {
                JavaValueFilter.$$$reportNull$$$0(5);
            }
            return javaValueFilter;
        }
        return new JavaValueFilter(this.myDfaFilter.wrap(), this.myStackFilter);
    }

    @NotNull
    JavaValueFilter unwrap() {
        if (this.myDfaFilter == null) {
            JavaValueFilter javaValueFilter = this;
            if (javaValueFilter == null) {
                JavaValueFilter.$$$reportNull$$$0(6);
            }
            return javaValueFilter;
        }
        return new JavaValueFilter(this.myDfaFilter.unwrap(), this.myStackFilter);
    }

    @NotNull
    SearchScope correctScope(@NotNull SearchScope scope) {
        if (scope == null) {
            JavaValueFilter.$$$reportNull$$$0(7);
        }
        SearchScope searchScope = this.myStackFilter == null ? scope : this.myStackFilter.correctScope(scope);
        if (searchScope == null) {
            JavaValueFilter.$$$reportNull$$$0(8);
        }
        return searchScope;
    }

    @NotNull
    @Nls
    public String getPresentationText(@NotNull PsiElement element) {
        if (element == null) {
            JavaValueFilter.$$$reportNull$$$0(9);
        }
        String string = this.myDfaFilter == null ? "" : this.myDfaFilter.getPresentationText(element);
        if (string == null) {
            JavaValueFilter.$$$reportNull$$$0(10);
        }
        return string;
    }

    JavaValueFilter mergeFilter(PsiElement expression2) {
        DfaBasedFilter dfaFilter = this.myDfaFilter == null ? new DfaBasedFilter(DfTypes.TOP) : this.myDfaFilter;
        DfaBasedFilter newFilter = dfaFilter.mergeFilter(expression2);
        return dfaFilter == newFilter ? this : new JavaValueFilter(newFilter, this.myStackFilter);
    }

    DfType getDfType() {
        return this.myDfaFilter == null ? DfTypes.TOP : this.myDfaFilter.getDfType();
    }

    public String toString() {
        return ((this.myDfaFilter == null ? "" : this.myDfaFilter.toString()) + " " + (this.myStackFilter == null ? "" : this.myStackFilter.toString())).trim();
    }

    public boolean requiresAssertionViolation(PsiElement element) {
        return this.myDfaFilter != null && this.myDfaFilter.requiresAssertionViolation(element);
    }

    JavaValueFilter copyStackFrom(SliceValueFilter filter) {
        if (filter instanceof JavaValueFilter && ((JavaValueFilter)filter).myStackFilter != this.myStackFilter) {
            return new JavaValueFilter(this.myDfaFilter, ((JavaValueFilter)filter).myStackFilter);
        }
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/slicer/JavaValueFilter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/slicer/JavaValueFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "pushFrame";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "popFrame";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "dropFrameFilter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "correctScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "allowed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "correctScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

