/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.ui.UISettings;
import com.intellij.java.JavaBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.ThreadOperation;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadDumpPanel
extends JPanel
implements DataProvider {
    private static final Icon PAUSE_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Actions.Pause, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon LOCKED_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Debugger.MuteBreakpoints, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon RUNNING_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Actions.Resume, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon SOCKET_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Debugger.ThreadStates.Socket, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon IDLE_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Debugger.ThreadStates.Idle, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon EDT_BUSY_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Actions.ProfileCPU, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private static final Icon IO_ICON_DAEMON = new LayeredIcon(new Icon[]{AllIcons.Actions.Menu_saveall, AllIcons.Debugger.ThreadStates.Daemon_sign});
    private final JBList myThreadList;
    private final List<ThreadState> myThreadDump;
    private final List<ThreadState> myMergedThreadDump;
    private final JPanel myFilterPanel;
    private final SearchTextField myFilterField;
    private final ExporterToTextFile myExporterToTextFile;

    public ThreadDumpPanel(final Project project, final ConsoleView consoleView, DefaultActionGroup toolbarActions, List<ThreadState> threadDump) {
        super(new BorderLayout());
        this.myThreadDump = threadDump;
        this.myMergedThreadDump = new ArrayList<ThreadState>();
        ArrayList<ThreadState> copy = new ArrayList<ThreadState>(this.myThreadDump);
        for (int i = 0; i < copy.size(); ++i) {
            ThreadState state = (ThreadState)copy.get(i);
            ThreadState.CompoundThreadState compound = new ThreadState.CompoundThreadState(state);
            this.myMergedThreadDump.add(compound);
            int j = i + 1;
            while (j < copy.size()) {
                ThreadState toAdd = (ThreadState)copy.get(j);
                if (compound.add(toAdd)) {
                    copy.remove(j);
                    continue;
                }
                ++j;
            }
        }
        this.myFilterField = new SearchTextField();
        this.myFilterField.addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ThreadDumpPanel.this.updateThreadList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/unscramble/ThreadDumpPanel$1", "textChanged"));
            }
        });
        this.myFilterPanel = new JPanel(new BorderLayout());
        this.myFilterPanel.add((Component)new JLabel(CommonBundle.message((String)"label.filter", (Object[])new Object[0]) + ":"), "West");
        this.myFilterPanel.add((Component)this.myFilterField);
        this.myFilterPanel.setVisible(false);
        this.myThreadList = new JBList(new DefaultListModel());
        this.myThreadList.setCellRenderer((ListCellRenderer)((Object)new ThreadListCellRenderer()));
        this.myThreadList.setSelectionMode(0);
        this.myThreadList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = ThreadDumpPanel.this.myThreadList.getSelectedIndex();
                if (index >= 0) {
                    ThreadState selection = (ThreadState)ThreadDumpPanel.this.myThreadList.getModel().getElementAt(index);
                    AnalyzeStacktraceUtil.printStacktrace((ConsoleView)consoleView, (String)selection.getStackTrace());
                } else {
                    AnalyzeStacktraceUtil.printStacktrace((ConsoleView)consoleView, (String)"");
                }
                ThreadDumpPanel.this.myThreadList.repaint();
            }
        });
        this.myExporterToTextFile = ThreadDumpPanel.createToFileExporter(project, this.myThreadDump);
        FilterAction filterAction = new FilterAction();
        filterAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("Find").getShortcutSet(), (JComponent)this.myThreadList);
        toolbarActions.add((AnAction)filterAction);
        toolbarActions.add((AnAction)new CopyToClipboardAction(threadDump, project));
        toolbarActions.add((AnAction)new SortThreadsAction());
        toolbarActions.add(ActionManager.getInstance().getAction("ExportToTextFile"));
        toolbarActions.add((AnAction)new MergeStacktracesAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ThreadDump", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        this.add((Component)toolbar.getComponent(), "West");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.myFilterPanel, "North");
        leftPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myThreadList, (int)5), "Center");
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setFirstComponent((JComponent)leftPanel);
        splitter.setSecondComponent(consoleView.getComponent());
        this.add((Component)splitter, "Center");
        new ListSpeedSearch((JList)this.myThreadList).setComparator(new SpeedSearchComparator(false, true));
        this.updateThreadList();
        final Editor editor = (Editor)CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext((Component)consoleView.getPreferredFocusableComponent()));
        if (editor != null) {
            editor.getDocument().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    String filter;
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (StringUtil.isNotEmpty((String)(filter = ThreadDumpPanel.this.myFilterField.getText()))) {
                        ThreadDumpPanel.highlightOccurrences(filter, project, editor);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/unscramble/ThreadDumpPanel$3", "documentChanged"));
                }
            }, (Disposable)consoleView);
        }
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ThreadDumpPanel.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.EXPORTER_TO_TEXT_FILE.is(dataId)) {
            return this.myExporterToTextFile;
        }
        return null;
    }

    private void updateThreadList() {
        String text2 = this.myFilterPanel.isVisible() ? this.myFilterField.getText() : "";
        Object selection = this.myThreadList.getSelectedValue();
        DefaultListModel model = (DefaultListModel)this.myThreadList.getModel();
        model.clear();
        int selectedIndex = 0;
        int index = 0;
        List<ThreadState> threadStates = UISettings.getInstance().getState().getMergeEqualStackTraces() ? this.myMergedThreadDump : this.myThreadDump;
        for (ThreadState state : threadStates) {
            if (!StringUtil.containsIgnoreCase((String)state.getStackTrace(), (String)text2) && !StringUtil.containsIgnoreCase((String)state.getName(), (String)text2)) continue;
            model.addElement(state);
            if (selection == state) {
                selectedIndex = index;
            }
            ++index;
        }
        if (!model.isEmpty()) {
            this.myThreadList.setSelectedIndex(selectedIndex);
        }
        this.myThreadList.revalidate();
        this.myThreadList.repaint();
    }

    private static void highlightOccurrences(String filter, Project project, Editor editor) {
        int nextOccurrence;
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
        String documentText = editor.getDocument().getText();
        int i = -1;
        while ((nextOccurrence = StringUtil.indexOfIgnoreCase((String)documentText, (String)filter, (int)(i + 1))) >= 0) {
            i = nextOccurrence;
            highlightManager.addOccurrenceHighlight(editor, i, i + filter.length(), attributes, 4, null, null);
        }
    }

    private static Icon getThreadStateIcon(ThreadState threadState) {
        boolean daemon = threadState.isDaemon();
        if (threadState.isSleeping()) {
            return daemon ? PAUSE_ICON_DAEMON : AllIcons.Actions.Pause;
        }
        if (threadState.isWaiting()) {
            return daemon ? LOCKED_ICON_DAEMON : AllIcons.Debugger.MuteBreakpoints;
        }
        if (threadState.getOperation() == ThreadOperation.Socket) {
            return daemon ? SOCKET_ICON_DAEMON : AllIcons.Debugger.ThreadStates.Socket;
        }
        if (threadState.getOperation() == ThreadOperation.IO) {
            return daemon ? IO_ICON_DAEMON : AllIcons.Actions.Menu_saveall;
        }
        if (threadState.isEDT()) {
            if ("idle".equals(threadState.getThreadStateDetail())) {
                return daemon ? IDLE_ICON_DAEMON : AllIcons.Debugger.ThreadStates.Idle;
            }
            return daemon ? EDT_BUSY_ICON_DAEMON : AllIcons.Actions.ProfileCPU;
        }
        return daemon ? RUNNING_ICON_DAEMON : AllIcons.Actions.Resume;
    }

    private static StateCode getThreadStateCode(ThreadState state) {
        if (state.isSleeping()) {
            return StateCode.PAUSED;
        }
        if (state.isWaiting()) {
            return StateCode.LOCKED;
        }
        if (state.getOperation() == ThreadOperation.Socket) {
            return StateCode.RUN_SOCKET;
        }
        if (state.getOperation() == ThreadOperation.IO) {
            return StateCode.RUN_IO;
        }
        if (state.isEDT()) {
            return "idle".equals(state.getThreadStateDetail()) ? StateCode.IDLE : StateCode.EDT;
        }
        return StateCode.RUN;
    }

    private static SimpleTextAttributes getAttributes(ThreadState threadState) {
        if (threadState.isSleeping()) {
            return SimpleTextAttributes.GRAY_ATTRIBUTES;
        }
        if (threadState.isEmptyStackTrace() || threadState.isKnownJDKThread()) {
            return new SimpleTextAttributes(0, Color.GRAY.brighter());
        }
        if (threadState.isEDT()) {
            return SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    public void selectStackFrame(int index) {
        this.myThreadList.setSelectedIndex(index);
    }

    public static ExporterToTextFile createToFileExporter(Project project, List<? extends ThreadState> threadStates) {
        return new MyToFileExporter(project, threadStates);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/unscramble/ThreadDumpPanel", "getData"));
    }

    private static class MyToFileExporter
    implements ExporterToTextFile {
        private final Project myProject;
        private final List<? extends ThreadState> myThreadStates;
        @NonNls
        private static final String DEFAULT_REPORT_FILE_NAME = "threads_report.txt";

        private MyToFileExporter(Project project, List<? extends ThreadState> threadStates) {
            this.myProject = project;
            this.myThreadStates = threadStates;
        }

        @NotNull
        public String getReportText() {
            StringBuilder sb = new StringBuilder();
            for (ThreadState threadState : this.myThreadStates) {
                sb.append(threadState.getStackTrace()).append("\n\n");
            }
            String string = sb.toString();
            if (string == null) {
                MyToFileExporter.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getDefaultFilePath() {
            VirtualFile baseDir = this.myProject.getBaseDir();
            if (baseDir != null) {
                String string = baseDir.getPresentableUrl() + File.separator + DEFAULT_REPORT_FILE_NAME;
                if (string == null) {
                    MyToFileExporter.$$$reportNull$$$0(1);
                }
                return string;
            }
            return "";
        }

        public boolean canExport() {
            return !this.myThreadStates.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/unscramble/ThreadDumpPanel$MyToFileExporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReportText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultFilePath";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class MergeStacktracesAction
    extends ToggleAction
    implements DumbAware {
        private MergeStacktracesAction() {
            super(JavaBundle.messagePointer((String)"action.text.merge.identical.stacktraces", (Object[])new Object[0]), JavaBundle.messagePointer((String)"action.description.group.threads.with.identical.stacktraces", (Object[])new Object[0]), AllIcons.Actions.Collapseall);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MergeStacktracesAction.$$$reportNull$$$0(0);
            }
            return UISettings.getInstance().getState().getMergeEqualStackTraces();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MergeStacktracesAction.$$$reportNull$$$0(1);
            }
            UISettings.getInstance().getState().setMergeEqualStackTraces(state);
            ThreadDumpPanel.this.updateThreadList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/unscramble/ThreadDumpPanel$MergeStacktracesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FilterAction
    extends ToggleAction
    implements DumbAware {
        private FilterAction() {
            super(CommonBundle.messagePointer((String)"action.text.filter", (Object[])new Object[0]), JavaBundle.messagePointer((String)"action.description.show.only.threads.containing.a.specific.string", (Object[])new Object[0]), AllIcons.General.Filter);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FilterAction.$$$reportNull$$$0(0);
            }
            return ThreadDumpPanel.this.myFilterPanel.isVisible();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                FilterAction.$$$reportNull$$$0(1);
            }
            ThreadDumpPanel.this.myFilterPanel.setVisible(state);
            if (state) {
                IdeFocusManager.getInstance((Project)FilterAction.getEventProject((AnActionEvent)e)).requestFocus((Component)ThreadDumpPanel.this.myFilterField, true);
                ThreadDumpPanel.this.myFilterField.selectText();
            }
            ThreadDumpPanel.this.updateThreadList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/unscramble/ThreadDumpPanel$FilterAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CopyToClipboardAction
    extends DumbAwareAction {
        private static final NotificationGroup GROUP = NotificationGroup.toolWindowGroup((String)"Analyze thread dump", (String)"Run", (boolean)false);
        private final List<? extends ThreadState> myThreadDump;
        private final Project myProject;

        private CopyToClipboardAction(List<? extends ThreadState> threadDump, Project project) {
            super(JavaBundle.message((String)"action.text.copy.to.clipboard", (Object[])new Object[0]), JavaBundle.message((String)"action.description.copy.whole.thread.dump.to.clipboard", (Object[])new Object[0]), PlatformIcons.COPY_ICON);
            this.myThreadDump = threadDump;
            this.myProject = project;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyToClipboardAction.$$$reportNull$$$0(0);
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Full thread dump").append("\n\n");
            for (ThreadState threadState : this.myThreadDump) {
                buf.append(threadState.getStackTrace()).append("\n\n");
            }
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(buf.toString()));
            GROUP.createNotification(JavaBundle.message((String)"notification.text.full.thread.dump.was.successfully.copied.to.clipboard", (Object[])new Object[0]), MessageType.INFO).notify(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/unscramble/ThreadDumpPanel$CopyToClipboardAction", "actionPerformed"));
        }
    }

    private class SortThreadsAction
    extends DumbAwareAction {
        private final Comparator<ThreadState> BY_TYPE;
        private final Comparator<ThreadState> BY_NAME;
        private Comparator<ThreadState> COMPARATOR;
        private static final String TYPE_LABEL = "Sort threads by type";
        private static final String NAME_LABEL = "Sort threads by name";

        private SortThreadsAction() {
            super(TYPE_LABEL);
            this.BY_TYPE = (o1, o2) -> {
                int c = ThreadDumpPanel.getThreadStateCode(o1).compareTo(ThreadDumpPanel.getThreadStateCode(o2));
                if (c == 0) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
                return c;
            };
            this.BY_NAME = (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
            this.COMPARATOR = this.BY_TYPE;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SortThreadsAction.$$$reportNull$$$0(0);
            }
            ThreadDumpPanel.this.myThreadDump.sort(this.COMPARATOR);
            ThreadDumpPanel.this.myMergedThreadDump.sort(this.COMPARATOR);
            ThreadDumpPanel.this.updateThreadList();
            this.COMPARATOR = this.COMPARATOR == this.BY_TYPE ? this.BY_NAME : this.BY_TYPE;
            this.update(e);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SortThreadsAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setIcon(this.COMPARATOR == this.BY_TYPE ? AllIcons.ObjectBrowser.SortByType : AllIcons.ObjectBrowser.Sorted);
            e.getPresentation().setText(this.COMPARATOR == this.BY_TYPE ? TYPE_LABEL : NAME_LABEL);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/unscramble/ThreadDumpPanel$SortThreadsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ThreadListCellRenderer
    extends ColoredListCellRenderer {
        private ThreadListCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value2, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                ThreadListCellRenderer.$$$reportNull$$$0(0);
            }
            ThreadState threadState = (ThreadState)value2;
            this.setIcon(ThreadDumpPanel.getThreadStateIcon(threadState));
            if (!selected) {
                ThreadState selectedThread = (ThreadState)list.getSelectedValue();
                if (threadState.isDeadlocked()) {
                    this.setBackground(LightColors.RED);
                } else if (selectedThread != null && threadState.isAwaitedBy(selectedThread)) {
                    this.setBackground((Color)JBColor.YELLOW);
                } else {
                    this.setBackground(UIUtil.getListBackground());
                }
            }
            SimpleTextAttributes attrs = ThreadDumpPanel.getAttributes(threadState);
            this.append(threadState.getName() + " (", attrs);
            String detail = threadState.getThreadStateDetail();
            if (detail == null) {
                detail = threadState.getState();
            }
            if (detail.length() > 30) {
                detail = detail.substring(0, 30) + "...";
            }
            this.append(detail, attrs);
            this.append(")", attrs);
            if (threadState.getExtraState() != null) {
                this.append(" [" + threadState.getExtraState() + "]", attrs);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/unscramble/ThreadDumpPanel$ThreadListCellRenderer", "customizeCellRenderer"));
        }
    }

    private static enum StateCode {
        RUN,
        RUN_IO,
        RUN_SOCKET,
        PAUSED,
        LOCKED,
        EDT,
        IDLE;

    }
}

