/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class FormatDecode {
    private static final Pattern fsPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d*)?([tT])?([a-zA-Z%])");
    private static final Validator ALL_VALIDATOR = new AllValidator();
    private static final int LEFT_JUSTIFY = 1;
    private static final int ALTERNATE = 2;
    private static final int PLUS = 4;
    private static final int LEADING_SPACE = 8;
    private static final int ZERO_PAD = 16;
    private static final int GROUP = 32;
    private static final int PARENTHESES = 64;
    private static final int PREVIOUS = 128;

    private FormatDecode() {
    }

    private static int flag(char c) {
        switch (c) {
            case '-': {
                return 1;
            }
            case '#': {
                return 2;
            }
            case '+': {
                return 4;
            }
            case ' ': {
                return 8;
            }
            case '0': {
                return 16;
            }
            case ',': {
                return 32;
            }
            case '(': {
                return 64;
            }
            case '<': {
                return 128;
            }
        }
        return -1;
    }

    private static String flagString(int flags) {
        StringBuilder result = new StringBuilder(8);
        if ((flags & 1) != 0) {
            result.append('-');
        }
        if ((flags & 2) != 0) {
            result.append('#');
        }
        if ((flags & 4) != 0) {
            result.append('+');
        }
        if ((flags & 8) != 0) {
            result.append(' ');
        }
        if ((flags & 0x10) != 0) {
            result.append('0');
        }
        if ((flags & 0x20) != 0) {
            result.append(',');
        }
        if ((flags & 0x40) != 0) {
            result.append('(');
        }
        if ((flags & 0x80) != 0) {
            result.append('<');
        }
        return result.toString();
    }

    private static void checkFlags(int value2, int allowedFlags, String specifier) {
        int result = value2 & ~allowedFlags;
        if (result != 0) {
            String flags = FormatDecode.flagString(result);
            throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.flags.not.allowed", flags, specifier, flags.length()));
        }
    }

    public static Validator @NotNull [] decode(String formatString, int argumentCount) {
        ArrayList<Validator> parameters2 = new ArrayList<Validator>();
        Matcher matcher = fsPattern.matcher(formatString);
        boolean previousAllowed = false;
        int implicit = 0;
        int pos = 0;
        int i = 0;
        while (matcher.find(i)) {
            Validator allowed;
            int start = matcher.start();
            if (start != i) {
                FormatDecode.checkText(formatString.substring(i, start));
            }
            i = matcher.end();
            String specifier = matcher.group();
            String posSpec = matcher.group(1);
            String flags = matcher.group(2);
            String width = matcher.group(3);
            String precision = matcher.group(4);
            String dateSpec = matcher.group(5);
            String conversion = matcher.group(6);
            int flagBits = 0;
            for (int j = 0; j < flags.length(); ++j) {
                char flag = flags.charAt(j);
                int bit = FormatDecode.flag(flag);
                if (bit == -1) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.unexpected.flag", Character.valueOf(flag), specifier));
                }
                if ((flagBits | bit) == flagBits) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.duplicate.flag", Character.valueOf(flag), specifier));
                }
                flagBits |= bit;
            }
            if ("n".equals(conversion)) {
                FormatDecode.checkFlags(flagBits, 0, specifier);
                if (!StringUtil.isEmpty((String)width)) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.width.not.allowed", width, specifier));
                }
                FormatDecode.checkNoPrecision(precision, specifier);
                continue;
            }
            if ("%".equals(conversion)) {
                FormatDecode.checkFlags(flagBits, 1, specifier);
                FormatDecode.checkNoPrecision(precision, specifier);
                continue;
            }
            if (posSpec != null) {
                if (FormatDecode.isAllBitsSet(flagBits, 128)) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.unnecessary.position.specifier", posSpec, specifier));
                }
                String num = posSpec.substring(0, posSpec.length() - 1);
                pos = Integer.parseInt(num) - 1;
                if (pos < 0) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.illegal.position.specifier", posSpec, specifier));
                }
                previousAllowed = true;
            } else if (FormatDecode.isAllBitsSet(flagBits, 128)) {
                if (!previousAllowed) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.previous.element.not.found", specifier));
                }
            } else {
                previousAllowed = true;
                pos = implicit++;
            }
            if (dateSpec != null) {
                FormatDecode.checkFlags(flagBits, 129, specifier);
                FormatDecode.checkNoPrecision(precision, specifier);
                allowed = new DateValidator(specifier);
            } else {
                switch (conversion.charAt(0)) {
                    case 'B': 
                    case 'H': 
                    case 'b': 
                    case 'h': {
                        FormatDecode.checkFlags(flagBits, 129, specifier);
                        allowed = ALL_VALIDATOR;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        FormatDecode.checkFlags(flagBits, 131, specifier);
                        allowed = (flagBits & 2) != 0 ? new FormattableValidator(specifier) : ALL_VALIDATOR;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        FormatDecode.checkFlags(flagBits, 129, specifier);
                        FormatDecode.checkNoPrecision(precision, specifier);
                        allowed = new CharValidator(specifier);
                        break;
                    }
                    case 'd': {
                        FormatDecode.checkFlags(flagBits, -3, specifier);
                        allowed = new IntValidator(specifier);
                        break;
                    }
                    case 'X': 
                    case 'o': 
                    case 'x': {
                        FormatDecode.checkFlags(flagBits, -45, specifier);
                        FormatDecode.checkNoPrecision(precision, specifier);
                        allowed = new IntValidator(specifier);
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        FormatDecode.checkFlags(flagBits, -97, specifier);
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        FormatDecode.checkFlags(flagBits, -33, specifier);
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        FormatDecode.checkFlags(flagBits, -3, specifier);
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    case 'f': {
                        allowed = new FloatValidator(specifier);
                        break;
                    }
                    default: {
                        throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.unknown.conversion", specifier));
                    }
                }
            }
            if (precision != null && precision.length() < 2) {
                throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.invalid.precision", specifier));
            }
            if (FormatDecode.isAllBitsSet(flagBits, 12)) {
                throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.illegal.flag.combination", Character.valueOf(' '), Character.valueOf('+'), specifier));
            }
            if (FormatDecode.isAllBitsSet(flagBits, 17)) {
                throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.illegal.flag.combination", Character.valueOf('-'), Character.valueOf('0'), specifier));
            }
            if (StringUtil.isEmpty((String)width)) {
                if (FormatDecode.isAllBitsSet(flagBits, 1)) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.left.justify.no.width", specifier));
                }
                if (FormatDecode.isAllBitsSet(flagBits, 16)) {
                    throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.zero.padding.no.width", specifier));
                }
            }
            FormatDecode.storeValidator(allowed, pos, parameters2, argumentCount);
        }
        if (i < formatString.length()) {
            FormatDecode.checkText(formatString.substring(i));
        }
        Validator[] validatorArray = parameters2.toArray(new Validator[0]);
        if (validatorArray == null) {
            FormatDecode.$$$reportNull$$$0(0);
        }
        return validatorArray;
    }

    private static void checkNoPrecision(String precision, String specifier) {
        if (!StringUtil.isEmpty((String)precision)) {
            throw new IllegalFormatException(InspectionGadgetsBundle.message("format.string.error.precision.not.allowed", precision, specifier));
        }
    }

    private static boolean isAllBitsSet(int value2, int mask) {
        return (value2 & mask) == mask;
    }

    private static void checkText(String s) {
        if (s.indexOf(37) != -1) {
            throw new IllegalFormatException();
        }
    }

    private static void storeValidator(Validator validator2, int pos, ArrayList<Validator> parameters2, int argumentCount) {
        if (pos < parameters2.size()) {
            Validator existing = parameters2.get(pos);
            if (existing == null) {
                parameters2.set(pos, validator2);
            } else if (existing instanceof MultiValidator) {
                ((MultiValidator)existing).addValidator(validator2);
            } else if (existing != validator2) {
                MultiValidator multiValidator = new MultiValidator(existing.getSpecifier());
                multiValidator.addValidator(existing);
                multiValidator.addValidator(validator2);
                parameters2.set(pos, multiValidator);
            }
        } else {
            while (pos > parameters2.size() && argumentCount > parameters2.size()) {
                parameters2.add(null);
            }
            parameters2.add(validator2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/FormatDecode", "decode"));
    }

    static abstract class Validator {
        private final String mySpecifier;

        Validator(String specifier) {
            this.mySpecifier = specifier;
        }

        public abstract boolean valid(PsiType var1);

        public String getSpecifier() {
            return this.mySpecifier;
        }
    }

    private static class MultiValidator
    extends Validator {
        private final Set<Validator> validators = new HashSet<Validator>(3);

        MultiValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type2) {
            for (Validator validator2 : this.validators) {
                if (validator2.valid(type2)) continue;
                return false;
            }
            return true;
        }

        public void addValidator(Validator validator2) {
            this.validators.add(validator2);
        }
    }

    private static class FormattableValidator
    extends Validator {
        FormattableValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type2) {
            return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Formattable");
        }
    }

    private static class FloatValidator
    extends Validator {
        FloatValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type2) {
            String text2 = type2.getCanonicalText();
            return PsiType.DOUBLE.equals((Object)type2) || "java.lang.Double".equals(text2) || PsiType.FLOAT.equals((Object)type2) || "java.lang.Float".equals(text2) || "java.math.BigDecimal".equals(text2);
        }
    }

    private static class IntValidator
    extends Validator {
        IntValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type2) {
            String text2 = type2.getCanonicalText();
            return PsiType.INT.equals((Object)type2) || "java.lang.Integer".equals(text2) || PsiType.LONG.equals((Object)type2) || "java.lang.Long".equals(text2) || PsiType.SHORT.equals((Object)type2) || "java.lang.Short".equals(text2) || PsiType.BYTE.equals((Object)type2) || "java.lang.Byte".equals(text2) || "java.math.BigInteger".equals(text2);
        }
    }

    private static class CharValidator
    extends Validator {
        CharValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type2) {
            if (PsiType.CHAR.equals((Object)type2) || PsiType.BYTE.equals((Object)type2) || PsiType.SHORT.equals((Object)type2) || PsiType.INT.equals((Object)type2)) {
                return true;
            }
            String text2 = type2.getCanonicalText();
            return "java.lang.Character".equals(text2) || "java.lang.Byte".equals(text2) || "java.lang.Short".equals(text2) || "java.lang.Integer".equals(text2);
        }
    }

    private static class DateValidator
    extends Validator {
        DateValidator(String specifier) {
            super(specifier);
        }

        @Override
        public boolean valid(PsiType type2) {
            String text2 = type2.getCanonicalText();
            return PsiType.LONG.equals((Object)type2) || "java.lang.Long".equals(text2) || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Date") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.util.Calendar") || InheritanceUtil.isInheritor((PsiType)type2, (String)"java.time.temporal.TemporalAccessor");
        }
    }

    private static class AllValidator
    extends Validator {
        AllValidator() {
            super("");
        }

        @Override
        public boolean valid(PsiType type2) {
            return true;
        }
    }

    public static class IllegalFormatException
    extends RuntimeException {
        public IllegalFormatException(@Nls String message2) {
            super(message2);
        }

        public IllegalFormatException() {
        }
    }
}

