/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class NonShortCircuitBooleanInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NonShortCircuitBooleanExpression";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.problem.descriptor", new Object[0]);
        if (string == null) {
            NonShortCircuitBooleanInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new NonShortCircuitBooleanFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonShortCircuitBooleanVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection", "buildErrorString"));
    }

    private static class NonShortCircuitBooleanVisitor
    extends BaseInspectionVisitor {
        private NonShortCircuitBooleanVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.AND) && !tokenType.equals(JavaTokenType.OR)) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            if (!type2.equals(PsiType.BOOLEAN)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }
    }

    private static class NonShortCircuitBooleanFix
    extends InspectionGadgetsFix {
        private NonShortCircuitBooleanFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("non.short.circuit.boolean.expression.replace.quickfix", new Object[0]);
            if (string == null) {
                NonShortCircuitBooleanFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiPolyadicExpression expression2 = (PsiPolyadicExpression)descriptor.getPsiElement();
            IElementType tokenType = expression2.getOperationTokenType();
            String operandText = NonShortCircuitBooleanFix.getShortCircuitOperand(tokenType);
            PsiExpression[] operands2 = expression2.getOperands();
            StringBuilder newExpression = new StringBuilder();
            CommentTracker commentTracker = new CommentTracker();
            for (PsiExpression operand2 : operands2) {
                if (newExpression.length() != 0) {
                    newExpression.append(operandText);
                }
                newExpression.append(commentTracker.text((PsiElement)operand2));
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression.toString(), commentTracker);
        }

        private static String getShortCircuitOperand(IElementType tokenType) {
            if (tokenType.equals(JavaTokenType.AND)) {
                return "&&";
            }
            return "||";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/NonShortCircuitBooleanInspection$NonShortCircuitBooleanFix", "getFamilyName"));
        }
    }
}

