/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousDateFormatInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher PATTERN_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.text.SimpleDateFormat", "applyPattern", "applyLocalizedPattern").parameterTypes("java.lang.String"), CallMatcher.staticCall("java.time.format.DateTimeFormatter", "ofPattern"), CallMatcher.instanceCall("java.time.format.DateTimeFormatterBuilder", "appendPattern").parameterTypes("java.lang.String"));

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousDateFormatInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                if (PATTERN_METHODS.test(call)) {
                    ExpressionUtils.nonStructuralChildren(call.getArgumentList().getExpressions()[0]).forEach(this::processExpression);
                }
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                PsiExpression patternArg;
                PsiExpressionList args;
                if (ConstructionUtils.isReferenceTo(expression2.getClassReference(), "java.text.SimpleDateFormat") && (args = expression2.getArgumentList()) != null && (patternArg = (PsiExpression)ArrayUtil.getFirstElement((Object[])args.getExpressions())) != null) {
                    ExpressionUtils.nonStructuralChildren(patternArg).forEach(this::processExpression);
                }
            }

            private void processExpression(@NotNull PsiExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (expression2 instanceof PsiLiteralExpression) {
                    this.processLiteral((PsiLiteralExpression)expression2);
                }
                if (expression2 instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)expression2).getOperationTokenType().equals(JavaTokenType.PLUS)) {
                    for (PsiExpression operand2 : ((PsiPolyadicExpression)expression2).getOperands()) {
                        ExpressionUtils.nonStructuralChildren(operand2).forEach(this::processExpression);
                    }
                }
            }

            private void processLiteral(@NotNull PsiLiteralExpression expression2) {
                String pattern;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((pattern = (String)ObjectUtils.tryCast((Object)expression2.getValue(), String.class)) == null) {
                    return;
                }
                ArrayList<Token> tokens = new ArrayList<Token>();
                char lastChar = '\u0000';
                int countNonAlpha = 0;
                char[] array = pattern.toCharArray();
                for (int pos = 0; pos < array.length; ++pos) {
                    char c = array[pos];
                    if (c == lastChar) continue;
                    lastChar = c;
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                        countNonAlpha = 0;
                        tokens.add(new Token(pos, array));
                        continue;
                    }
                    if (++countNonAlpha <= 3) continue;
                    tokens.add(null);
                }
                for (int i = 0; i < tokens.size(); ++i) {
                    TextRange range;
                    Token next;
                    Token prev;
                    Token token = (Token)tokens.get(i);
                    Problem problem = this.getProblem(token, prev = i > 0 ? (Token)tokens.get(i - 1) : null, next = i < tokens.size() - 1 ? (Token)tokens.get(i + 1) : null);
                    if (problem == null || (range = ExpressionUtils.findStringLiteralRange((PsiExpression)expression2, token.pos, token.pos + token.length)) == null) continue;
                    holder.registerProblem((PsiElement)expression2, range, problem.toString(), new LocalQuickFix[]{new IncorrectDateFormatFix(token, range)});
                }
            }

            @Contract(value="null, _, _ -> null")
            private Problem getProblem(@Nullable Token token, @Nullable Token prev, @Nullable Token next) {
                if (token == null) {
                    return null;
                }
                switch (token.character) {
                    case 'Y': {
                        if (this.hasNeighbor("w", prev, next)) break;
                        return new Problem(token, "week year", "year");
                    }
                    case 'M': {
                        if (!this.hasNeighbor("HhKk", prev, next) || this.hasNeighbor("yd", prev, next)) break;
                        return new Problem(token, "month", "minute");
                    }
                    case 'm': {
                        if (!this.hasNeighbor("yd", prev, next) || this.hasNeighbor("HhKk", prev, next)) break;
                        return new Problem(token, "minute", "month");
                    }
                    case 'D': {
                        if (!this.hasNeighbor("ML", prev, next)) break;
                        return new Problem(token, "day of year", "day of month");
                    }
                    case 'S': {
                        if (!this.hasNeighbor("m", prev, next)) break;
                        return new Problem(token, "milliseconds", "seconds");
                    }
                }
                return null;
            }

            private boolean hasNeighbor(@NotNull String neighbors, @Nullable Token prev, @Nullable Token next) {
                if (neighbors == null) {
                    1.$$$reportNull$$$0(2);
                }
                return prev != null && neighbors.indexOf(prev.character) >= 0 || next != null && neighbors.indexOf(next.character) >= 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "neighbors";
                        break;
                    }
                }
                objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousDateFormatInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processLiteral";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasNeighbor";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/siyeh/ig/bugs/SuspiciousDateFormatInspection", "buildVisitor"));
    }

    private static class IncorrectDateFormatFix
    implements LocalQuickFix {
        private final Token myToken;
        private final TextRange myRange;

        IncorrectDateFormatFix(Token token, TextRange range) {
            this.myToken = token;
            this.myRange = range;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{this.myToken.toString(), this.myToken.fixed()});
            if (string == null) {
                IncorrectDateFormatFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("incorrect.date.format.fix.family.name", new Object[0]);
            if (string == null) {
                IncorrectDateFormatFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiLiteralExpression literal;
            if (project == null) {
                IncorrectDateFormatFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                IncorrectDateFormatFix.$$$reportNull$$$0(3);
            }
            if ((literal = (PsiLiteralExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiLiteralExpression.class)) == null) {
                return;
            }
            String text2 = literal.getText();
            if (this.myRange.getEndOffset() >= text2.length()) {
                return;
            }
            String existing = this.myRange.substring(text2);
            if (!existing.equals(this.myToken.toString())) {
                return;
            }
            text2 = text2.substring(0, this.myRange.getStartOffset()) + this.myToken.fixed() + text2.substring(this.myRange.getEndOffset());
            PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(text2, (PsiElement)literal);
            literal.replace((PsiElement)replacement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/SuspiciousDateFormatInspection$IncorrectDateFormatFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/SuspiciousDateFormatInspection$IncorrectDateFormatFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Problem {
        final Token token;
        final String usedName;
        final String intendedName;

        private Problem(Token token, String usedName, String intendedName) {
            this.token = token;
            this.usedName = usedName;
            this.intendedName = intendedName;
        }

        public String toString() {
            String key2 = Character.isUpperCase(this.token.character) ? "inspection.suspicious.date.format.message.upper" : "inspection.suspicious.date.format.message.lower";
            return InspectionGadgetsBundle.message(key2, this.token, this.usedName, this.token.fixed(), this.intendedName);
        }
    }

    private static class Token {
        final char character;
        final int pos;
        final int length;

        Token(int pos, char[] chars) {
            this.character = chars[pos];
            this.pos = pos;
            int length = 0;
            for (int i = pos; i < chars.length && chars[i] == this.character; ++i) {
                ++length;
            }
            this.length = length;
        }

        public String fixed() {
            return Character.isUpperCase(this.character) ? this.toString().toLowerCase(Locale.ROOT) : this.toString().toUpperCase(Locale.ROOT);
        }

        public String toString() {
            return StringUtil.repeat((String)String.valueOf(this.character), (int)this.length);
        }
    }
}

