/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class UseOfPropertiesAsHashtableInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("properties.object.as.hashtable.problem.descriptor", new Object[0]);
        if (string == null) {
            UseOfPropertiesAsHashtableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiExpression[] arguments;
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)infos[0];
        String methodName = methodCallExpression.getMethodExpression().getReferenceName();
        boolean put = "put".equals(methodName);
        if (!put && !"get".equals(methodName)) {
            return null;
        }
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            PsiType type2 = argument.getType();
            if (type2 != null && type2.equalsToText("java.lang.String")) continue;
            return null;
        }
        return new UseOfPropertiesAsHashtableFix(put);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfPropertiesAsHashtableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection", "buildErrorString"));
    }

    private static class UseOfPropertiesAsHashtableVisitor
    extends BaseInspectionVisitor {
        private static final CallMatcher HASH_TABLE_CALLS = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Hashtable", "put", "putIfAbsent").parameterTypes("K", "V"), CallMatcher.instanceCall("java.util.Hashtable", "get").parameterTypes("java.lang.Object"), CallMatcher.instanceCall("java.util.Hashtable", "putAll").parameterTypes("java.util.Map"));

        private UseOfPropertiesAsHashtableVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiType type2;
            PsiExpression[] args;
            if (call == null) {
                UseOfPropertiesAsHashtableVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            if (!HASH_TABLE_CALLS.test(call)) {
                return;
            }
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.Properties")) {
                return;
            }
            if ("putAll".equals(call.getMethodExpression().getReferenceName()) && (args = call.getArgumentList().getExpressions()).length == 1 && (TypeUtils.typeEquals("java.util.Properties", type2 = args[0].getType()) || TypeUtils.isJavaLangString(PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)0, (boolean)true)) && TypeUtils.isJavaLangString(PsiUtil.substituteTypeParameter((PsiType)type2, (String)"java.util.Map", (int)1, (boolean)true)))) {
                return;
            }
            this.registerMethodCallError(call, call);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection$UseOfPropertiesAsHashtableVisitor", "visitMethodCallExpression"));
        }
    }

    private static class UseOfPropertiesAsHashtableFix
    extends InspectionGadgetsFix {
        private final boolean put;

        UseOfPropertiesAsHashtableFix(boolean put) {
            this.put = put;
        }

        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.put ? "setProperty()" : "getProperty()"});
            if (string == null) {
                UseOfPropertiesAsHashtableFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("use.of.properties.as.hashtable.fix.family.name", new Object[0]);
            if (string == null) {
                UseOfPropertiesAsHashtableFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            CommentTracker commentTracker = new CommentTracker();
            StringBuilder newExpression = new StringBuilder();
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 != null) {
                newExpression.append(commentTracker.text((PsiElement)qualifierExpression2));
                newExpression.append('.');
            }
            if (this.put) {
                newExpression.append("setProperty(");
            } else {
                newExpression.append("getProperty(");
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            Object[] arguments = argumentList.getExpressions();
            newExpression.append(StringUtil.join((Object[])arguments, arg -> commentTracker.text((PsiElement)arg), (String)","));
            newExpression.append(')');
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString(), commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/bugs/UseOfPropertiesAsHashtableInspection$UseOfPropertiesAsHashtableFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

