/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class ReturnFromFinallyBlockInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ReturnInsideFinallyBlock";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("return.from.finally.block.problem.descriptor", new Object[0]);
        if (string == null) {
            ReturnFromFinallyBlockInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReturnFromFinallyBlockVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ReturnFromFinallyBlockInspection", "buildErrorString"));
    }

    private static class ReturnFromFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private ReturnFromFinallyBlockVisitor() {
        }

        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
            if (statement == null) {
                ReturnFromFinallyBlockVisitor.$$$reportNull$$$0(0);
            }
            super.visitReturnStatement(statement);
            if (!ControlFlowUtils.isInFinallyBlock((PsiElement)statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/ReturnFromFinallyBlockInspection$ReturnFromFinallyBlockVisitor", "visitReturnStatement"));
        }
    }
}

