/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ThrowsRuntimeExceptionInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        String exceptionName = (String)infos[0];
        if (MoveExceptionToJavadocFix.isApplicable((PsiJavaCodeReferenceElement)infos[1])) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ThrowsRuntimeExceptionFix(exceptionName), new MoveExceptionToJavadocFix(exceptionName)};
            if (inspectionGadgetsFixArray == null) {
                ThrowsRuntimeExceptionInspection.$$$reportNull$$$0(0);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ThrowsRuntimeExceptionFix(exceptionName)};
        if (inspectionGadgetsFixArray == null) {
            ThrowsRuntimeExceptionInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("throws.runtime.exception.problem.descriptor", new Object[0]);
        if (string == null) {
            ThrowsRuntimeExceptionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowsRuntimeExceptionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ThrowsRuntimeExceptionVisitor
    extends BaseInspectionVisitor {
        private ThrowsRuntimeExceptionVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            PsiJavaCodeReferenceElement[] referenceElements;
            super.visitMethod(method);
            PsiReferenceList throwsList = method.getThrowsList();
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = throwsList.getReferenceElements()) {
                PsiClass aClass;
                PsiElement target = referenceElement.resolve();
                if (!(target instanceof PsiClass) || !InheritanceUtil.isInheritor((PsiClass)(aClass = (PsiClass)target), (String)"java.lang.RuntimeException")) continue;
                String className2 = aClass.getName();
                this.registerError((PsiElement)referenceElement, className2, referenceElement);
            }
        }
    }

    private static class ThrowsRuntimeExceptionFix
    extends InspectionGadgetsFix {
        private final String myClassName;

        ThrowsRuntimeExceptionFix(String className2) {
            this.myClassName = className2;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("throws.runtime.exception.quickfix", this.myClassName);
            if (string == null) {
                ThrowsRuntimeExceptionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("throws.runtime.exception.fix.family.name", new Object[0]);
            if (string == null) {
                ThrowsRuntimeExceptionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            descriptor.getPsiElement().delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspection$ThrowsRuntimeExceptionFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MoveExceptionToJavadocFix
    extends InspectionGadgetsFix {
        private final String myExceptionName;

        MoveExceptionToJavadocFix(String exceptionName) {
            this.myExceptionName = exceptionName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("throws.runtime.exception.move.quickfix", this.myExceptionName);
            if (string == null) {
                MoveExceptionToJavadocFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("move.exception.to.javadoc.fix.family.name", new Object[0]);
            if (string == null) {
                MoveExceptionToJavadocFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)grandParent;
            PsiDocComment comment = method.getDocComment();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            if (comment != null) {
                PsiDocTag docTag = factory.createDocTagFromText("@throws " + element.getText());
                comment.add((PsiElement)docTag);
            } else {
                CodeDocumentationProvider codeDocumentationProvider;
                PsiDocComment docComment = factory.createDocCommentFromText("/** */");
                PsiComment resultComment = (PsiComment)method.addBefore((PsiElement)docComment, (PsiElement)method.getModifierList());
                DocumentationProvider documentationProvider = LanguageDocumentation.INSTANCE.forLanguage(method.getLanguage());
                if (documentationProvider instanceof CodeDocumentationProvider) {
                    codeDocumentationProvider = (CodeDocumentationProvider)documentationProvider;
                } else if (documentationProvider instanceof CompositeDocumentationProvider) {
                    CompositeDocumentationProvider compositeDocumentationProvider = (CompositeDocumentationProvider)documentationProvider;
                    codeDocumentationProvider = compositeDocumentationProvider.getFirstCodeDocumentationProvider();
                    if (codeDocumentationProvider == null) {
                        return;
                    }
                } else {
                    return;
                }
                String commentStub = codeDocumentationProvider.generateDocumentationContentStub(resultComment);
                PsiDocComment newComment = factory.createDocCommentFromText("/**\n" + commentStub + "*/");
                resultComment.replace((PsiElement)newComment);
            }
            element.delete();
        }

        public static boolean isApplicable(@NotNull PsiJavaCodeReferenceElement reference) {
            PsiDocTag[] tags;
            PsiElement parent;
            PsiElement grandParent;
            if (reference == null) {
                MoveExceptionToJavadocFix.$$$reportNull$$$0(2);
            }
            if (!((grandParent = (parent = reference.getParent()).getParent()) instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = (PsiMethod)grandParent;
            PsiDocComment docComment = method.getDocComment();
            if (docComment == null) {
                return true;
            }
            PsiElement throwsTarget = reference.resolve();
            if (throwsTarget == null) {
                return true;
            }
            for (PsiDocTag tag : tags = docComment.findTagsByName("throws")) {
                PsiJavaCodeReferenceElement referenceElement;
                PsiElement target;
                PsiElement grandChild;
                PsiElement child;
                PsiDocTagValue valueElement = tag.getValueElement();
                if (valueElement == null || (child = valueElement.getFirstChild()) == null || !((grandChild = child.getFirstChild()) instanceof PsiJavaCodeReferenceElement) || !throwsTarget.equals(target = (referenceElement = (PsiJavaCodeReferenceElement)grandChild).resolve())) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspection$MoveExceptionToJavadocFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/errorhandling/ThrowsRuntimeExceptionInspection$MoveExceptionToJavadocFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

