/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsToEqualityFix
extends InspectionGadgetsFix {
    private final boolean myNegated;

    private EqualsToEqualityFix(boolean negated) {
        this.myNegated = negated;
    }

    @Nullable
    public static EqualsToEqualityFix buildFix(PsiMethodCallExpression expressionToFix, boolean negated) {
        if (ExpressionUtils.isVoidContext((PsiExpression)expressionToFix)) {
            return null;
        }
        return new EqualsToEqualityFix(negated);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.myNegated ? CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"!equals()", "!="}) : CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"equals()", "=="});
        if (string == null) {
            EqualsToEqualityFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethodCallExpression.class, (boolean)false);
        EqualityCheck check = EqualityCheck.from((PsiExpression)call);
        if (check == null) {
            return;
        }
        PsiExpression lhs = check.getLeft();
        PsiExpression rhs = check.getRight();
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)call);
        CommentTracker commentTracker = new CommentTracker();
        String lhsText = commentTracker.text(lhs, 9);
        String rhsText = commentTracker.text(rhs, 9);
        if (parent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)parent)) {
            PsiReplacementUtil.replaceExpression((PsiExpression)parent, lhsText + "!=" + rhsText, commentTracker);
        } else {
            PsiReplacementUtil.replaceExpression((PsiExpression)call, lhsText + "==" + rhsText, commentTracker);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/EqualsToEqualityFix", "getFamilyName"));
    }
}

