/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ArrayLengthInLoopConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("array.length.in.loop.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            ArrayLengthInLoopConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayLengthInLoopConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection", "buildErrorString"));
    }

    private static class ArrayLengthInLoopConditionVisitor
    extends BaseInspectionVisitor {
        private ArrayLengthInLoopConditionVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                ArrayLengthInLoopConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitForStatement(statement);
            this.checkCondition((PsiConditionalLoopStatement)statement);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
            if (statement == null) {
                ArrayLengthInLoopConditionVisitor.$$$reportNull$$$0(1);
            }
            super.visitWhileStatement(statement);
            this.checkCondition((PsiConditionalLoopStatement)statement);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
            if (statement == null) {
                ArrayLengthInLoopConditionVisitor.$$$reportNull$$$0(2);
            }
            super.visitDoWhileStatement(statement);
            this.checkCondition((PsiConditionalLoopStatement)statement);
        }

        public void checkCondition(@NotNull PsiConditionalLoopStatement statement) {
            PsiExpression condition2;
            if (statement == null) {
                ArrayLengthInLoopConditionVisitor.$$$reportNull$$$0(3);
            }
            if ((condition2 = statement.getCondition()) == null) {
                return;
            }
            this.checkForArrayLength(condition2);
        }

        private void checkForArrayLength(PsiExpression condition2) {
            condition2.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
                    if (expression2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitReferenceExpression(expression2);
                    if (ExpressionUtils.getArrayFromLengthExpression((PsiExpression)expression2) != null) {
                        this.registerError(Objects.requireNonNull(expression2.getReferenceNameElement()), new Object[0]);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection$ArrayLengthInLoopConditionVisitor$1", "visitReferenceExpression"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection$ArrayLengthInLoopConditionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWhileStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDoWhileStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkCondition";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

