/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoggingConditionDisagreesWithLogStatementInspection
extends BaseInspection {
    private static final Set<String> loggingLevels = new HashSet<String>(Arrays.asList("debug", "error", "fatal", "info", "trace", "warn", "severe", "warning", "info", "config", "fine", "finer", "finest"));
    private static final Map<String, LoggingProblemChecker> problemCheckers = new HashMap<String, LoggingProblemChecker>();

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("logging.condition.disagrees.with.log.statement.problem.descriptor", infos[0]);
        if (string == null) {
            LoggingConditionDisagreesWithLogStatementInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LoggingConditionDisagreesWithLogStatementVisitor();
    }

    static {
        Log4jLikeProblemChecker checker = new Log4jLikeProblemChecker();
        problemCheckers.put("org.apache.log4j.Category", checker);
        problemCheckers.put("org.apache.logging.log4j.Logger", checker);
        problemCheckers.put("org.apache.commons.logging.Log", checker);
        problemCheckers.put("org.slf4j.Logger", checker);
        problemCheckers.put("java.util.logging.Logger", new JavaUtilLoggingProblemChecker());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/LoggingConditionDisagreesWithLogStatementInspection", "buildErrorString"));
    }

    private static class Log4jLikeProblemChecker
    implements LoggingProblemChecker {
        private Log4jLikeProblemChecker() {
        }

        @Override
        public boolean hasLoggingProblem(String priority, PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if ("isDebugEnabled".equals(methodName)) {
                return !"debug".equals(priority);
            }
            if ("isInfoEnabled".equals(methodName)) {
                return !"info".equals(priority);
            }
            if ("isTraceEnabled".equals(methodName)) {
                return !"trace".equals(priority);
            }
            if ("isWarnEnabled".equals(methodName)) {
                return !"warn".equals(priority);
            }
            if ("isErrorEnabled".equals(methodName)) {
                return !"error".equals(priority);
            }
            if ("isFatalEnabled".equals(methodName)) {
                return !"fatal".equals(priority);
            }
            if ("isEnabled".equals(methodName)) {
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                PsiExpression argument = arguments[0];
                if (!(argument instanceof PsiReferenceExpression)) {
                    return false;
                }
                if (!InheritanceUtil.isInheritor((PsiType)argument.getType(), (String)"org.apache.logging.log4j.Level")) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiField)) {
                    return false;
                }
                PsiField field = (PsiField)target;
                String fieldName = field.getName();
                return !StringUtil.toLowerCase((String)fieldName).equals(priority);
            }
            if ("isEnabledFor".equals(methodName)) {
                PsiExpression[] arguments;
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                    PsiElement argumentTarget;
                    PsiClassType classType;
                    PsiClass aClass;
                    if (!(argument instanceof PsiReferenceExpression)) continue;
                    PsiReferenceExpression argumentReference = (PsiReferenceExpression)argument;
                    PsiType type2 = argument.getType();
                    if (!(type2 instanceof PsiClassType) || !InheritanceUtil.isInheritor((PsiClass)(aClass = (classType = (PsiClassType)type2).resolve()), (String)"org.apache.log4j.Priority") || !((argumentTarget = argumentReference.resolve()) instanceof PsiField)) continue;
                    PsiField field = (PsiField)argumentTarget;
                    String fieldName = field.getName();
                    return !StringUtil.toLowerCase((String)fieldName).equals(priority);
                }
            }
            return false;
        }
    }

    private static class JavaUtilLoggingProblemChecker
    implements LoggingProblemChecker {
        private JavaUtilLoggingProblemChecker() {
        }

        @Override
        public boolean hasLoggingProblem(String priority, PsiMethodCallExpression methodCallExpression) {
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"isLoggable".equals(methodName)) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return false;
            }
            PsiExpression argument = arguments[0];
            String loggingLevel = JavaUtilLoggingProblemChecker.getLoggingLevelFromArgument(argument);
            if (loggingLevel == null) {
                return false;
            }
            return !loggingLevel.equals(priority);
        }

        @Nullable
        public static String getLoggingLevelFromArgument(PsiExpression argument) {
            if (!(argument instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression argumentReference = (PsiReferenceExpression)argument;
            if (!"java.util.logging.Level".equals(TypeUtils.resolvedClassName(argument.getType()))) {
                return null;
            }
            PsiElement argumentTarget = argumentReference.resolve();
            if (!(argumentTarget instanceof PsiField)) {
                return null;
            }
            PsiField field = (PsiField)argumentTarget;
            return StringUtil.toLowerCase((String)field.getName());
        }
    }

    static interface LoggingProblemChecker {
        public boolean hasLoggingProblem(String var1, PsiMethodCallExpression var2);
    }

    private static class LoggingConditionDisagreesWithLogStatementVisitor
    extends BaseInspectionVisitor {
        private LoggingConditionDisagreesWithLogStatementVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiExpression qualifier;
            PsiIfStatement ifStatement;
            PsiMethod method;
            String loggingLevel;
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null) {
                return;
            }
            if (!loggingLevels.contains(referenceName)) {
                if (!"log".equals(referenceName)) {
                    return;
                }
                PsiExpressionList argumentList = expression2.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length < 2) {
                    return;
                }
                PsiExpression argument = arguments[0];
                loggingLevel = JavaUtilLoggingProblemChecker.getLoggingLevelFromArgument(argument);
                if (loggingLevel == null) {
                    return;
                }
            } else {
                loggingLevel = referenceName;
            }
            if ((method = expression2.resolveMethod()) == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiElement parent = expression2.getParent();
            if (!(parent instanceof PsiExpressionStatement)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiCodeBlock) {
                PsiElement greatGrandParent = grandParent.getParent();
                if (!(greatGrandParent instanceof PsiBlockStatement)) {
                    return;
                }
                PsiElement greatGreatGrandParent = greatGrandParent.getParent();
                if (!(greatGreatGrandParent instanceof PsiIfStatement)) {
                    return;
                }
                ifStatement = (PsiIfStatement)greatGreatGrandParent;
            } else if (grandParent instanceof PsiIfStatement) {
                ifStatement = (PsiIfStatement)grandParent;
            } else {
                return;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 instanceof PsiMethodCallExpression) {
                PsiStatement thenBranch = ifStatement.getThenBranch();
                if (!PsiTreeUtil.isAncestor((PsiElement)thenBranch, (PsiElement)expression2, (boolean)false)) {
                    return;
                }
            } else if (condition2 instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition2;
                if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                    return;
                }
                PsiStatement elseBranch = ifStatement.getElseBranch();
                if (!PsiTreeUtil.isAncestor((PsiElement)elseBranch, (PsiElement)expression2, (boolean)false)) {
                    return;
                }
                condition2 = prefixExpression.getOperand();
                if (!(condition2 instanceof PsiMethodCallExpression)) {
                    return;
                }
            } else {
                return;
            }
            if (!((qualifier = methodExpression.getQualifierExpression()) instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (target == null) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)condition2;
            PsiReferenceExpression conditionMethodExpression = methodCallExpression.getMethodExpression();
            PsiExpression conditionQualifier = conditionMethodExpression.getQualifierExpression();
            if (!(conditionQualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression conditionReferenceExpression = (PsiReferenceExpression)conditionQualifier;
            PsiElement conditionTarget = conditionReferenceExpression.resolve();
            if (!target.equals(conditionTarget)) {
                return;
            }
            LoggingProblemChecker problemChecker = null;
            for (String superClassName : problemCheckers.keySet()) {
                if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)superClassName)) continue;
                problemChecker = (LoggingProblemChecker)problemCheckers.get(superClassName);
                break;
            }
            if (problemChecker == null || !problemChecker.hasLoggingProblem(loggingLevel, methodCallExpression)) {
                return;
            }
            this.registerMethodCallError(methodCallExpression, loggingLevel);
        }
    }
}

