/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.NegationCountVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ThreeNegationsPerMethodInspection
extends BaseInspection {
    public boolean m_ignoreInEquals = true;
    public boolean ignoreInAssert = false;

    @NotNull
    public String getID() {
        return "MethodWithMoreThanThreeNegations";
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("three.negations.per.method.ignore.option", new Object[0]), "m_ignoreInEquals");
        panel2.addCheckbox(InspectionGadgetsBundle.message("three.negations.per.method.ignore.assert.option", new Object[0]), "ignoreInAssert");
        return panel2;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer negationCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("three.negations.per.method.problem.descriptor", negationCount);
        if (string == null) {
            ThreeNegationsPerMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreeNegationsPerMethodVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/ThreeNegationsPerMethodInspection", "buildErrorString"));
    }

    private class ThreeNegationsPerMethodVisitor
    extends BaseInspectionVisitor {
        private ThreeNegationsPerMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                ThreeNegationsPerMethodVisitor.$$$reportNull$$$0(0);
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            NegationCountVisitor visitor2 = new NegationCountVisitor(ThreeNegationsPerMethodInspection.this.ignoreInAssert);
            method.accept((PsiElementVisitor)visitor2);
            int negationCount = visitor2.getCount();
            if (negationCount <= 3) {
                return;
            }
            if (ThreeNegationsPerMethodInspection.this.m_ignoreInEquals && MethodUtils.isEquals(method)) {
                return;
            }
            this.registerMethodError(method, negationCount);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/methodmetrics/ThreeNegationsPerMethodInspection$ThreeNegationsPerMethodVisitor", "visitMethod"));
        }
    }
}

