/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class NonExceptionNameEndsWithExceptionInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        String name2 = (String)infos[0];
        Boolean onTheFly = (Boolean)infos[1];
        if (onTheFly.booleanValue()) {
            InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new RenameFix(), new ExtendExceptionFix(name2)};
            if (inspectionGadgetsFixArray == null) {
                NonExceptionNameEndsWithExceptionInspection.$$$reportNull$$$0(0);
            }
            return inspectionGadgetsFixArray;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = new InspectionGadgetsFix[]{new ExtendExceptionFix(name2)};
        if (inspectionGadgetsFixArray == null) {
            NonExceptionNameEndsWithExceptionInspection.$$$reportNull$$$0(1);
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.problem.descriptor", new Object[0]);
        if (string == null) {
            NonExceptionNameEndsWithExceptionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonExceptionNameEndsWithExceptionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class NonExceptionNameEndsWithExceptionVisitor
    extends BaseInspectionVisitor {
        private NonExceptionNameEndsWithExceptionVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            String className2;
            if (aClass == null) {
                NonExceptionNameEndsWithExceptionVisitor.$$$reportNull$$$0(0);
            }
            if ((className2 = aClass.getName()) == null) {
                return;
            }
            String exception = "Exception";
            if (!className2.endsWith("Exception")) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Exception")) {
                return;
            }
            this.registerClassError(aClass, className2, this.isOnTheFly());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspection$NonExceptionNameEndsWithExceptionVisitor", "visitClass"));
        }
    }

    private static class ExtendExceptionFix
    extends InspectionGadgetsFix {
        private final String name;

        ExtendExceptionFix(String name2) {
            this.name = name2;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("non.exception.name.ends.with.exception.quickfix", this.name);
            if (string == null) {
                ExtendExceptionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("extend.exception.fix.family.name", new Object[0]);
            if (string == null) {
                ExtendExceptionFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = facade.getElementFactory();
            GlobalSearchScope scope = aClass.getResolveScope();
            PsiJavaCodeReferenceElement reference = factory.createReferenceElementByFQClassName("java.lang.Exception", scope);
            CommentTracker tracker = new CommentTracker();
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                tracker.delete((PsiElement)referenceElement);
            }
            tracker.insertCommentsBefore(extendsList.add((PsiElement)reference));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/naming/NonExceptionNameEndsWithExceptionInspection$ExtendExceptionFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

