/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.InheritanceUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InconvertibleTypesChecker {
    @Contract(pure=true)
    @Nullable
    public static TypeMismatch checkTypes(@NotNull PsiType leftType, @NotNull PsiType rightType, @NotNull LookForMutualSubclass lookForMutualSubclass) {
        if (leftType == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(0);
        }
        if (rightType == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(1);
        }
        if (lookForMutualSubclass == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(2);
        }
        if (TypeUtils.areConvertible(leftType, rightType) || TypeUtils.mayBeEqualByContract(leftType, rightType)) {
            return InconvertibleTypesChecker.deepCheck(leftType, rightType, lookForMutualSubclass);
        }
        return new TypeMismatch(leftType, rightType, false);
    }

    @Nullable
    public static TypeMismatch deepCheck(@NotNull PsiType leftType, @NotNull PsiType rightType, @NotNull LookForMutualSubclass lookForMutualSubclass) {
        if (leftType == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(3);
        }
        if (rightType == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(4);
        }
        if (lookForMutualSubclass == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(5);
        }
        return InconvertibleTypesChecker.deepCheck(leftType, rightType, new HashSet<Couple<PsiType>>(), lookForMutualSubclass);
    }

    @Nullable
    private static TypeMismatch deepCheck(@NotNull PsiType leftType, @NotNull PsiType rightType, @NotNull Set<Couple<PsiType>> checked, @NotNull LookForMutualSubclass lookForMutualSubclass) {
        if (leftType == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(6);
        }
        if (rightType == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(7);
        }
        if (checked == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(8);
        }
        if (lookForMutualSubclass == null) {
            InconvertibleTypesChecker.$$$reportNull$$$0(9);
        }
        if (leftType instanceof PsiCapturedWildcardType) {
            leftType = ((PsiCapturedWildcardType)leftType).getUpperBound();
        }
        if (rightType instanceof PsiCapturedWildcardType) {
            rightType = ((PsiCapturedWildcardType)rightType).getUpperBound();
        }
        if (!checked.add((Couple<PsiType>)Couple.of((Object)leftType, (Object)rightType))) {
            return null;
        }
        if (leftType.isAssignableFrom(rightType) || rightType.isAssignableFrom(leftType)) {
            return null;
        }
        PsiClass leftClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)leftType);
        PsiClass rightClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)rightType);
        if (leftClass == null || rightClass == null) {
            return null;
        }
        if (!rightClass.isInterface()) {
            PsiClass tmp = leftClass;
            leftClass = rightClass;
            rightClass = tmp;
        }
        if (leftClass == rightClass || TypeUtils.mayBeEqualByContract(leftType, rightType)) {
            PsiType[] rightParameters;
            PsiType[] leftParameters;
            if (leftType instanceof PsiClassType && rightType instanceof PsiClassType && (leftParameters = ((PsiClassType)leftType).getParameters()).length == (rightParameters = ((PsiClassType)rightType).getParameters()).length) {
                int length = leftParameters.length;
                for (int i = 0; i < length; ++i) {
                    PsiType leftParameter = leftParameters[i];
                    PsiType rightParameter = rightParameters[i];
                    if (!TypeUtils.areConvertible(leftParameter, rightParameter) && !TypeUtils.mayBeEqualByContract(leftParameter, rightParameter)) {
                        return new TypeMismatch(leftType, rightType, false);
                    }
                    TypeMismatch mismatch = InconvertibleTypesChecker.deepCheck(leftParameter, rightParameter, checked, lookForMutualSubclass);
                    if (mismatch == null) continue;
                    return mismatch;
                }
            }
        } else {
            if (TypeUtils.cannotBeEqualByContract(leftType, rightType)) {
                return new TypeMismatch(leftType, rightType, false);
            }
            if (lookForMutualSubclass != LookForMutualSubclass.NEVER && !InheritanceUtil.existsMutualSubclass(leftClass, rightClass, lookForMutualSubclass == LookForMutualSubclass.IF_CHEAP)) {
                return new TypeMismatch(leftType, rightType, true);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftType";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightType";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookForMutualSubclass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checked";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/InconvertibleTypesChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "deepCheck";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TypeMismatch {
        @NotNull
        private final PsiType myLeft;
        @NotNull
        private final PsiType myRight;
        private final boolean myConvertible;

        private TypeMismatch(@NotNull PsiType left, @NotNull PsiType right, boolean convertible) {
            if (left == null) {
                TypeMismatch.$$$reportNull$$$0(0);
            }
            if (right == null) {
                TypeMismatch.$$$reportNull$$$0(1);
            }
            this.myLeft = left;
            this.myRight = right;
            this.myConvertible = convertible;
        }

        @NotNull
        public PsiType getLeft() {
            PsiType psiType = this.myLeft;
            if (psiType == null) {
                TypeMismatch.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        @NotNull
        public PsiType getRight() {
            PsiType psiType = this.myRight;
            if (psiType == null) {
                TypeMismatch.$$$reportNull$$$0(3);
            }
            return psiType;
        }

        public boolean isConvertible() {
            return this.myConvertible;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/psiutils/InconvertibleTypesChecker$TypeMismatch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/psiutils/InconvertibleTypesChecker$TypeMismatch";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeft";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRight";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum LookForMutualSubclass {
        NEVER,
        ALWAYS,
        IF_CHEAP;

    }
}

