/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParenthesesUtils {
    public static final int METHOD_CALL_PRECEDENCE = 1;
    public static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int MULTIPLICATIVE_PRECEDENCE = 5;
    public static final int ADDITIVE_PRECEDENCE = 6;
    public static final int SHIFT_PRECEDENCE = 7;
    public static final int EQUALITY_PRECEDENCE = 9;
    public static final int BINARY_AND_PRECEDENCE = 10;
    public static final int BINARY_OR_PRECEDENCE = 12;
    public static final int AND_PRECEDENCE = 13;
    public static final int OR_PRECEDENCE = 14;
    public static final int CONDITIONAL_PRECEDENCE = 15;
    public static final int ASSIGNMENT_PRECEDENCE = 16;
    public static final int NUM_PRECEDENCES = 18;

    private ParenthesesUtils() {
    }

    public static boolean isCommutativeOperator(@NotNull IElementType token) {
        if (token == null) {
            ParenthesesUtils.$$$reportNull$$$0(0);
        }
        return PsiPrecedenceUtil.isCommutativeOperator((IElementType)token);
    }

    public static boolean isCommutativeOperation(PsiPolyadicExpression expression2) {
        return PsiPrecedenceUtil.isCommutativeOperation((PsiPolyadicExpression)expression2);
    }

    public static boolean isAssociativeOperation(PsiPolyadicExpression expression2) {
        return PsiPrecedenceUtil.isAssociativeOperation((PsiPolyadicExpression)expression2);
    }

    public static int getPrecedence(PsiExpression expression2) {
        return PsiPrecedenceUtil.getPrecedence((PsiExpression)expression2);
    }

    public static int getPrecedenceForOperator(@NotNull IElementType operator2) {
        if (operator2 == null) {
            ParenthesesUtils.$$$reportNull$$$0(1);
        }
        return PsiPrecedenceUtil.getPrecedenceForOperator((IElementType)operator2);
    }

    public static boolean areParenthesesNeeded(PsiParenthesizedExpression expression2, boolean ignoreClarifyingParentheses) {
        return PsiPrecedenceUtil.areParenthesesNeeded((PsiParenthesizedExpression)expression2, (boolean)ignoreClarifyingParentheses);
    }

    public static boolean areParenthesesNeeded(PsiExpression expression2, PsiExpression parentExpression, boolean ignoreClarifyingParentheses) {
        return PsiPrecedenceUtil.areParenthesesNeeded((PsiExpression)expression2, (PsiExpression)parentExpression, (boolean)ignoreClarifyingParentheses);
    }

    public static boolean areParenthesesNeeded(PsiJavaToken compoundAssignmentToken, PsiExpression rhs) {
        return PsiPrecedenceUtil.areParenthesesNeeded((PsiJavaToken)compoundAssignmentToken, (PsiExpression)rhs);
    }

    public static String getText(@NotNull PsiExpression expression2, int precedence) {
        if (expression2 == null) {
            ParenthesesUtils.$$$reportNull$$$0(2);
        }
        if (ParenthesesUtils.getPrecedence(expression2) >= precedence) {
            return '(' + expression2.getText() + ')';
        }
        return expression2.getText();
    }

    @Nullable
    public static PsiElement getParentSkipParentheses(PsiElement element) {
        PsiElement parent = element.getParent();
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression) {
            parent = parent.getParent();
        }
        return parent;
    }

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression stripParentheses(@Nullable PsiExpression expression2) {
        return PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
    }

    public static void removeParentheses(@NotNull PsiExpression expression2, boolean ignoreClarifyingParentheses) {
        if (expression2 == null) {
            ParenthesesUtils.$$$reportNull$$$0(3);
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2;
            ParenthesesUtils.removeParensFromMethodCallExpression(methodCall, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            ParenthesesUtils.removeParensFromReferenceExpression(referenceExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression2;
            ParenthesesUtils.removeParensFromNewExpression(newExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
            ParenthesesUtils.removeParensFromAssignmentExpression(assignmentExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiArrayInitializerExpression) {
            PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)expression2;
            ParenthesesUtils.removeParensFromArrayInitializerExpression(arrayInitializerExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
            ParenthesesUtils.removeParensFromTypeCastExpression(typeCastExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression2;
            ParenthesesUtils.removeParensFromArrayAccessExpression(arrayAccessExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            ParenthesesUtils.removeParensFromPrefixExpression(prefixExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiPostfixExpression) {
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)expression2;
            ParenthesesUtils.removeParensFromPostfixExpression(postfixExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            ParenthesesUtils.removeParensFromPolyadicExpression(polyadicExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression instanceofExpression = (PsiInstanceOfExpression)expression2;
            ParenthesesUtils.removeParensFromInstanceOfExpression(instanceofExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
            ParenthesesUtils.removeParensFromConditionalExpression(conditionalExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            ParenthesesUtils.removeParensFromParenthesizedExpression(parenthesizedExpression, ignoreClarifyingParentheses);
        } else if (expression2 instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)expression2;
            ParenthesesUtils.removeParensFromLambdaExpression(lambdaExpression, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromLambdaExpression(PsiLambdaExpression lambdaExpression, boolean ignoreClarifyingParentheses) {
        PsiElement body2 = lambdaExpression.getBody();
        if (body2 instanceof PsiExpression) {
            ParenthesesUtils.removeParentheses((PsiExpression)body2, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromReferenceExpression(@NotNull PsiReferenceExpression referenceExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression qualifier;
        if (referenceExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(4);
        }
        if ((qualifier = referenceExpression.getQualifierExpression()) != null) {
            ParenthesesUtils.removeParentheses(qualifier, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromParenthesizedExpression(@NotNull PsiParenthesizedExpression parenthesizedExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression body2;
        if (parenthesizedExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(5);
        }
        if ((body2 = parenthesizedExpression.getExpression()) == null) {
            return;
        }
        PsiElement parent = parenthesizedExpression.getParent();
        if (!(parent instanceof PsiExpression) || !ParenthesesUtils.areParenthesesNeeded(body2, (PsiExpression)parent, ignoreClarifyingParentheses)) {
            PsiExpression newExpression = ExpressionUtils.replacePolyadicWithParent((PsiExpression)parenthesizedExpression, body2);
            if (newExpression == null) {
                CommentTracker commentTracker = new CommentTracker();
                commentTracker.markUnchanged(body2);
                newExpression = (PsiExpression)commentTracker.replaceAndRestoreComments((PsiElement)parenthesizedExpression, (PsiElement)body2);
            }
            ParenthesesUtils.removeParentheses(newExpression, ignoreClarifyingParentheses);
        } else {
            ParenthesesUtils.removeParentheses(body2, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromConditionalExpression(@NotNull PsiConditionalExpression conditionalExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression elseBranch;
        if (conditionalExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(6);
        }
        PsiExpression condition2 = conditionalExpression.getCondition();
        ParenthesesUtils.removeParentheses(condition2, ignoreClarifyingParentheses);
        PsiExpression thenBranch = conditionalExpression.getThenExpression();
        if (thenBranch != null) {
            ParenthesesUtils.removeParentheses(thenBranch, ignoreClarifyingParentheses);
        }
        if ((elseBranch = conditionalExpression.getElseExpression()) != null) {
            ParenthesesUtils.removeParentheses(elseBranch, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromInstanceOfExpression(@NotNull PsiInstanceOfExpression instanceofExpression, boolean ignoreClarifyingParentheses) {
        if (instanceofExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(7);
        }
        PsiExpression operand2 = instanceofExpression.getOperand();
        ParenthesesUtils.removeParentheses(operand2, ignoreClarifyingParentheses);
    }

    private static void removeParensFromPolyadicExpression(@NotNull PsiPolyadicExpression polyadicExpression, boolean ignoreClarifyingParentheses) {
        if (polyadicExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(8);
        }
        for (PsiExpression operand2 : polyadicExpression.getOperands()) {
            if (!operand2.isValid()) break;
            ParenthesesUtils.removeParentheses(operand2, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromPostfixExpression(@NotNull PsiPostfixExpression postfixExpression, boolean ignoreClarifyingParentheses) {
        if (postfixExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(9);
        }
        PsiExpression operand2 = postfixExpression.getOperand();
        ParenthesesUtils.removeParentheses(operand2, ignoreClarifyingParentheses);
    }

    private static void removeParensFromPrefixExpression(@NotNull PsiPrefixExpression prefixExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression operand2;
        if (prefixExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(10);
        }
        if ((operand2 = prefixExpression.getOperand()) != null) {
            ParenthesesUtils.removeParentheses(operand2, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromArrayAccessExpression(@NotNull PsiArrayAccessExpression arrayAccessExpression, boolean ignoreClarifyingParentheses) {
        if (arrayAccessExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(11);
        }
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        ParenthesesUtils.removeParentheses(arrayExpression, ignoreClarifyingParentheses);
        PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
        if (indexExpression != null) {
            ParenthesesUtils.removeParentheses(indexExpression, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromTypeCastExpression(@NotNull PsiTypeCastExpression typeCastExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression operand2;
        if (typeCastExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(12);
        }
        if ((operand2 = typeCastExpression.getOperand()) != null) {
            ParenthesesUtils.removeParentheses(operand2, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromArrayInitializerExpression(@NotNull PsiArrayInitializerExpression arrayInitializerExpression, boolean ignoreClarifyingParentheses) {
        PsiExpression[] initializers;
        if (arrayInitializerExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(13);
        }
        for (PsiExpression initializer : initializers = arrayInitializerExpression.getInitializers()) {
            ParenthesesUtils.removeParentheses(initializer, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromAssignmentExpression(@NotNull PsiAssignmentExpression assignment, boolean ignoreClarifyingParentheses) {
        if (assignment == null) {
            ParenthesesUtils.$$$reportNull$$$0(14);
        }
        PsiExpression lhs = assignment.getLExpression();
        PsiExpression rhs = assignment.getRExpression();
        ParenthesesUtils.removeParentheses(lhs, ignoreClarifyingParentheses);
        if (rhs != null) {
            ParenthesesUtils.removeParentheses(rhs, ignoreClarifyingParentheses);
        }
    }

    private static void removeParensFromNewExpression(@NotNull PsiNewExpression newExpression, boolean ignoreClarifyingParentheses) {
        PsiExpressionList argumentList;
        PsiArrayInitializerExpression arrayInitializer;
        PsiExpression[] dimensions;
        if (newExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(15);
        }
        for (PsiExpression dimension : dimensions = newExpression.getArrayDimensions()) {
            ParenthesesUtils.removeParentheses(dimension, ignoreClarifyingParentheses);
        }
        PsiExpression qualifier = newExpression.getQualifier();
        if (qualifier != null) {
            ParenthesesUtils.removeParentheses(qualifier, ignoreClarifyingParentheses);
        }
        if ((arrayInitializer = newExpression.getArrayInitializer()) != null) {
            ParenthesesUtils.removeParentheses((PsiExpression)arrayInitializer, ignoreClarifyingParentheses);
        }
        if ((argumentList = newExpression.getArgumentList()) != null) {
            PsiExpression[] arguments;
            for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                ParenthesesUtils.removeParentheses(argument, ignoreClarifyingParentheses);
            }
        }
    }

    private static void removeParensFromMethodCallExpression(@NotNull PsiMethodCallExpression methodCallExpression, boolean ignoreClarifyingParentheses) {
        if (methodCallExpression == null) {
            ParenthesesUtils.$$$reportNull$$$0(16);
        }
        PsiReferenceExpression target = methodCallExpression.getMethodExpression();
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        ParenthesesUtils.removeParentheses((PsiExpression)target, ignoreClarifyingParentheses);
        for (PsiExpression argument : arguments) {
            ParenthesesUtils.removeParentheses(argument, ignoreClarifyingParentheses);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parenthesizedExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditionalExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceofExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "polyadicExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayAccessExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeCastExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayInitializerExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ig/psiutils/ParenthesesUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCommutativeOperator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrecedenceForOperator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParentheses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromReferenceExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromParenthesizedExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromConditionalExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromInstanceOfExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPolyadicExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPostfixExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromPrefixExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromArrayAccessExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromTypeCastExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromArrayInitializerExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromAssignmentExpression";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromNewExpression";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "removeParensFromMethodCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

