/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SystemRunFinalizersOnExitInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToSystemRunFinalizersOnExit";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("system.run.finalizers.on.exit.problem.descriptor", new Object[0]);
        if (string == null) {
            SystemRunFinalizersOnExitInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemRunFinalizersOnExitVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/SystemRunFinalizersOnExitInspection", "buildErrorString"));
    }

    private static class SystemRunFinalizersOnExitVisitor
    extends BaseInspectionVisitor {
        private SystemRunFinalizersOnExitVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            if (expression2 == null) {
                SystemRunFinalizersOnExitVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression2);
            if (!SystemRunFinalizersOnExitVisitor.isRunFinalizersOnExit(expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean isRunFinalizersOnExit(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String runFinalizers = "runFinalizersOnExit";
            if (!"runFinalizersOnExit".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className2 = aClass.getQualifiedName();
            if (className2 == null) {
                return false;
            }
            return "java.lang.System".equals(className2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/threading/SystemRunFinalizersOnExitInspection$SystemRunFinalizersOnExitVisitor", "visitMethodCallExpression"));
        }
    }
}

