/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldStaticFinalFix;
import org.jetbrains.annotations.NotNull;

public class ThreadLocalNotStaticFinalInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.local.not.static.final.problem.descriptor", new Object[0]);
        if (string == null) {
            ThreadLocalNotStaticFinalInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return MakeFieldStaticFinalFix.buildFix((PsiField)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadLocalNotStaticFinalVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/threading/ThreadLocalNotStaticFinalInspection", "buildErrorString"));
    }

    private static class ThreadLocalNotStaticFinalVisitor
    extends BaseInspectionVisitor {
        private ThreadLocalNotStaticFinalVisitor() {
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            PsiType type2 = field.getType();
            if (!InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.ThreadLocal")) {
                return;
            }
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) {
                return;
            }
            if (modifierList.hasModifierProperty("static") && modifierList.hasModifierProperty("final")) {
                return;
            }
            this.registerFieldError(field, field);
        }
    }
}

