/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.IndexedForEachLoopPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceForEachLoopWithIndexedForLoopIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new IndexedForEachLoopPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiForeachStatement elementToReplace;
        PsiForeachStatement statement;
        if (element == null) {
            ReplaceForEachLoopWithIndexedForLoopIntention.$$$reportNull$$$0(0);
        }
        if ((statement = (PsiForeachStatement)element.getParent()) == null) {
            return;
        }
        PsiExpression iteratedValue2 = statement.getIteratedValue();
        if (iteratedValue2 == null) {
            return;
        }
        PsiParameter iterationParameter = statement.getIterationParameter();
        PsiType type2 = iterationParameter.getType();
        PsiType iteratedValueType = iteratedValue2.getType();
        if (iteratedValueType == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        boolean isArray = iteratedValueType instanceof PsiArrayType;
        PsiElement parent = statement.getParent();
        PsiForeachStatement context = parent instanceof PsiLabeledStatement ? (PsiStatement)parent : statement;
        PsiElement reference = ReplaceForEachLoopWithIndexedForLoopIntention.getReferenceToIterate(iteratedValue2, (PsiElement)context);
        StringBuilder newStatement = new StringBuilder();
        String indexText = ReplaceForEachLoopWithIndexedForLoopIntention.createVariableName("i", (PsiType)PsiType.INT, (PsiElement)statement);
        String iteratedValueText = reference instanceof PsiVariable ? ((PsiVariable)reference).getName() : tracker.text(reference);
        this.createForLoopDeclaration(statement, isArray, iteratedValueText, indexText, newStatement);
        if (JavaCodeStyleSettings.getInstance((PsiFile)statement.getContainingFile()).GENERATE_FINAL_LOCALS) {
            newStatement.append("final ");
        }
        newStatement.append(type2.getCanonicalText());
        newStatement.append(' ');
        newStatement.append(iterationParameter.getName());
        newStatement.append('=');
        newStatement.append(iteratedValueText);
        if (isArray) {
            newStatement.append('[');
            newStatement.append(indexText);
            newStatement.append("];");
        } else {
            newStatement.append(".get(");
            newStatement.append(indexText);
            newStatement.append(");");
        }
        PsiStatement body2 = statement.getBody();
        if (body2 == null) {
            return;
        }
        if (body2 instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)body2).getCodeBlock();
            PsiElement[] children = block.getChildren();
            for (int i = 1; i < children.length - 1; ++i) {
                newStatement.append(tracker.text(children[i]));
            }
        } else {
            newStatement.append(tracker.text((PsiElement)body2));
        }
        newStatement.append('}');
        if (reference instanceof PsiVariable) {
            if (!(context.getParent() instanceof PsiCodeBlock)) {
                context = BlockUtils.expandSingleStatementToBlockStatement(context);
            }
            PsiElement newElement = context.getParent().addBefore(reference.getParent(), (PsiElement)context);
            JavaCodeStyleManager.getInstance((Project)context.getProject()).shortenClassReferences(newElement);
        }
        Object object = elementToReplace = context instanceof PsiLabeledStatement ? ((PsiLabeledStatement)context).getStatement() : context;
        assert (elementToReplace != null);
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)elementToReplace, newStatement.toString(), tracker);
    }

    protected void createForLoopDeclaration(PsiForeachStatement statement, boolean array, String iteratedValueText, String indexText, StringBuilder newStatement) {
        newStatement.append("for(int ");
        newStatement.append(indexText);
        newStatement.append("=0;");
        newStatement.append(indexText);
        newStatement.append('<');
        newStatement.append(iteratedValueText);
        newStatement.append(array ? ".length;" : ".size();");
        newStatement.append(indexText);
        newStatement.append("++){");
    }

    @Nullable
    private static String getVariableName(PsiExpression expression2) {
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name2 = methodExpression.getReferenceName();
            if (name2 == null) {
                return null;
            }
            if (name2.startsWith("to") && name2.length() > 2) {
                return StringUtil.decapitalize((String)name2.substring(2));
            }
            if (name2.startsWith("get") && name2.length() > 3) {
                return StringUtil.decapitalize((String)name2.substring(3));
            }
            return name2;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)expression2;
            PsiExpression operand2 = castExpression.getOperand();
            return ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(operand2);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression2;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            String name3 = ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(arrayExpression);
            return name3 == null ? null : StringUtil.unpluralize((String)name3);
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression innerExpression = parenthesizedExpression.getExpression();
            return ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(innerExpression);
        }
        if (expression2 instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)expression2;
            String referenceName = referenceElement.getReferenceName();
            if (referenceName == null) {
                return expression2.getText();
            }
            return referenceName;
        }
        return null;
    }

    private static PsiElement getReferenceToIterate(PsiExpression expression2, PsiElement context) {
        if (expression2 instanceof PsiMethodCallExpression || expression2 instanceof PsiTypeCastExpression || expression2 instanceof PsiArrayAccessExpression || expression2 instanceof PsiNewExpression) {
            String variableName2 = ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(expression2);
            return ReplaceForEachLoopWithIndexedForLoopIntention.createVariable(variableName2, expression2, context);
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression innerExpression = parenthesizedExpression.getExpression();
            return ReplaceForEachLoopWithIndexedForLoopIntention.getReferenceToIterate(innerExpression, context);
        }
        if (expression2 instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)expression2;
            String variableName3 = ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(expression2);
            if (referenceElement.isQualified()) {
                return ReplaceForEachLoopWithIndexedForLoopIntention.createVariable(variableName3, expression2, context);
            }
            PsiElement target = referenceElement.resolve();
            if (target instanceof PsiVariable) {
                return referenceElement;
            }
            return ReplaceForEachLoopWithIndexedForLoopIntention.createVariable(variableName3, expression2, context);
        }
        return expression2;
    }

    private static PsiVariable createVariable(String variableNameRoot, PsiExpression iteratedValue2, PsiElement context) {
        String variableName2 = ReplaceForEachLoopWithIndexedForLoopIntention.createVariableName(variableNameRoot, iteratedValue2);
        Project project = context.getProject();
        PsiType iteratedValueType = iteratedValue2.getType();
        assert (iteratedValueType != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiDeclarationStatement declarationStatement = elementFactory.createVariableDeclarationStatement(variableName2, iteratedValueType, iteratedValue2);
        return (PsiVariable)declarationStatement.getDeclaredElements()[0];
    }

    public static String createVariableName(@Nullable String baseName, @NotNull PsiExpression assignedExpression) {
        if (assignedExpression == null) {
            ReplaceForEachLoopWithIndexedForLoopIntention.$$$reportNull$$$0(1);
        }
        return new VariableNameGenerator((PsiElement)assignedExpression, VariableKind.LOCAL_VARIABLE).byName(baseName).byExpression(assignedExpression).byType(assignedExpression.getType()).generate(true);
    }

    public static String createVariableName(@Nullable String baseName, @NotNull PsiType type2, @NotNull PsiElement context) {
        if (type2 == null) {
            ReplaceForEachLoopWithIndexedForLoopIntention.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ReplaceForEachLoopWithIndexedForLoopIntention.$$$reportNull$$$0(3);
        }
        return new VariableNameGenerator(context, VariableKind.LOCAL_VARIABLE).byName(baseName).byType(type2).generate(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/siyeh/ipp/forloop/ReplaceForEachLoopWithIndexedForLoopIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntention";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createVariableName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

