/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.treeConflict;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vcs.changes.patch.TextFilePatchInProgress;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchSaveToFileExecutor
implements ApplyPatchExecutor<TextFilePatchInProgress> {
    private static final Logger LOG = Logger.getInstance(ApplyPatchSaveToFileExecutor.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final VirtualFile myNewPatchBase;

    public ApplyPatchSaveToFileExecutor(@NotNull Project project, @Nullable VirtualFile newPatchBase) {
        if (project == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myNewPatchBase = newPatchBase;
    }

    public String getName() {
        return "Save Patch to File";
    }

    public void apply(@NotNull List<? extends FilePatch> remaining, @NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroupsToApply, @Nullable LocalChangeList localList, @Nullable String fileName, @Nullable ThrowableComputable<? extends Map<String, Map<String, CharSequence>>, PatchSyntaxException> additionalInfo) {
        FileSaverDialog dialog;
        VirtualFileWrapper targetFile;
        if (remaining == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(1);
        }
        if (patchGroupsToApply == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(2);
        }
        if ((targetFile = (dialog = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save Patch to", "", new String[0]), this.myProject)).save(this.myProject.getBaseDir(), "TheirsChanges.patch")) != null) {
            this.savePatch(patchGroupsToApply, targetFile);
        }
    }

    private void savePatch(@NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroups, @NotNull VirtualFileWrapper targetFile) {
        if (patchGroups == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(3);
        }
        if (targetFile == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(4);
        }
        VirtualFile newPatchBase = (VirtualFile)ObjectUtils.notNull((Object)this.myNewPatchBase, (Object)this.myProject.getBaseDir());
        try {
            List<FilePatch> textPatches = ApplyPatchSaveToFileExecutor.toOnePatchGroup(patchGroups, newPatchBase);
            PatchWriter.writePatches((Project)this.myProject, (String)targetFile.getFile().getPath(), (String)newPatchBase.getPath(), textPatches, (CommitContext)new CommitContext(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{e.getMessage()}), (String)CommonBundle.getErrorTitle()), null, (Project)this.myProject);
        }
    }

    @NotNull
    public static List<FilePatch> toOnePatchGroup(@NotNull MultiMap<VirtualFile, TextFilePatchInProgress> patchGroups, @NotNull VirtualFile newPatchBase) throws IOException {
        if (patchGroups == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(5);
        }
        if (newPatchBase == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(6);
        }
        ArrayList<FilePatch> result = new ArrayList<FilePatch>();
        for (Map.Entry entry : patchGroups.entrySet()) {
            VirtualFile oldPatchBase = (VirtualFile)entry.getKey();
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)oldPatchBase, (VirtualFile)newPatchBase, (char)'/');
            boolean toConvert = !StringUtil.isEmptyOrSpaces((String)relativePath) && !".".equals(relativePath);
            for (TextFilePatchInProgress patchInProgress : (Collection)entry.getValue()) {
                TextFilePatch patch = (TextFilePatch)patchInProgress.getPatch();
                if (toConvert) {
                    patch.setBeforeName(ApplyPatchSaveToFileExecutor.getNewBaseRelativePath(newPatchBase, oldPatchBase, patch.getBeforeName()));
                    patch.setAfterName(ApplyPatchSaveToFileExecutor.getNewBaseRelativePath(newPatchBase, oldPatchBase, patch.getAfterName()));
                }
                result.add((FilePatch)patch);
            }
        }
        ArrayList<FilePatch> arrayList = result;
        if (arrayList == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    private static String getNewBaseRelativePath(@NotNull VirtualFile newBase, @NotNull VirtualFile oldBase, @Nullable String oldBaseRelativePath) throws IOException {
        if (newBase == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(8);
        }
        if (oldBase == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(9);
        }
        return !StringUtil.isEmptyOrSpaces((String)oldBaseRelativePath) ? FileUtil.getRelativePath((String)newBase.getPath(), (String)ApplyPatchSaveToFileExecutor.getCanonicalPath(oldBase, oldBaseRelativePath), (char)'/') : oldBaseRelativePath;
    }

    @NotNull
    private static String getCanonicalPath(@NotNull VirtualFile base, @NotNull String relativePath) throws IOException {
        if (base == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(10);
        }
        if (relativePath == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(11);
        }
        String string = FileUtil.toSystemIndependentName((String)new File(base.getPath(), relativePath).getCanonicalPath());
        if (string == null) {
            ApplyPatchSaveToFileExecutor.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remaining";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchGroupsToApply";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchGroups";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPatchBase";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldBase";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/treeConflict/ApplyPatchSaveToFileExecutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toOnePatchGroup";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "savePatch";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toOnePatchGroup";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNewBaseRelativePath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

