/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import com.jogamp.opengl.GL2;
import java.awt.Rectangle;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

class CefRenderer {
    private boolean transparent_;
    private GL2 initialized_context_ = null;
    private int[] texture_id_ = new int[1];
    private int view_width_ = 0;
    private int view_height_ = 0;
    private float spin_x_ = 0.0f;
    private float spin_y_ = 0.0f;
    private Rectangle popup_rect_ = new Rectangle(0, 0, 0, 0);
    private Rectangle original_popup_rect_ = new Rectangle(0, 0, 0, 0);
    private boolean use_draw_pixels_ = false;

    protected CefRenderer(boolean transparent) {
        this.transparent_ = transparent;
    }

    protected boolean isTransparent() {
        return this.transparent_;
    }

    protected void initialize(GL2 gl2) {
        if (this.initialized_context_ == gl2) {
            return;
        }
        this.initialized_context_ = gl2;
        if (!gl2.getContext().isHardwareRasterizer()) {
            System.out.println("opengl rendering may be slow as hardware rendering isn't available");
            this.use_draw_pixels_ = true;
            return;
        }
        gl2.glHint(3155, 4354);
        gl2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gl2.glPixelStorei(3317, 1);
        gl2.glGenTextures(1, this.texture_id_, 0);
        assert (this.texture_id_[0] != 0);
        gl2.glBindTexture(3553, this.texture_id_[0]);
        gl2.glTexParameteri(3553, 10241, 9728);
        gl2.glTexParameteri(3553, 10240, 9728);
        gl2.glTexEnvf(8960, 8704, 8448.0f);
    }

    protected void cleanup(GL2 gl2) {
        if (this.texture_id_[0] != 0) {
            gl2.glDeleteTextures(1, this.texture_id_, 0);
        }
    }

    protected void render(GL2 gl2) {
        if (this.use_draw_pixels_ || this.view_width_ == 0 || this.view_height_ == 0) {
            return;
        }
        assert (this.initialized_context_ != null);
        float[] vertex_data = new float[]{0.0f, 1.0f, -1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f};
        FloatBuffer vertices = FloatBuffer.wrap(vertex_data);
        gl2.glClear(0x4000 | 0x100);
        gl2.glMatrixMode(5888);
        gl2.glLoadIdentity();
        gl2.glViewport(0, 0, this.view_width_, this.view_height_);
        gl2.glMatrixMode(5889);
        gl2.glLoadIdentity();
        gl2.glPushAttrib(1048575);
        gl2.glBegin(7);
        gl2.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
        gl2.glVertex2f(-1.0f, -1.0f);
        gl2.glVertex2f(1.0f, -1.0f);
        gl2.glColor4f(0.0f, 0.0f, 1.0f, 1.0f);
        gl2.glVertex2f(1.0f, 1.0f);
        gl2.glVertex2f(-1.0f, 1.0f);
        gl2.glEnd();
        gl2.glPopAttrib();
        if (this.spin_x_ != 0.0f) {
            gl2.glRotatef(-this.spin_x_, 1.0f, 0.0f, 0.0f);
        }
        if (this.spin_y_ != 0.0f) {
            gl2.glRotatef(-this.spin_y_, 0.0f, 1.0f, 0.0f);
        }
        if (this.transparent_) {
            gl2.glBlendFunc(1, 771);
            gl2.glEnable(3042);
        }
        gl2.glEnable(3553);
        assert (this.texture_id_[0] != 0);
        gl2.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        gl2.glBindTexture(3553, this.texture_id_[0]);
        gl2.glInterleavedArrays(10791, 0, (Buffer)vertices);
        gl2.glDrawArrays(7, 0, 4);
        gl2.glDisable(3553);
        if (this.transparent_) {
            gl2.glDisable(3042);
        }
    }

    protected void onPopupSize(Rectangle rect) {
        if (rect.width <= 0 || rect.height <= 0) {
            return;
        }
        this.original_popup_rect_ = rect;
        this.popup_rect_ = this.getPopupRectInWebView(this.original_popup_rect_);
    }

    protected Rectangle getPopupRect() {
        return (Rectangle)this.popup_rect_.clone();
    }

    protected Rectangle getPopupRectInWebView(Rectangle original_rect) {
        Rectangle rc = original_rect;
        if (rc.x < 0) {
            rc.x = 0;
        }
        if (rc.y < 0) {
            rc.y = 0;
        }
        if (rc.x + rc.width > this.view_width_) {
            rc.x = this.view_width_ - rc.width;
        }
        if (rc.y + rc.height > this.view_height_) {
            rc.y = this.view_height_ - rc.height;
        }
        if (rc.x < 0) {
            rc.x = 0;
        }
        if (rc.y < 0) {
            rc.y = 0;
        }
        return rc;
    }

    protected void clearPopupRects() {
        this.popup_rect_.setBounds(0, 0, 0, 0);
        this.original_popup_rect_.setBounds(0, 0, 0, 0);
    }

    protected void onPaint(GL2 gl2, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        this.initialize(gl2);
        if (this.use_draw_pixels_) {
            gl2.glRasterPos2f(-1.0f, 1.0f);
            gl2.glPixelZoom(1.0f, -1.0f);
            gl2.glDrawPixels(width, height, 32993, 5121, (Buffer)buffer);
            return;
        }
        if (this.transparent_) {
            gl2.glEnable(3042);
        }
        gl2.glEnable(3553);
        assert (this.texture_id_[0] != 0);
        gl2.glBindTexture(3553, this.texture_id_[0]);
        if (!popup) {
            int old_width = this.view_width_;
            int old_height = this.view_height_;
            this.view_width_ = width;
            this.view_height_ = height;
            gl2.glPixelStorei(3314, this.view_width_);
            if (old_width != this.view_width_ || old_height != this.view_height_) {
                gl2.glPixelStorei(3316, 0);
                gl2.glPixelStorei(3315, 0);
                gl2.glTexImage2D(3553, 0, 6408, this.view_width_, this.view_height_, 0, 32993, 33639, (Buffer)buffer);
            } else {
                for (int i = 0; i < dirtyRects.length; ++i) {
                    Rectangle rect = dirtyRects[i];
                    gl2.glPixelStorei(3316, rect.x);
                    gl2.glPixelStorei(3315, rect.y);
                    gl2.glTexSubImage2D(3553, 0, rect.x, rect.y, rect.width, rect.height, 32993, 33639, (Buffer)buffer);
                }
            }
        } else if (popup && this.popup_rect_.width > 0 && this.popup_rect_.height > 0) {
            int skip_pixels = 0;
            int x = this.popup_rect_.x;
            int skip_rows = 0;
            int y = this.popup_rect_.y;
            int w = width;
            int h = height;
            if (x < 0) {
                skip_pixels = -x;
                x = 0;
            }
            if (y < 0) {
                skip_rows = -y;
                y = 0;
            }
            if (x + w > this.view_width_) {
                w -= x + w - this.view_width_;
            }
            if (y + h > this.view_height_) {
                h -= y + h - this.view_height_;
            }
            gl2.glPixelStorei(3314, width);
            gl2.glPixelStorei(3316, skip_pixels);
            gl2.glPixelStorei(3315, skip_rows);
            gl2.glTexSubImage2D(3553, 0, x, y, w, h, 32993, 33639, (Buffer)buffer);
        }
        gl2.glDisable(3553);
        if (this.transparent_) {
            gl2.glDisable(3042);
        }
    }

    protected void setSpin(float spinX, float spinY) {
        this.spin_x_ = spinX;
        this.spin_y_ = spinY;
    }

    protected void incrementSpin(float spinDX, float spinDY) {
        this.spin_x_ -= spinDX;
        this.spin_y_ -= spinDY;
    }
}

