/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.AntBuildModelBase;
import com.intellij.lang.ant.config.AntBuildTargetBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.execution.ExecutionHandler;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.BuildTask;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomRecursiveVisitor;
import com.intellij.lang.ant.dom.AntDomTarget;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class AntBuildTargetImpl
implements AntBuildTargetBase {
    private final AntBuildModelBase myModel;
    private final VirtualFile myFile;
    private final boolean myIsDefault;
    private final int myHashCode;
    private final String myName;
    private final String myDisplayName;
    private final String myDescription;
    private final Project myProject;
    private final int myTextOffset;

    public AntBuildTargetImpl(AntDomTarget target, AntBuildModelBase buildModel, VirtualFile sourceFile, boolean isImported, boolean isDefault) {
        this.myModel = buildModel;
        this.myFile = sourceFile;
        this.myIsDefault = isDefault;
        this.myHashCode = target.hashCode();
        this.myName = target.getName().getRawText();
        String name = target.getName().getRawText();
        if (isImported) {
            String projectName = target.getAntProject().getName().getRawText();
            name = projectName + "." + name;
        }
        this.myDisplayName = name;
        this.myProject = target.getManager().getProject();
        DomTarget domTarget = DomTarget.getTarget((DomElement)target);
        this.myTextOffset = domTarget != null ? domTarget.getTextOffset() : target.getXmlTag().getTextOffset();
        String desc = target.getDescription().getRawText();
        this.myDescription = desc != null && desc.trim().length() > 0 ? desc : null;
    }

    public int hashCode() {
        return this.myHashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AntBuildTargetImpl)) {
            return false;
        }
        AntBuildTargetImpl that = (AntBuildTargetImpl)obj;
        return Objects.equals(this.myName, that.myName) && Comparing.equal((Object)this.myFile, (Object)that.myFile);
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myName;
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    @Nullable
    public String getNotEmptyDescription() {
        return this.myDescription;
    }

    @Override
    public boolean isDefault() {
        return this.myIsDefault;
    }

    @Override
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @Override
    public AntBuildModelBase getModel() {
        return this.myModel;
    }

    @Override
    @Nullable
    public String getActionId() {
        StringBuilder name = new StringBuilder();
        name.append(AntConfiguration.getActionIdPrefix(this.myModel.getBuildFile().getProject()));
        String modelName = this.myModel.getName();
        if (!StringUtil.isEmptyOrSpaces((String)modelName)) {
            name.append("_").append(modelName);
        }
        name.append('_').append(this.getName());
        return name.toString();
    }

    @Override
    @Nullable
    public BuildTask findTask(final String taskName) {
        AntDomTarget antTarget;
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(this.myFile);
        AntDomProject domProject = AntSupport.getAntDomProject(psiFile);
        if (domProject != null && (antTarget = domProject.findDeclaredTarget(this.myName)) != null) {
            final Ref result = new Ref(null);
            antTarget.accept(new AntDomRecursiveVisitor(){

                @Override
                public void visitAntDomElement(AntDomElement element) {
                    if (result.get() != null) {
                        return;
                    }
                    if (element.isTask() && taskName.equals(element.getXmlElementName())) {
                        result.set((Object)element);
                        return;
                    }
                    super.visitAntDomElement(element);
                }
            });
            AntDomElement task = (AntDomElement)result.get();
            if (task != null) {
                return new BuildTask(this, task);
            }
        }
        return null;
    }

    @Override
    public Navigatable getOpenFileDescriptor() {
        return this.myFile == null ? null : PsiNavigationSupport.getInstance().createNavigatable(this.myProject, this.myFile, this.myTextOffset);
    }

    @Override
    public void run(DataContext dataContext, List<BuildFileProperty> additionalProperties, AntBuildListener buildListener) {
        AntBuildModelBase model = this.getModel();
        if (model == null) {
            buildListener.buildFinished(2, 0);
            throw new IllegalStateException("Target '" + this.getName() + "' is invalid: model is null");
        }
        AntBuildFile buildFile = model.getBuildFile();
        if (buildFile == null) {
            buildListener.buildFinished(2, 0);
            throw new IllegalStateException("Target '" + this.getName() + "' is invalid: build file is null");
        }
        ExecutionHandler.runBuild((AntBuildFileBase)buildFile, this.isDefault() ? Collections.emptyList() : this.getTargetNames(), null, dataContext, additionalProperties, buildListener);
    }
}

